/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.ports.InDouble;

public class Skew
extends ToneEffect {
    public InDouble inStrength = new InDouble("strength", "Center displacement", 0.0, -1.0, 1.0);
    private double strength;
    private double center;

    public Skew() {
        super("music.effect.skew", "Displace center");
    }

    protected boolean isModified() {
        return this.inStrength.isModified();
    }

    protected void updateParameters() {
        this.strength = (Double)this.inStrength.read();
        this.center = (this.strength + 1.0) / 2.0;
    }

    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            public double getSample(double offTime, double begTime, double endTime) {
                return this.source.getSample(offTime, this.skew(begTime), this.skew(endTime));
            }

            private double skew(double time) {
                double offset;
                double period = this.source.getPeriod();
                if (time > period) {
                    time -= Math.floor(time / period) * period;
                }
                double skewed = (offset = time / period) < Skew.this.center ? offset * 0.5 / Skew.this.center : (offset - Skew.this.center) * 0.5 / (1.0 - Skew.this.center) + 0.5;
                return skewed * period;
            }
        };
    }
}

