/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.ports.InTone;
import org.corebounce.decklight.bouncelets.music.ports.OutTone;
import org.corebounce.utils.Log;

public abstract class ToneEffect
extends Bouncelet {
    public InTone inTone = new InTone("in", "Input tone");
    public OutTone outTone = new OutTone("out", "Output tone");
    private Tone result;
    private double lastChangeTime = 0.0;

    public ToneEffect(String name, String description) {
        super(name, description);
    }

    protected abstract boolean isModified();

    protected boolean isToneModified() {
        return this.inTone.isModified();
    }

    protected double getLastChangeTime() {
        return this.lastChangeTime;
    }

    protected abstract void updateParameters();

    protected void updateTone(Tone source) {
    }

    protected abstract Tone createTranform(Tone var1);

    public void cycle() {
        if (this.isModified()) {
            this.updateParameters();
            this.lastChangeTime = super.getTime();
            Log.debug("Parameters modified in {0}", this);
        }
        if (this.isToneModified()) {
            Tone source = (Tone)this.inTone.read();
            if (source != null) {
                double toneChangeTime = source.getLastChangeTime();
                if (toneChangeTime > this.lastChangeTime) {
                    this.lastChangeTime = toneChangeTime;
                    this.updateTone(source);
                }
                this.result = this.createTranform(source);
                this.outTone.write(this.result);
                this.lastChangeTime = super.getTime();
                Log.debug("Source tone modified in {0}", this);
            }
        } else {
            this.outTone.setModified(false);
        }
    }
}

