/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.tone;

import org.corebounce.decklight.bouncelets.music.Tone;

public class SquareTone
extends Tone {
    public double getSample(double offTime, double begTime, double endTime) {
        double begAngle = this.getAngle(begTime);
        double endAngle = this.getAngle(endTime);
        if (endAngle < 0.5) {
            return -1.0;
        }
        if (endAngle >= 0.5 && begAngle < 0.5) {
            double prevWeight = 0.5 - begAngle;
            double nextWeight = endAngle - 0.5;
            double total = endAngle - begAngle;
            return (-1.0 * prevWeight + 1.0 * nextWeight) / total;
        }
        if (endAngle < 0.5 && begAngle >= 0.5) {
            double prevWeight = 1.0 - begAngle;
            double nextWeight = endAngle;
            double total = endAngle + 1.0 - begAngle;
            return (1.0 * prevWeight - 1.0 * nextWeight) / total;
        }
        return 1.0;
    }
}

