/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.signal;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.FlowEngine;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.OutDouble;

public class IfNegative
extends Bouncelet {
    public InDouble inValue = new InDouble("arg", "Value to test");
    public InDouble inThen = new InDouble("then", "Value to return if 'in' < 0");
    public InDouble inElse = new InDouble("else", "Value to return if 'in' >= 0");
    public OutDouble outResult = new OutDouble("result", "arg < 0 ? then : else");
    private double value = 0.0;

    public IfNegative() {
        super("signal.test.ifneg", "Return second value if first is negative, and third else. Uses lazy evaluation.");
        this.inValue.setSkillType(SkillType.SIMPLIFIED);
        this.inThen.setSkillType(SkillType.SIMPLIFIED);
        this.inElse.setSkillType(SkillType.SIMPLIFIED);
        this.outResult.setSkillType(SkillType.SIMPLIFIED);
    }

    public void fullCycle(FlowEngine engine) {
        engine.requestData(this.inValue);
        boolean argModified = this.inValue.isModified();
        if (argModified) {
            this.value = (Double)this.inValue.read();
        }
        if (this.value < 0.0) {
            engine.requestData(this.inThen);
            if (argModified || this.inThen.isModified()) {
                this.outResult.write((Double)this.inThen.read());
            }
        } else {
            engine.requestData(this.inElse);
            if (argModified || this.inElse.isModified()) {
                this.outResult.write((Double)this.inElse.read());
            }
        }
    }

    public void cycle() {
    }
}

