/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bridge;

import java.text.DecimalFormat;
import java.util.logging.Level;

public class LogMessage {
    private final Level level;
    private final LocationType location;
    private final int itemId;
    private final String errorType;
    private final String message;
    private final long time;

    public LogMessage(Level level, LocationType location, int itemId, String errorType, String message, long time) {
        this.level = level;
        this.location = location;
        this.itemId = itemId;
        this.errorType = errorType;
        this.message = message;
        this.time = time;
    }

    public Level getLevel() {
        return this.level;
    }

    public LocationType getLocation() {
        return this.location;
    }

    public int getItemId() {
        return this.itemId;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("#0.00");
        StringBuilder result = new StringBuilder();
        result.append(format.format(this.time));
        result.append(" ");
        result.append(this.level.toString());
        result.append(": ");
        result.append(this.errorType);
        result.append(" @ ");
        result.append(this.location.toString());
        result.append("(");
        result.append(this.itemId);
        result.append("): ");
        result.append(this.message);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationType {
        DECKLIGHT,
        BOUNCELET,
        PORT;

    }
}

