/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.macro;

import java.util.ArrayList;
import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.convert.format.SpectrumToWave;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.signal.values.PowerOfTwo;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.GhostTwin;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncarnatedBouncelet
extends MacroBouncelet
implements PortValueSetter {
    private final BounceletBase target;
    private final PowerOf2 blockSize;
    private WaveToSpectrum[] wave2spectrums;
    private SpectrumToWave[] spectrum2waves;
    private PowerOfTwo overlap;
    private PowerOfTwo inBlockSize;
    private org.corebounce.decklight.bouncelets.signal.values.WindowType windowType;
    private PowerOfTwo outBlockSize;
    private org.corebounce.decklight.bouncelets.signal.values.WindowType postWindowType;
    private InSpectrum[] inSpectrums;
    private OutSpectrum[] outSpectrums;
    private InputPort<?>[] inputPorts;
    private OutputPort<?>[] outputPorts;
    private BounceletBase[] parts;

    public IncarnatedBouncelet(Class<? extends BounceletBase> targetType) {
        this(IncarnatedBouncelet.instance(targetType), SkillType.NORMAL);
    }

    private static BounceletBase instance(Class<? extends BounceletBase> targetType) {
        try {
            return targetType.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public IncarnatedBouncelet(BounceletBase target, SkillType skillType) {
        this(target, skillType, PowerOf2.p2048);
    }

    public IncarnatedBouncelet(BounceletBase target, PowerOf2 blockSize) {
        this(target, SkillType.NORMAL, blockSize);
    }

    public IncarnatedBouncelet(BounceletBase target, PowerOf2 blockSize, WindowType preWindow, WindowType postWindow, PowerOf2 overlapFactor) {
        this(target, SkillType.NORMAL, blockSize, preWindow, postWindow, overlapFactor);
    }

    public IncarnatedBouncelet(BounceletBase target, SkillType skillType, PowerOf2 blockSize) {
        this(target, skillType, blockSize, WindowType.Hann, WindowType.Hann, PowerOf2.p4);
    }

    public IncarnatedBouncelet(BounceletBase target, SkillType skillType, PowerOf2 blockSize, WindowType preWindow, WindowType postWindow, PowerOf2 overlapFactor) {
        super(IncarnatedBouncelet.changeName(target.getName()), target.getDescription());
        this.target = target;
        this.blockSize = blockSize;
        if (skillType == null) {
            this.setSkillType(target.getSkillType());
        } else {
            this.setSkillType(skillType);
        }
        this.initialize(blockSize, preWindow, postWindow, overlapFactor);
        this.windowType.inData.setSkillType(SkillType.EXPERT);
        this.postWindowType.inData.setSkillType(SkillType.EXPERT);
        this.outBlockSize.inData.setSkillType(SkillType.EXPERT);
    }

    @Override
    public BounceletBase newInstance() {
        BounceletBase targetCopy = this.target.newInstance();
        IncarnatedBouncelet result = new IncarnatedBouncelet(targetCopy, this.getSkillType(), this.blockSize, (WindowType)((Object)this.windowType.inData.peek()), (WindowType)((Object)this.postWindowType.inData.peek()), (PowerOf2)((Object)this.overlap.inData.peek()));
        return result;
    }

    private static String changeName(String name) {
        return name.replace("spectrum", "fourier");
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(PowerOf2 blockSize, WindowType preWindow, WindowType postWindow, PowerOf2 overlapFactor) {
        void var7_15;
        void var7_12;
        ArrayList inSpectrumPorts = new ArrayList();
        ArrayList<OutputPort> outSpectrumPorts = new ArrayList<OutputPort>();
        for (InputPort<?> inputPort : this.target.getInputPorts()) {
            if (!inputPort.getDataType().equals(SpectrumData.class)) continue;
            inSpectrumPorts.add(inputPort);
        }
        for (OutputPort outputPort : this.target.getOutputPorts()) {
            if (!outputPort.getDataType().equals(SpectrumData.class)) continue;
            outSpectrumPorts.add(outputPort);
        }
        this.inSpectrums = new InSpectrum[inSpectrumPorts.size()];
        inSpectrumPorts.toArray(this.inSpectrums);
        this.outSpectrums = new OutSpectrum[outSpectrumPorts.size()];
        outSpectrumPorts.toArray(this.outSpectrums);
        this.wave2spectrums = new WaveToSpectrum[this.inSpectrums.length];
        boolean bl = false;
        while (var7_12 < this.wave2spectrums.length) {
            this.wave2spectrums[var7_12] = new WaveToSpectrum();
            this.wave2spectrums[var7_12].setInBlahblah(this.inSpectrums[var7_12].getName(), this.inSpectrums[var7_12].getDescription());
            ++var7_12;
        }
        this.overlap = new PowerOfTwo("overlap", "Overlap factor", overlapFactor, PowerOf2.p2, PowerOf2.p64);
        PowerOf2 powerOf2 = PowerOf2.p128;
        PowerOf2 maxBS = PowerOf2.p65536;
        if (blockSize.intValue() < powerOf2.intValue()) {
            PowerOf2 powerOf22 = blockSize;
        } else if (blockSize.intValue() > maxBS.intValue()) {
            maxBS = blockSize;
        }
        this.inBlockSize = new PowerOfTwo("blockSize", "Window size for the FFT", blockSize, (PowerOf2)var7_15, maxBS);
        this.windowType = new org.corebounce.decklight.bouncelets.signal.values.WindowType("window", "Analysis window", preWindow);
        this.spectrum2waves = new SpectrumToWave[this.outSpectrums.length];
        int i2 = 0;
        while (i2 < this.spectrum2waves.length) {
            this.spectrum2waves[i2] = new SpectrumToWave();
            this.spectrum2waves[i2].setOutBlahblah(this.outSpectrums[i2].getName(), this.outSpectrums[i2].getDescription());
            ++i2;
        }
        this.outBlockSize = new PowerOfTwo("outBlockSize", "Output block sizes", AudioConfig.getBlockSize());
        this.postWindowType = new org.corebounce.decklight.bouncelets.signal.values.WindowType("postWindow", "Synthesis window", postWindow);
        ArrayList inputPortList = new ArrayList();
        WaveToSpectrum[] waveToSpectrumArray = this.wave2spectrums;
        int n = this.wave2spectrums.length;
        int n2 = 0;
        while (n2 < n) {
            WaveToSpectrum w2s = waveToSpectrumArray[n2];
            inputPortList.add(w2s.inAudio());
            ++n2;
        }
        for (InputPort<?> port : this.target.getInputPorts()) {
            if (inSpectrumPorts.contains(port)) continue;
            inputPortList.add(port);
        }
        inputPortList.add(this.overlap.inData);
        inputPortList.add(this.inBlockSize.inData);
        inputPortList.add(this.windowType.inData);
        inputPortList.add(this.outBlockSize.inData);
        inputPortList.add(this.postWindowType.inData);
        this.inputPorts = new InputPort[inputPortList.size()];
        inputPortList.toArray(this.inputPorts);
        ArrayList outputPortList = new ArrayList();
        SpectrumToWave[] spectrumToWaveArray = this.spectrum2waves;
        int n3 = this.spectrum2waves.length;
        n = 0;
        while (n < n3) {
            SpectrumToWave s2w = spectrumToWaveArray[n];
            outputPortList.add(s2w.outAudio());
            ++n;
        }
        for (OutputPort<?> port : this.target.getOutputPorts()) {
            if (outSpectrumPorts.contains(port)) continue;
            outputPortList.add(port);
        }
        this.outputPorts = new OutputPort[outputPortList.size()];
        outputPortList.toArray(this.outputPorts);
        ArrayList<BounceletBase> partList = new ArrayList<BounceletBase>();
        BounceletBase[] bounceletBaseArray = this.target.getParts();
        int n4 = bounceletBaseArray.length;
        n3 = 0;
        while (n3 < n4) {
            BounceletBase b = bounceletBaseArray[n3];
            partList.add(b);
            ++n3;
        }
        int i3 = 0;
        while (i3 < this.inSpectrums.length) {
            partList.addAll(Arrays.asList(this.wave2spectrums[i3].getParts()));
            ++i3;
        }
        partList.add(this.overlap);
        partList.add(this.inBlockSize);
        partList.add(this.windowType);
        int i = 0;
        while (i < this.outSpectrums.length) {
            partList.addAll(Arrays.asList(this.spectrum2waves[i].getParts()));
            ++i;
        }
        partList.add(this.outBlockSize);
        partList.add(this.postWindowType);
        this.parts = new Bouncelet[partList.size()];
        partList.toArray(this.parts);
        for (InputPort<?> port : this.target.getInputPorts()) {
            if (!(port instanceof InSpectrumPreset)) continue;
            InSpectrumPreset spPort = (InSpectrumPreset)port;
            spPort.setSpectrumPortValueSetter(this);
        }
    }

    @Override
    public void createInternalConnections(Connector connector) {
        if (this.target instanceof MacroBouncelet) {
            ((MacroBouncelet)this.target).createInternalConnections(connector);
        }
        int i = 0;
        while (i < this.inSpectrums.length) {
            this.wave2spectrums[i].createInternalConnections(connector);
            connector.connect(this.wave2spectrums[i].outSpectrum(), this.inSpectrums[i]);
            ++i;
        }
        i = 0;
        while (i < this.outSpectrums.length) {
            this.spectrum2waves[i].createInternalConnections(connector);
            connector.connect(this.outSpectrums[i], this.spectrum2waves[i].inSpectrum());
            ++i;
        }
        i = 0;
        while (i < this.inSpectrums.length) {
            connector.connect(this.overlap.outData, this.wave2spectrums[i].inOverlap());
            connector.connect(this.inBlockSize.outData, this.wave2spectrums[i].inWindowSize());
            connector.connect(this.windowType.outData, this.wave2spectrums[i].inWindowType());
            ++i;
        }
        if (this.target instanceof GhostTwin) {
            WaveToSpectrum[] w2cs;
            GhostTwin twin = (GhostTwin)((Object)this.target);
            WaveToSpectrum[] waveToSpectrumArray = w2cs = twin.getTwins();
            int n = w2cs.length;
            int n2 = 0;
            while (n2 < n) {
                WaveToSpectrum wtc = waveToSpectrumArray[n2];
                connector.connect(this.overlap.outData, wtc.inOverlap());
                connector.connect(this.inBlockSize.outData, wtc.inWindowSize());
                connector.connect(this.windowType.outData, wtc.inWindowType());
                ++n2;
            }
        }
        i = 0;
        while (i < this.outSpectrums.length) {
            connector.connect(this.outBlockSize.outData, this.spectrum2waves[i].inBlockSize());
            connector.connect(this.postWindowType.outData, this.spectrum2waves[i].inWindow());
            ++i;
        }
    }

    public BounceletBase getTarget() {
        return this.target;
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return this.inputPorts;
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return this.outputPorts;
    }

    @Override
    public BounceletBase[] getParts() {
        return this.parts;
    }

    public InAudio getInAudio(int index) {
        return this.wave2spectrums[index].inAudio();
    }

    public OutAudio getOutAudio(int index) {
        return this.spectrum2waves[index].outAudio();
    }

    @Override
    public void setBlockSize(PowerOf2 blockSize) {
        this.inBlockSize.scheduleSetPortValue(this.inBlockSize.inData, blockSize);
    }

    @Override
    public void setOverlap(PowerOf2 value) {
        this.overlap.scheduleSetPortValue(this.overlap.inData, value);
    }

    @Override
    public void setAnalysisWindow(WindowType window) {
        this.windowType.scheduleSetPortValue(this.windowType.inData, window);
    }

    @Override
    public void setSynthesisWindow(WindowType window) {
        this.postWindowType.scheduleSetPortValue(this.postWindowType.inData, window);
    }

    @Override
    public <E> void setPortValue(InputPort<E> port, E value) {
        throw new UnsupportedOperationException();
    }
}

