/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.macro;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MacroBouncelet
extends BounceletBase {
    private List<InputPort<?>> inputPorts;
    private List<OutputPort<?>> outputPorts;

    public MacroBouncelet(String name, String description) {
        super(name, description);
    }

    public MacroBouncelet(String name, String description, boolean isTarget) {
        super(name, description, isTarget);
    }

    protected final BounceletBase[] getDeepParts(BounceletBase[] parts) {
        ArrayList<BounceletBase> result = new ArrayList<BounceletBase>();
        this.fillDeepParts(parts, result);
        BounceletBase[] arr = new BounceletBase[result.size()];
        result.toArray(arr);
        return arr;
    }

    private void fillDeepParts(BounceletBase[] parts, List<BounceletBase> result) {
        BounceletBase[] bounceletBaseArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            BounceletBase part = bounceletBaseArray[n2];
            if (part instanceof MacroBouncelet) {
                MacroBouncelet macro = (MacroBouncelet)part;
                this.fillDeepParts(macro.getParts(), result);
            } else {
                result.add(part);
            }
            ++n2;
        }
    }

    protected final void createDeepInternalConnections(Connector connector, BounceletBase[] parts) {
        BounceletBase[] bounceletBaseArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            BounceletBase part = bounceletBaseArray[n2];
            if (part instanceof MacroBouncelet) {
                MacroBouncelet macro = (MacroBouncelet)part;
                macro.createInternalConnections(connector);
            }
            ++n2;
        }
    }

    @Override
    public abstract BounceletBase[] getParts();

    protected abstract InputPort<?>[] getMacroInputPorts();

    protected abstract OutputPort<?>[] getMacroOutputPorts();

    @Override
    public abstract void createInternalConnections(Connector var1);

    @Override
    public final List<InputPort<?>> getInputPorts() {
        if (this.inputPorts == null) {
            HashSet<String> names = new HashSet<String>();
            BounceletBase[] bounceletBaseArray = this.getParts();
            int n = bounceletBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                BounceletBase part = bounceletBaseArray[n2];
                part.getInputPorts();
                ++n2;
            }
            InputPort<?>[] ports = this.getMacroInputPorts();
            this.inputPorts = new ArrayList(ports.length);
            InputPort<?>[] inputPortArray = ports;
            int n3 = ports.length;
            n = 0;
            while (n < n3) {
                InputPort<?> port = inputPortArray[n];
                this.inputPorts.add(port);
                String name = port.getName();
                if (names.contains(name)) {
                    throw new IllegalStateException("Duplicate input port name: " + name);
                }
                names.add(name);
                ++n;
            }
        }
        return this.inputPorts;
    }

    @Override
    public final List<OutputPort<?>> getOutputPorts() {
        if (this.outputPorts == null) {
            HashSet<String> names = new HashSet<String>();
            BounceletBase[] bounceletBaseArray = this.getParts();
            int n = bounceletBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                BounceletBase part = bounceletBaseArray[n2];
                part.getOutputPorts();
                ++n2;
            }
            OutputPort<?>[] ports = this.getMacroOutputPorts();
            this.outputPorts = new ArrayList(ports.length);
            OutputPort<?>[] outputPortArray = ports;
            int n3 = ports.length;
            n = 0;
            while (n < n3) {
                OutputPort<?> port = outputPortArray[n];
                this.outputPorts.add(port);
                String name = port.getName();
                if (names.contains(name)) {
                    throw new IllegalStateException("Duplicate input port name: " + name);
                }
                names.add(name);
                ++n;
            }
        }
        return this.outputPorts;
    }

    @Override
    public String toString() {
        return "Macro:" + this.getClass().getSimpleName();
    }
}

