/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.play;

import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.LinkedHashSet;

public class FormatToRegex {
    private FormatToRegex() {
    }

    private static void append(StringBuffer buffer, String data) {
        buffer.append(data);
    }

    private static void appendLiteral(StringBuffer buffer, char ch) {
        if (ch == '.' || ch == '*' || ch == '?' || ch == '+' || ch == '$' || ch == '^' || ch == '\\' || ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == '|' || ch == '/' || ch == '&' || ch == ',' || ch == '-') {
            buffer.append('\\');
        }
        buffer.append(ch);
    }

    private static void appendLiterals(StringBuffer buffer, String data) {
        int i = 0;
        while (i < data.length()) {
            FormatToRegex.appendLiteral(buffer, data.charAt(i));
            ++i;
        }
    }

    public static String getRegexPattern(DecimalFormat format) {
        DecimalFormatSymbols symbols;
        StringBuffer result = new StringBuffer();
        String pattern = format.toPattern();
        int sepPos = pattern.indexOf((symbols = format.getDecimalFormatSymbols()).getPatternSeparator());
        if (sepPos < 0) {
            FormatToRegex.fillRegexPattern0(format, pattern, result);
        } else {
            String pos = pattern.substring(0, sepPos);
            String neg = pattern.substring(sepPos + 1);
            FormatToRegex.append(result, "(?:");
            FormatToRegex.fillRegexPattern0(format, pos, result);
            FormatToRegex.append(result, ")|(?:");
            FormatToRegex.fillRegexPattern0(format, neg, result);
            FormatToRegex.append(result, ")");
        }
        return result.toString();
    }

    private static void fillRegexPattern0(DecimalFormat format, String pattern, StringBuffer result) {
        int nStop;
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        char O = format.getDecimalFormatSymbols().getZeroDigit();
        int end = pattern.indexOf(symbols.getPatternSeparator());
        if (end < 0) {
            end = pattern.length();
        }
        int p1 = pattern.indexOf(O);
        int p2 = pattern.indexOf(35);
        int nStart = p1 >= 0 && p1 < p2 ? p1 : p2;
        p1 = pattern.lastIndexOf(O, end - 1);
        p2 = pattern.lastIndexOf(35, end - 1);
        int n = nStop = p1 > p2 ? p1 : p2;
        if (nStart < 0 || nStop < 0) {
            throw new IllegalArgumentException("Not a valid number format: " + pattern);
        }
        String prefix = pattern.substring(0, nStart);
        String suffix = pattern.substring(nStop + 1);
        if (!prefix.equals("")) {
            FormatToRegex.append(result, "(?:");
            FormatToRegex.appendLiterals(result, prefix);
            FormatToRegex.append(result, ")");
        }
        FormatToRegex.append(result, "[\\+");
        FormatToRegex.appendLiteral(result, symbols.getMinusSign());
        FormatToRegex.append(result, "]?");
        FormatToRegex.append(result, "[\\d");
        FormatToRegex.appendLiteral(result, symbols.getGroupingSeparator());
        FormatToRegex.append(result, "]*");
        FormatToRegex.append(result, "(?:");
        FormatToRegex.appendLiteral(result, symbols.getDecimalSeparator());
        FormatToRegex.append(result, "\\d+");
        FormatToRegex.append(result, ")?");
        FormatToRegex.append(result, "(?:E");
        FormatToRegex.append(result, "[\\+");
        FormatToRegex.appendLiteral(result, symbols.getMinusSign());
        FormatToRegex.append(result, "]?");
        FormatToRegex.append(result, "\\d*");
        FormatToRegex.append(result, ")?");
        if (!suffix.equals("")) {
            FormatToRegex.append(result, "(?:");
            FormatToRegex.appendLiterals(result, suffix);
            FormatToRegex.append(result, ")");
        }
    }

    private static boolean isAdjacentToNext(String pattern, int index) {
        char stch;
        char ch = stch = pattern.charAt(index);
        while (ch == stch) {
            if (++index >= pattern.length()) {
                return false;
            }
            ch = pattern.charAt(index);
        }
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static int getOccuranceCount(String pattern, int index) {
        char stch;
        char ch = stch = pattern.charAt(index);
        int result = 0;
        while (ch == stch) {
            ++result;
            if (++index >= pattern.length()) break;
            ch = pattern.charAt(index);
        }
        return result;
    }

    private static String[] concat(String[] s1, String[] s2) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        int i = 0;
        while (i < s1.length) {
            if (!s1[i].equals("")) {
                values.add(s1[i]);
            }
            ++i;
        }
        i = 0;
        while (i < s2.length) {
            if (!s2[i].equals("")) {
                values.add(s2[i]);
            }
            ++i;
        }
        String[] result = new String[values.size()];
        values.toArray(result);
        return result;
    }

    private static void appendChoice(StringBuffer buffer, String[] choices) {
        if (choices == null || choices.length == 0) {
            return;
        }
        buffer.append("(?:");
        int i = 0;
        while (i < choices.length) {
            if (i > 0) {
                buffer.append('|');
            }
            FormatToRegex.appendLiterals(buffer, choices[i]);
            ++i;
        }
        buffer.append(")");
    }

    public static String getRegexPattern(SimpleDateFormat format) {
        StringBuffer result = new StringBuffer();
        String pattern = format.toPattern();
        DateFormatSymbols symbols = format.getDateFormatSymbols();
        int lastCh = 0;
        char lastSp = '\u0000';
        boolean inQuote = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                if (lastCh == 39) {
                    FormatToRegex.appendLiteral(result, '\'');
                }
                inQuote = !inQuote;
                lastSp = '\u0000';
            } else if (inQuote) {
                FormatToRegex.appendLiteral(result, ch);
                lastSp = '\u0000';
            } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                if (ch != lastSp) {
                    if (ch == 'G') {
                        FormatToRegex.appendChoice(result, symbols.getEras());
                    } else if (ch == 'E') {
                        FormatToRegex.appendChoice(result, FormatToRegex.concat(symbols.getShortWeekdays(), symbols.getWeekdays()));
                    } else if (ch == 'a') {
                        FormatToRegex.appendChoice(result, symbols.getAmPmStrings());
                    } else if ("zZ".indexOf(ch) >= 0) {
                        FormatToRegex.append(result, ".+?");
                    } else if ("ywWdFHkKhmsDS".indexOf(ch) >= 0) {
                        if (FormatToRegex.isAdjacentToNext(pattern, i)) {
                            int nbDigits = FormatToRegex.getOccuranceCount(pattern, i);
                            FormatToRegex.append(result, "[\\-\\d]");
                            int nb = 1;
                            while (nb < nbDigits) {
                                FormatToRegex.append(result, "\\d");
                                ++nb;
                            }
                        } else {
                            FormatToRegex.append(result, "\\-?\\d+?");
                        }
                    } else if (ch == 'M') {
                        if (i + 1 >= pattern.length() || pattern.charAt(i + 1) != 'M' || i + 2 >= pattern.length() || pattern.charAt(i + 2) != 'M') {
                            FormatToRegex.append(result, "\\-?\\d\\d?");
                        } else {
                            FormatToRegex.appendChoice(result, FormatToRegex.concat(symbols.getShortMonths(), symbols.getMonths()));
                        }
                    } else {
                        FormatToRegex.append(result, ".*?");
                    }
                }
                lastSp = ch;
            } else if (ch == ' ') {
                FormatToRegex.append(result, "\\s+?");
                lastSp = '\u0000';
            } else {
                FormatToRegex.appendLiteral(result, ch);
                lastSp = '\u0000';
            }
            lastCh = ch;
            ++i;
        }
        return result.toString();
    }
}

