/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.ports;

import org.corebounce.decklight.Port;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputPort<E>
extends Port<E> {
    private boolean isResetOnDisconnect = false;
    private boolean isSpeedModifier = false;
    private E defaultValue;
    private E minValue = null;
    private E maxValue = null;
    private OutputPort<? extends E> source = null;
    private boolean dirty = false;

    protected InputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect, E minValue, E maxValue) {
        super(dataType, name, description);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.isSpeedModifier = isSpeedModifier;
        this.isResetOnDisconnect = isResetOnDisconnect;
        this.reset();
    }

    public InputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect) {
        this(isSpeedModifier, (Class<Object>)dataType, name, description, defaultValue, isResetOnDisconnect, null, null);
    }

    public InputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue, E minValue, E maxValue) {
        this(isSpeedModifier, dataType, name, description, defaultValue, false, minValue, maxValue);
    }

    public InputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue) {
        this(isSpeedModifier, (Class<Object>)dataType, name, description, defaultValue, false, null, null);
    }

    public InputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description) {
        this(isSpeedModifier, dataType, name, description, null, false, null, null);
    }

    public InputPort(Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect, E minValue, E maxValue) {
        this(false, dataType, name, description, defaultValue, isResetOnDisconnect, minValue, maxValue);
    }

    public InputPort(Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect) {
        this(false, (Class<Object>)dataType, name, description, defaultValue, isResetOnDisconnect, null, null);
    }

    public InputPort(Class<E> dataType, String name, String description, E defaultValue, E minValue, E maxValue) {
        this(false, dataType, name, description, defaultValue, false, minValue, maxValue);
    }

    public InputPort(Class<E> dataType, String name, String description, E defaultValue) {
        this(false, (Class<Object>)dataType, name, description, defaultValue, false, null, null);
    }

    public InputPort(Class<E> dataType, String name, String description) {
        this(false, dataType, name, description, null, false, null, null);
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    public E getMinValue() {
        return this.minValue;
    }

    public E getMaxValue() {
        return this.maxValue;
    }

    public boolean isResetOnDisconnect() {
        return this.isResetOnDisconnect;
    }

    protected void setResetOnDisconnect(boolean value) {
        this.isResetOnDisconnect = value;
    }

    public boolean isSpeedModifier() {
        return this.isSpeedModifier;
    }

    protected void setSpeedModifier(boolean value) {
        this.isSpeedModifier = value;
    }

    public void reset() {
        this.data = this.defaultValue;
    }

    public void connect(OutputPort<? extends E> outputPort) {
        if (this.source != null) {
            this.source.removeTarget(this);
        }
        if (outputPort == null && this.isResetOnDisconnect()) {
            this.reset();
        }
        this.source = outputPort;
        if (this.source != null) {
            this.source.addTarget(this);
        }
    }

    public OutputPort<? extends E> getSource() {
        return this.source;
    }

    public boolean isConnected() {
        return this.source != null;
    }

    public boolean canProcessInPlace() {
        if (!this.isConnected()) {
            return false;
        }
        return this.getSource().getNbTargets() <= 1;
    }

    public void write(E data) {
        this.data = data;
        this.setModified(true);
    }

    public E peek() {
        return (E)this.data;
    }

    public E read() {
        this.setModified(false);
        return (E)this.data;
    }

    void setDirty(boolean value) {
        this.dirty = value;
    }

    public void readFromSource() {
        if (this.source == null) {
            throw new IllegalStateException("This output port is not connected to an input port");
        }
        if (this.dirty) {
            E data = this.source.fetch(this);
            if (data != null) {
                this.write(data);
                this.dirty = this.source.isManual();
            }
        } else {
            this.setModified(false);
        }
    }
}

