/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.ports;

import java.util.LinkedList;
import java.util.Queue;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.decklight.ports.QueueOutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueInputPort<E>
extends InputPort<E> {
    private final Queue<E> queue = new LinkedList();

    public QueueInputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect, E minValue, E maxValue) {
        super(isSpeedModifier, dataType, name, description, defaultValue, isResetOnDisconnect, minValue, maxValue);
    }

    public QueueInputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect) {
        super(isSpeedModifier, dataType, name, description, defaultValue, isResetOnDisconnect);
    }

    public QueueInputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue, E minValue, E maxValue) {
        super(isSpeedModifier, dataType, name, description, defaultValue, minValue, maxValue);
    }

    public QueueInputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue) {
        super(isSpeedModifier, dataType, name, description, defaultValue);
    }

    public QueueInputPort(boolean isSpeedModifier, Class<E> dataType, String name, String description) {
        super(isSpeedModifier, dataType, name, description);
    }

    public QueueInputPort(Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect, E minValue, E maxValue) {
        super(dataType, name, description, defaultValue, isResetOnDisconnect, minValue, maxValue);
    }

    public QueueInputPort(Class<E> dataType, String name, String description, E defaultValue, boolean isResetOnDisconnect) {
        super(dataType, name, description, defaultValue, isResetOnDisconnect);
    }

    public QueueInputPort(Class<E> dataType, String name, String description, E defaultValue, E minValue, E maxValue) {
        super(dataType, name, description, defaultValue, minValue, maxValue);
    }

    public QueueInputPort(Class<E> dataType, String name, String description, E defaultValue) {
        super(dataType, name, description, defaultValue);
    }

    public QueueInputPort(Class<E> dataType, String name, String description) {
        super(dataType, name, description);
    }

    @Override
    public E read() {
        if (!this.queue.isEmpty()) {
            this.data = this.queue.remove();
        }
        if (this.queue.isEmpty()) {
            this.setModified(false);
        }
        return (E)this.data;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.queue != null) {
            this.queue.clear();
        }
    }

    @Override
    public void write(E data) {
        super.write(data);
        this.queue.offer(data);
    }

    @Override
    public void readFromSource() {
        OutputPort source = this.getSource();
        if (source instanceof QueueOutputPort) {
            QueueOutputPort queueSource = (QueueOutputPort)source;
            Queue queue = queueSource.getQueue();
            for (Object item : queue) {
                this.queue.offer(item);
            }
        } else {
            super.readFromSource();
        }
    }
}

