/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.ports;

import java.util.LinkedList;
import java.util.Queue;
import org.corebounce.decklight.ports.ValueOutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueOutputPort<E>
extends ValueOutputPort<E> {
    private final Queue<E> queue = new LinkedList();
    private double lastCycleTime = -1.0;

    public QueueOutputPort(Class<E> dataType, String name, String description) {
        super(dataType, name, description);
    }

    @Override
    public void write(E data) {
        double cycleTime = this.getBouncelet().getTime();
        if (cycleTime > this.lastCycleTime) {
            this.lastCycleTime = cycleTime;
            this.queue.clear();
        }
        super.write(data);
        this.queue.offer(data);
    }

    Queue<E> getQueue() {
        return this.queue;
    }
}

