/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.ports;

import java.util.Map;
import java.util.WeakHashMap;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.decklight.ports.PublicCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructOutputPort<E extends PublicCloneable<E>>
extends OutputPort<E> {
    private Map<InputPort<? super E>, E> clonePool = null;

    public StructOutputPort(Class<E> dataType, String name, String description) {
        super(dataType, name, description);
    }

    @Override
    protected E fetch(InputPort<? super E> target) {
        PublicCloneable result = (PublicCloneable)super.fetch(target);
        if (this.getNbTargets() > 1) {
            PublicCloneable clone;
            if (this.clonePool == null) {
                this.clonePool = new WeakHashMap<InputPort<? super E>, E>();
            }
            if ((clone = (PublicCloneable)this.clonePool.get(target)) == null) {
                if (result != null) {
                    clone = (PublicCloneable)result.clone();
                    this.clonePool.put(target, clone);
                }
            } else {
                result.copyTo(clone);
            }
            result = clone;
        }
        return (E)result;
    }
}

