/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.Decklight;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.GraphListener;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bridge.BounceletInfo;
import org.corebounce.decklight.bridge.DecklightInfo;
import org.corebounce.decklight.bridge.InputPortInfo;
import org.corebounce.decklight.bridge.LogMessage;
import org.corebounce.decklight.bridge.OutputPortInfo;
import org.corebounce.decklight.bridge.PitchTechInfo;
import org.corebounce.decklight.bridge.PlayState;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.play.PlayStateChangeListener;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.decklight.server.BounceletImpl;
import org.corebounce.decklight.server.ConnectionImpl;
import org.corebounce.decklight.server.InputPortImpl;
import org.corebounce.decklight.server.PortImpl;
import org.corebounce.utils.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecklightImpl
implements DecklightInfo,
PlayStateChangeListener,
GraphListener {
    private final Decklight server = new Decklight();
    private final PitchTechInfo pitchTech;
    private final Map<Integer, BounceletBase> bouncelets = new HashMap<Integer, BounceletBase>();
    private final Map<Integer, ConnectionImpl> connections = new HashMap<Integer, ConnectionImpl>();
    private Map<String, BounceletBase> types = null;
    private PlayState playState = PlayState.STOP;
    private final Object playStateLock = new Object();
    private final Queue<LogMessage> logMessages = new LinkedList<LogMessage>();

    public DecklightImpl(PitchTechInfo pitchTech) {
        this.pitchTech = pitchTech;
        this.server.addPlayStateChangeListener(this);
        this.server.addGraphListener(this);
    }

    @Override
    public Collection<String> getBounceletTypes() {
        if (this.types == null) {
            this.types = this.server.getBounceletTypes();
        }
        ArrayList<String> result = new ArrayList<String>(this.types.keySet());
        Collections.sort(result);
        return result;
    }

    public Collection<BounceletInfo> getBounceletTypeInfos() {
        if (this.types == null) {
            this.types = this.server.getBounceletTypes();
        }
        ArrayList<BounceletInfo> result = new ArrayList<BounceletInfo>();
        for (BounceletBase bouncelet : this.types.values()) {
            result.add(new BounceletImpl(bouncelet));
        }
        return result;
    }

    @Override
    public BounceletInfo getBounceletTypeInfo(String name) {
        BounceletBase bouncelet;
        if (this.types == null) {
            this.types = this.server.getBounceletTypes();
        }
        if ((bouncelet = this.types.get(name)) == null) {
            return null;
        }
        return new BounceletImpl(bouncelet);
    }

    @Override
    public SkillType getBounceletSkillType(String name) {
        if (this.types == null) {
            this.types = this.server.getBounceletTypes();
        }
        BounceletBase bouncelet = this.types.get(name);
        return bouncelet.getSkillType();
    }

    @Override
    public long getTime() {
        return this.server.getTime();
    }

    @Override
    public void listenToOutputPort(int bounceletId, int portNum, boolean enabled) {
    }

    @Override
    public void venerateProfessorDrake() {
    }

    @Override
    public synchronized void addBouncelet(int bounceletId, BounceletInfo bounceletType) {
        BounceletImpl info = (BounceletImpl)bounceletType;
        BounceletBase template = info.getTarget();
        BounceletBase instance = template.newInstance();
        this.server.addBouncelet(instance);
        this.bouncelets.put(bounceletId, instance);
    }

    @Override
    public synchronized void removeBouncelet(int bounceletId) {
        BounceletBase bouncelet = this.bouncelets.remove(bounceletId);
        if (bouncelet == null) {
            throw new IllegalArgumentException("Unknown bouncelet");
        }
        this.server.removeBouncelet(bouncelet);
    }

    private OutputPort<?> getOutputPort(BounceletBase bouncelet, String name) {
        for (OutputPort<?> port : bouncelet.getOutputPorts()) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    private InputPort<?> getInputPort(BounceletBase bouncelet, String name) {
        for (InputPort<?> port : bouncelet.getInputPorts()) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    @Override
    public synchronized void addConnection(int connectionId, int srcId, OutputPortInfo srcInfo, int dstId, InputPortInfo dstInfo) {
        PortImpl srcImpl = (PortImpl)((Object)srcInfo);
        InputPortImpl dstImpl = (InputPortImpl)dstInfo;
        BounceletBase src = this.bouncelets.get(srcId);
        BounceletBase dst = this.bouncelets.get(dstId);
        if (src == null) {
            throw new IllegalArgumentException("Unknown source bouncelet");
        }
        if (dst == null) {
            throw new IllegalArgumentException("Unknown destination bouncelet");
        }
        OutputPort<?> srcPort = this.getOutputPort(src, srcImpl.getName());
        InputPort<?> dstPort = this.getInputPort(dst, dstImpl.getName());
        if (srcPort == null) {
            throw new IllegalArgumentException("Unknown source port");
        }
        if (dstPort == null) {
            throw new IllegalArgumentException("Unknown dstination port");
        }
        this.server.addConnection(srcPort, dstPort);
        ConnectionImpl c = new ConnectionImpl(src, srcPort, dst, dstPort);
        this.connections.put(connectionId, c);
    }

    public synchronized void addConnection(int connectionId, int srcId, String srcPortName, int dstId, String dstPortName) {
        BounceletBase src = this.bouncelets.get(srcId);
        BounceletBase dst = this.bouncelets.get(dstId);
        if (src == null) {
            throw new IllegalArgumentException("Unknown source bouncelet");
        }
        if (dst == null) {
            throw new IllegalArgumentException("Unknown destination bouncelet");
        }
        OutputPort<?> srcPort = this.getOutputPort(src, srcPortName);
        InputPort<?> dstPort = this.getInputPort(dst, dstPortName);
        if (srcPort == null) {
            throw new IllegalArgumentException("Unknown source port");
        }
        if (dstPort == null) {
            throw new IllegalArgumentException("Unknown dstination port");
        }
        this.server.addConnection(srcPort, dstPort);
        ConnectionImpl c = new ConnectionImpl(src, srcPort, dst, dstPort);
        this.connections.put(connectionId, c);
    }

    @Override
    public synchronized void removeConnection(int connectionId) {
        ConnectionImpl c = this.connections.remove(connectionId);
        if (c == null) {
            throw new IllegalArgumentException("Unknown connection");
        }
        this.server.removeConnection(c.getSrcPort(), c.getDstPort());
    }

    @Override
    public void setInput(int bounceletId, InputPortInfo port, Object value) {
        InputPortImpl portImpl = (InputPortImpl)port;
        BounceletBase bouncelet = this.bouncelets.get(bounceletId);
        if (bouncelet == null) {
            throw new IllegalArgumentException("Unknwon bouncelet");
        }
        InputPort<?> inputPort = this.getInputPort(bouncelet, portImpl.getName());
        if (inputPort == null) {
            throw new IllegalArgumentException("Unknown input port");
        }
        this.server.setInput(inputPort, value);
    }

    public void setInput(int bounceletId, String portName, Object value) {
        BounceletBase bouncelet = this.bouncelets.get(bounceletId);
        if (bouncelet == null) {
            throw new IllegalArgumentException("Unknwon bouncelet");
        }
        InputPort<?> port = this.getInputPort(bouncelet, portName);
        if (port == null) {
            throw new IllegalArgumentException("Unknown input port");
        }
        this.server.setInput(port, value);
    }

    public Class<?> getInputType(int bounceletId, String portName) {
        BounceletBase bouncelet = this.bouncelets.get(bounceletId);
        if (bouncelet == null) {
            throw new IllegalArgumentException("Unknwon bouncelet");
        }
        InputPort<?> port = this.getInputPort(bouncelet, portName);
        if (port == null) {
            throw new IllegalArgumentException("Unknown input port");
        }
        return port.getDataType();
    }

    @Override
    public void setPlayState(final PlayState playState, long when) {
        org.corebounce.decklight.play.PlayState state0 = null;
        switch (playState) {
            case STOP: {
                state0 = org.corebounce.decklight.play.PlayState.STOP;
                break;
            }
            case PAUSE: {
                state0 = org.corebounce.decklight.play.PlayState.PAUSE;
                break;
            }
            case PLAY: {
                state0 = org.corebounce.decklight.play.PlayState.PLAY;
            }
        }
        this.server.setPlayState(state0, when, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = DecklightImpl.this.playStateLock;
                synchronized (object) {
                    DecklightImpl.this.playState = playState;
                    DecklightImpl.this.playStateLock.notifyAll();
                }
            }
        });
    }

    @Override
    public void commit(long when) {
        this.server.commit(when);
    }

    @Override
    public void byebye() {
        this.server.removePlayStateChangeListener(this);
        this.server.removeGraphListener(this);
        this.server.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playStateChanged(org.corebounce.decklight.play.PlayState newState, long when) {
        PlayState state = null;
        switch (newState) {
            case STOP: {
                state = PlayState.STOP;
                break;
            }
            case PAUSE: {
                state = PlayState.PAUSE;
                break;
            }
            case PLAY: {
                state = PlayState.PLAY;
            }
        }
        if (state != null) {
            Object object = this.playStateLock;
            synchronized (object) {
                this.playState = state;
                this.playStateLock.notifyAll();
            }
            this.pitchTech.playStateChanged(this.playState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(GraphErrorType errorType, Severity severity, String message, Object source) {
        Level level = Level.INFO;
        switch (severity) {
            case Debug: {
                level = Level.FINE;
                break;
            }
            case Info: {
                level = Level.INFO;
                break;
            }
            case Warning: {
                level = Level.WARNING;
                break;
            }
            case Error: {
                level = Level.SEVERE;
                break;
            }
            case Catastroph: {
                level = Level.ALL;
            }
        }
        LogMessage.LocationType location = LogMessage.LocationType.DECKLIGHT;
        int itemId = 0;
        if (source instanceof BounceletBase) {
            location = LogMessage.LocationType.BOUNCELET;
            itemId = this.getBounceletId((BounceletBase)source);
        } else if (source instanceof Port) {
            location = LogMessage.LocationType.PORT;
            itemId = 0;
        }
        LogMessage logMessage = new LogMessage(level, location, itemId, errorType.toString(), message, this.getTime());
        Queue<LogMessage> queue = this.logMessages;
        synchronized (queue) {
            this.logMessages.add(logMessage);
            this.logMessages.notifyAll();
        }
        this.pitchTech.logMessage(logMessage);
    }

    private int getBounceletId(BounceletBase b) {
        for (Map.Entry<Integer, BounceletBase> entry : this.bouncelets.entrySet()) {
            if (!b.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public void portValueChanged(int bounceletId, int portNum, boolean output, Object value) {
        for (Map.Entry<Integer, BounceletBase> entry : this.bouncelets.entrySet()) {
            if (entry.getValue().getId() != bounceletId) continue;
            bounceletId = entry.getKey();
            break;
        }
        this.pitchTech.portValueChanged(bounceletId, portNum, output, value);
    }
}

