/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.server.osc;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.corebounce.decklight.Version;
import org.corebounce.decklight.bridge.BounceletInfo;
import org.corebounce.decklight.bridge.LogMessage;
import org.corebounce.decklight.bridge.PitchTechInfo;
import org.corebounce.decklight.bridge.PlayState;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.server.DecklightImpl;
import org.corebounce.decklight.server.osc.Cromagnon;
import org.corebounce.osc.IOSCHandler;
import org.corebounce.osc.IOSCTransport;
import org.corebounce.osc.OSCException;
import org.corebounce.osc.OSCPeer;
import org.corebounce.osc.OSCTransportTCPServer;
import org.corebounce.osc.OSCTransportUDP;

public class DecklightServer
implements IOSCHandler,
PitchTechInfo {
    private static final String WELCOME_MESSAGE = "Good %s, prof. Drake. I'm ready for my %s lesson.";
    private final OSCPeer server;
    private final DecklightImpl decklight;
    private final Map<String, BounceletInfo> bounceletTypes = new HashMap<String, BounceletInfo>();
    private final Set<SocketAddress> clients = new HashSet<SocketAddress>();
    private final boolean slave;
    private int connectionCount = 0;

    public DecklightServer(int portNum, boolean isTcp, boolean slave) throws IOException {
        Object transport = isTcp ? new OSCTransportTCPServer(portNum) : new OSCTransportUDP(portNum);
        this.server = new OSCPeer((IOSCTransport)transport);
        this.server.installHandler("/Decklight4", (IOSCHandler)this);
        this.slave = slave;
        this.decklight = new DecklightImpl(this);
        for (BounceletInfo b : this.decklight.getBounceletTypeInfos()) {
            this.bounceletTypes.put(b.getName(), b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] handle(SocketAddress peer, String[] address, int addrIdx, StringBuilder typeString, long timestamp, Object ... args) throws OSCException {
        if (address.length <= 2) {
            return null;
        }
        if (!address[1].equals("/Decklight4".substring(1))) {
            System.err.println("Command received under \"" + address[1] + "\" instead of \"" + "/Decklight4".substring(1) + "\"");
        }
        Set<SocketAddress> set = this.clients;
        synchronized (set) {
            if (!this.clients.contains(peer)) {
                this.registerNewClient(peer);
            }
        }
        try {
            String command = address[2];
            if (command.equals("commit")) {
                this.commit(args);
            } else {
                if (command.equals("getTime")) {
                    return this.getTime();
                }
                if (command.equals("getBounceletTypes")) {
                    return this.getBounceletTypes();
                }
                if (command.equals("getTypeInfo")) {
                    return this.getTypeInfo(args);
                }
                if (command.equals("getTypeSkill")) {
                    return this.getTypeSkill(args);
                }
                if (command.equals("listenToOutputPort")) {
                    this.listenToOutputPort(args);
                } else if (!command.equals("venerateProfDrake")) {
                    if (command.equals("addBouncelet")) {
                        this.addBouncelet(args);
                    } else if (command.equals("removeBouncelet")) {
                        this.removeBouncelet(args);
                    } else if (command.equals("addConnection")) {
                        this.addConnection(args);
                    } else if (command.equals("removeConnection")) {
                        this.removeConnection(args);
                    } else if (command.equals("setPlayState")) {
                        this.setPlayState(args);
                    } else if (command.equals("setInput")) {
                        this.setInput(args);
                    } else if (command.equals("byebye")) {
                        if (this.slave) {
                            this.decklight.byebye();
                        }
                        Set<SocketAddress> set2 = this.clients;
                        synchronized (set2) {
                            this.clients.remove(peer);
                        }
                    } else {
                        throw new OSCException(OSCException.Error.undefined);
                    }
                }
            }
            return new Object[0];
        }
        catch (OSCException ex) {
            throw ex;
        }
        catch (ClassCastException ex) {
            throw new OSCException(OSCException.Error.mismatch);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new OSCException(OSCException.Error.missing);
        }
        catch (NullPointerException ex) {
            throw new OSCException(OSCException.Error.corrupt);
        }
        catch (IllegalArgumentException ex) {
            throw new OSCException(OSCException.Error.failed);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new OSCException(OSCException.Error.failed);
        }
    }

    private static String getSalutation() {
        Calendar now = Calendar.getInstance();
        int hours = now.get(11);
        if (hours >= 23 && hours <= 4) {
            return "Night";
        }
        if (hours >= 18) {
            return "Evening";
        }
        if (hours >= 12) {
            return "Afternoon";
        }
        return "Morning";
    }

    private void registerNewClient(SocketAddress peer) {
        this.clients.add(peer);
        ++this.connectionCount;
        int unity = this.connectionCount % 10;
        int tenty = this.connectionCount / 10 % 10;
        String index = this.connectionCount <= 3 ? (new String[]{"first", "second", "third"})[this.connectionCount - 1] : (unity >= 1 && unity <= 3 && tenty != 1 ? String.valueOf(this.connectionCount) + (new String[]{"st", "nd", "rd"})[unity - 1] : String.valueOf(this.connectionCount) + "th");
        String text = String.format(WELCOME_MESSAGE, DecklightServer.getSalutation(), index);
        LogMessage message = new LogMessage(Level.INFO, LogMessage.LocationType.DECKLIGHT, -1, "Information", text, this.decklight.getTime());
        Object[] args = Cromagnon.fromLogMessage(message);
        this.send(peer, "logMessage", args);
    }

    private void commit(Object ... args) {
        Long when = (Long)args[0];
        this.decklight.commit(when);
    }

    private Object[] getTime() {
        double result = this.decklight.getTime();
        return new Object[]{result};
    }

    private Object[] getBounceletTypes() {
        Collection<String> bounceletTypes = this.decklight.getBounceletTypes();
        return Cromagnon.fromStringCollection(bounceletTypes);
    }

    private Object[] getTypeInfo(Object ... args) throws OSCException {
        String name = (String)args[0];
        if (name == null) {
            throw new OSCException(OSCException.Error.infeasable);
        }
        BounceletInfo info = this.decklight.getBounceletTypeInfo(name);
        if (info == null) {
            return new Object[0];
        }
        return Cromagnon.fromBouncelet(info);
    }

    private Object[] getTypeSkill(Object ... args) throws OSCException {
        String name = (String)args[0];
        if (name == null) {
            throw new OSCException(OSCException.Error.infeasable);
        }
        SkillType result = this.decklight.getBounceletSkillType(name);
        return new Object[]{result.ordinal()};
    }

    private void listenToOutputPort(Object ... args) {
        int bounceletId = (Integer)args[0];
        int portNum = (Integer)args[1];
        boolean enabled = (Boolean)args[2];
        this.decklight.listenToOutputPort(bounceletId, portNum, enabled);
    }

    private void addBouncelet(Object ... args) throws OSCException {
        int bounceletId = (Integer)args[0];
        String bounceletName = (String)args[1];
        if (bounceletName == null) {
            throw new OSCException(OSCException.Error.infeasable);
        }
        BounceletInfo info = this.bounceletTypes.get(bounceletName);
        this.decklight.addBouncelet(bounceletId, info);
    }

    private void removeBouncelet(Object ... args) {
        int bounceletId = (Integer)args[0];
        this.decklight.removeBouncelet(bounceletId);
    }

    private void addConnection(Object ... args) throws OSCException {
        int connectionId = (Integer)args[0];
        int srcId = (Integer)args[1];
        String srcName = (String)args[2];
        if (srcName == null) {
            throw new OSCException(OSCException.Error.infeasable);
        }
        int dstId = (Integer)args[3];
        String dstName = (String)args[4];
        if (dstName == null) {
            throw new OSCException(OSCException.Error.infeasable);
        }
        this.decklight.addConnection(connectionId, srcId, srcName, dstId, dstName);
    }

    private void removeConnection(Object ... args) {
        int cId = (Integer)args[0];
        this.decklight.removeConnection(cId);
    }

    private void setPlayState(Object ... args) {
        int pNum = (Integer)args[0];
        long when = (Long)args[1];
        PlayState state = PlayState.values()[pNum];
        this.decklight.setPlayState(state, when);
    }

    private void setInput(Object ... args) {
        int bounceletId = (Integer)args[0];
        String portName = (String)args[1];
        Class<?> dataType = this.decklight.getInputType(bounceletId, portName);
        Object value = Cromagnon.toValue(dataType, args[2]);
        this.decklight.setInput(bounceletId, portName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(String message, Object ... args) {
        message = "/PitchTech/" + message;
        Set<SocketAddress> set = this.clients;
        synchronized (set) {
            Iterator<SocketAddress> iter = this.clients.iterator();
            while (iter.hasNext()) {
                SocketAddress addr = iter.next();
                try {
                    this.server.send(addr, message, args);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.out.println("Removing faulty client: " + addr);
                    iter.remove();
                }
            }
        }
    }

    private void send(SocketAddress addr, String message, Object ... args) {
        message = "/PitchTech/" + message;
        try {
            this.server.send(addr, message, args);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void logMessage(LogMessage message) {
        Object[] args = Cromagnon.fromLogMessage(message);
        this.broadcast("logMessage", args);
    }

    public void playStateChanged(PlayState playState) {
        Object[] args = new Object[]{playState.ordinal()};
        this.broadcast("playStateChanged", args);
    }

    public void portValueChanged(int bounceletId, int portNum, boolean isOutput, Object value) {
        Object[] args = new Object[]{bounceletId, portNum, isOutput, Cromagnon.fromValue(value)};
        this.broadcast("portValueChanged", args);
    }

    private static void printHelpAndExit() {
        System.out.println("Usage: java -jar Decklight4.jar [port_num] [tcp|udp]");
        System.out.println(" Default port num: 61453");
        System.out.println(" Default transport: udp");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length > 2) {
            DecklightServer.printHelpAndExit();
        }
        if (args.length == 1 && (args[0].equals("-h") || args[0].equals("--help"))) {
            DecklightServer.printHelpAndExit();
        }
        int portNum = 61453;
        boolean isTcp = false;
        boolean slave = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equalsIgnoreCase("tcp")) {
                isTcp = true;
            } else if (arg.equalsIgnoreCase("udp")) {
                isTcp = false;
            } else if (arg.equalsIgnoreCase("slave")) {
                slave = true;
            } else {
                try {
                    portNum = Integer.parseInt(arg);
                }
                catch (NumberFormatException ex) {
                    DecklightServer.printHelpAndExit();
                }
            }
            ++n2;
        }
        long clock = System.currentTimeMillis();
        System.out.println(Version.getFullAppString());
        try {
            new DecklightServer(portNum, isTcp, slave);
            System.out.println("Server started in " + (System.currentTimeMillis() - clock) + "ms");
            System.out.println("Good Morning, Prof. Drake. I'm ready for my first lesson.");
        }
        catch (IOException ex) {
            System.err.println("Failed to create server:");
            ex.printStackTrace();
        }
    }
}

