/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.math;

public class HilbertCurve {
    private final int n;
    public int x;
    public int y;
    public int s;

    public HilbertCurve(int n) {
        this.n = n;
    }

    public void xyFromS1() {
        int state = 0;
        this.x = 0;
        this.y = 0;
        int i = 2 * this.n - 2;
        while (i >= 0) {
            int row = 4 * state | this.s >>> i & 3;
            this.x = this.x << 1 | 37740 >>> row & 1;
            this.y = this.y << 1 | 14790 >>> row & 1;
            state = 1047237825 >>> 2 * row & 3;
            i -= 2;
        }
    }

    public void xyFromS2() {
        int i = 0;
        while (i < 2 * this.n) {
            int sa = this.s >>> i + 1 & 1;
            int sb = this.s >>> i & 1;
            if ((sa ^ sb) == 0) {
                int temp = this.x;
                this.x = this.y ^ -sa;
                this.y = temp ^ -sa;
            }
            this.x = this.x >>> 1 | sa << 31;
            this.y = this.y >>> 1 | (sa ^ sb) << 31;
            i += 2;
        }
        this.x >>>= 32 - this.n;
        this.y >>>= 32 - this.n;
    }

    public void xyFromS3() {
        int s = this.s | 0x55555555 << 2 * this.n;
        int sr = s >>> 1 & 0x55555555;
        int cs = (s & 0x55555555) + sr ^ 0x55555555;
        cs ^= cs >>> 2;
        cs ^= cs >>> 4;
        cs ^= cs >>> 8;
        cs ^= cs >>> 16;
        int swap = cs & 0x55555555;
        int comp = cs >>> 1 & 0x55555555;
        int t = s & swap ^ comp;
        s = s ^ sr ^ t ^ t << 1;
        t = ((s &= (1 << 2 * this.n) - 1) ^ s >>> 1) & 0x22222222;
        s = s ^ t ^ t << 1;
        t = (s ^ s >>> 2) & 0xC0C0C0C;
        s = s ^ t ^ t << 2;
        t = (s ^ s >>> 4) & 0xF000F0;
        s = s ^ t ^ t << 4;
        t = (s ^ s >>> 8) & 0xFF00;
        s = s ^ t ^ t << 8;
        this.x = s >>> 16;
        this.y = s & 0xFFFF;
    }

    public void sFromXy() {
        int s = 0;
        int i = this.n - 1;
        while (i >= 0) {
            int xi = this.x >>> i & 1;
            int yi = this.y >>> i & 1;
            if (yi == 0) {
                int temp = this.x;
                this.x = this.y ^ -xi;
                this.y = temp ^ -xi;
            }
            s = 4 * s + 2 * xi + (xi ^ yi);
            --i;
        }
    }

    public void inc() {
        int state = 0;
        int dx = -((1 << this.n) - 1);
        int dy = 0;
        int i = this.n - 1;
        while (i >= 0) {
            boolean doChange;
            int row = 4 * state | 2 * (this.x >>> i & 1) | this.y >>> i & 1;
            boolean bl = doChange = (48603 >>> row & 1) != 0;
            if (doChange) {
                dx = (373626457 >>> 2 * row & 3) - 1;
                dy = (0x51166516 >>> 2 * row & 3) - 1;
            }
            state = -1880729551 >> 2 * row & 3;
            --i;
        }
        this.x += dx;
        this.y += dy;
        ++this.s;
    }
}

