/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.io.File;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.Decklight;
import org.corebounce.decklight.GraphListener;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    private Decklight server;
    private GraphListener listener;
    private boolean isAudioInActive = false;
    private File file = null;

    public boolean isAudioInActive() {
        return this.isAudioInActive;
    }

    public void setAudioInActive(boolean isAudioInActive) {
        this.isAudioInActive = isAudioInActive;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setGraphListener(GraphListener listener) {
        this.listener = listener;
        if (this.server != null) {
            this.server.addGraphListener(listener);
        }
    }

    public void init() {
        this.server = new Decklight();
        if (this.listener != null) {
            this.server.addGraphListener(this.listener);
        }
    }

    public void flush() {
        if (this.server == null) {
            return;
        }
        this.server.dispose();
        this.server = null;
    }

    public void addBouncelets(BounceletBase ... bouncelets) {
        BounceletBase[] bounceletBaseArray = bouncelets;
        int n = bouncelets.length;
        int n2 = 0;
        while (n2 < n) {
            BounceletBase bouncelet = bounceletBaseArray[n2];
            this.server.addBouncelet(bouncelet);
            ++n2;
        }
    }

    public <T> void connect(OutputPort<? extends T> src, InputPort<T> dst) {
        this.server.addConnection(src, dst);
    }

    public <T> void disconnect(OutputPort<? extends T> src, InputPort<T> dst) {
        this.server.removeConnection(src, dst);
    }

    public <E> void setInput(InputPort<E> port, E value) {
        this.server.setInput(port, value);
        this.server.commit();
    }

    public void commit() {
        this.server.commit();
    }

    public void commitAndPlay() {
        long time = this.server.getTime();
        this.server.commit(time);
        this.server.setPlayState(PlayState.PLAY, time, null);
        this.server.commit(time);
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        long time = this.server.getTime();
        this.server.setPlayState(PlayState.STOP, time, null);
        this.server.commit(time);
    }
}

