/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public class LevelMeter
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private static final int SUSTAIN_TIME = 3000;
    private final float DECAY_RATE = (float)AudioMath.dbToLevel(-0.003125);
    private float[] monoData;
    private float level = 0.0f;
    private float powerLevel = 0.0f;
    private int sustain = 0;
    private int powerSustain = 0;

    public LevelMeter() {
        super("audio.analysis.level", "Analyze the audio level");
    }

    public void cycle() {
        WaveData wave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(wave.nbChannels, wave.nbFrames, wave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        if (this.monoData == null || this.monoData.length != wave.nbFrames) {
            this.monoData = new float[wave.nbFrames];
        }
        Arrays.fill(this.monoData, 0.0f);
        float correction = 1.0f / (float)wave.nbChannels;
        int chan = 0;
        while (chan < wave.nbChannels) {
            float[] cData = wave.data[chan];
            System.arraycopy(cData, 0, outWave.data[chan], 0, cData.length);
            assert (cData.length == this.monoData.length);
            int i = 0;
            while (i < cData.length) {
                int n = i;
                this.monoData[n] = this.monoData[n] + cData[i] * correction;
                ++i;
            }
            ++chan;
        }
        int i = 0;
        while (i < this.monoData.length) {
            float v = this.monoData[i];
            float ls = v < 0.0f ? -v : v;
            float ss = v * v;
            if (ls > this.level) {
                this.level = ls;
                this.sustain = 3000;
            } else if (this.sustain <= 0) {
                this.level *= this.DECAY_RATE;
                if (this.level < ls) {
                    this.level = ls;
                }
            } else {
                --this.sustain;
            }
            if (ss > this.powerLevel) {
                this.powerLevel = ss;
                this.powerSustain = 3000;
            } else if (this.powerSustain <= 0) {
                this.powerLevel *= this.DECAY_RATE;
                if (this.powerLevel < ss) {
                    this.powerLevel = ss;
                }
            } else {
                --this.powerSustain;
            }
            ++i;
        }
    }

    public float getLevel() {
        return (float)AudioMath.levelToDb(this.level);
    }

    public float getPowerLevel() {
        return (float)AudioMath.levelToDb(this.powerLevel);
    }
}

