/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import org.corebounce.pitchbox.Controller;

public class LevelMeterPanel
extends JPanel {
    private static final long serialVersionUID = -559026163L;
    private static final int MIN_WIDTH = 150;
    private static final int MIN_HEIGHT = 16;
    private static final Color COLOR = new Color(195, 150, 60);
    private final Controller audioEngine;

    public LevelMeterPanel(Controller audioEngine) {
        this.audioEngine = audioEngine;
        super.setBorder(new EtchedBorder());
    }

    public void start() {
        LevelMonitor monitor = new LevelMonitor();
        Thread thread = new Thread(monitor);
        thread.setName("Level Monitor");
        thread.setDaemon(true);
        thread.start();
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 16);
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 16);
    }

    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.clearRect(0, 0, width, height);
        float level = this.audioEngine.getRecordLevel() * (float)width / 50.0f;
        int sep = (int)(level + (float)width);
        if (sep < 0) {
            sep = 0;
        }
        if (sep > 2) {
            Color oldColor = g.getColor();
            g.setColor(COLOR);
            g.fill3DRect(0, 0, sep - 2, height - 3, true);
            g.setColor(oldColor);
        }
    }

    private class LevelMonitor
    implements Runnable {
        private LevelMonitor() {
        }

        public void run() {
            int refreshRate = 0;
            if (LevelMeterPanel.this.getGraphicsConfiguration().getDevice() != null && LevelMeterPanel.this.getGraphicsConfiguration().getDevice().getDisplayMode() != null) {
                refreshRate = LevelMeterPanel.this.getGraphicsConfiguration().getDevice().getDisplayMode().getRefreshRate();
            }
            int rate = refreshRate != 0 && refreshRate < 120 && refreshRate > 10 ? 1000 / refreshRate : 10;
            while (true) {
                try {
                    Thread.sleep(rate);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            LevelMeterPanel.this.repaint();
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

