/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.corebounce.common.audio.file.AudioFileFilter;
import org.corebounce.common.utils.ClassLoaderUtils;
import org.corebounce.pitchbox.Controller;
import org.corebounce.pitchbox.LevelMeterPanel;
import org.corebounce.pitchbox.Settings;
import org.corebounce.pitchbox.SettingsDialog;
import org.corebounce.pitchbox.utils.AwtTools;
import org.corebounce.pitchbox.utils.TableLayout;

public class LineControlPanel
extends JPanel {
    private static final long serialVersionUID = -559026163L;
    private final Controller audioEngine;
    private final LevelMeterPanel meter;
    private final JCheckBox chkAudioIn;
    private final JCheckBox chkFile;
    private final JButton btnSettings;
    private JFileChooser chooser = null;
    private SettingsDialog settingsDialog = null;

    public LineControlPanel(Controller audioEngine) {
        this.audioEngine = audioEngine;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.ipadx = 2;
        gbc.ipady = 2;
        TableLayout layout = new TableLayout(4, gbc);
        super.setLayout(layout);
        this.chkAudioIn = new JCheckBox("Audio In");
        this.chkAudioIn.setToolTipText("Transform audio from the default audio input device");
        this.chkAudioIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineControlPanel.this.audioSourceChanged();
            }
        });
        this.add(this.chkAudioIn);
        this.chkFile = new JCheckBox("File");
        this.chkFile.setToolTipText("Transform audio from a music file...");
        this.chkFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineControlPanel.this.audioSourceChanged();
            }
        });
        this.add(this.chkFile);
        this.meter = new LevelMeterPanel(audioEngine);
        this.meter.setToolTipText("Displays the input audio level");
        this.add(this.meter);
        this.btnSettings = new JButton("Settings...");
        this.btnSettings.setToolTipText("Change settings such as sample rate, buffer size, etc");
        this.btnSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineControlPanel.this.openSettings();
            }
        });
        this.add(this.btnSettings);
        this.chooser = this.buildFileChooser();
    }

    public void start() {
        this.meter.start();
    }

    private void openSettings() {
        if (this.settingsDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.settingsDialog = new SettingsDialog((Frame)AwtTools.getWindow(this), this.audioEngine);
            AwtTools.centerWindowOn(this.settingsDialog, this);
        }
        this.settingsDialog.setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void audioSourceChanged() {
        if (!this.chkAudioIn.isEnabled() || !this.chkFile.isEnabled()) {
            return;
        }
        this.chkAudioIn.setEnabled(false);
        this.chkFile.setEnabled(false);
        this.audioEngine.setAudioInActive(this.chkAudioIn.isSelected());
        if (this.chkFile.isSelected() != (this.audioEngine.getFile() != null)) {
            if (this.chkFile.isSelected()) {
                ClassLoaderUtils.ensureClassPath();
                int result = this.chooser.showOpenDialog(this);
                if (result == 0) {
                    this.audioEngine.setFile(this.chooser.getSelectedFile());
                    Settings.setCurrentDir(this.chooser.getCurrentDirectory());
                } else {
                    this.audioEngine.setFile(null);
                    this.chkFile.setSelected(false);
                }
            } else {
                this.audioEngine.setFile(null);
            }
        }
        this.chkAudioIn.setEnabled(true);
        this.chkFile.setEnabled(true);
        this.audioEngine.rebuild();
    }

    private JFileChooser buildFileChooser() {
        ClassLoaderUtils.ensureClassPath();
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(Settings.getCurrentDir());
        chooser.setFileFilter(AudioFileFilter.readInstance());
        return chooser;
    }
}

