/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.corebounce.decklight.audio.device.AudioIO;
import org.corebounce.pitchbox.EffectChooserPanel;
import org.corebounce.pitchbox.LineControlPanel;
import org.corebounce.pitchbox.utils.IconLoader;

public class PitchBoxFrame
extends JFrame {
    private static final long serialVersionUID = 3581592343465522449L;
    private final EffectChooserPanel pnlChooser = new EffectChooserPanel();
    private final LineControlPanel pnlLine = new LineControlPanel(this.pnlChooser);
    private final JPanel pnlControl = new JPanel();
    private final JPanel lower = new JPanel();

    public PitchBoxFrame() {
        super("PitchBox 2.0.2  by N. Juillerat / (c) 2007-2011 PitchTech");
        super.setDefaultCloseOperation(0);
        super.setResizable(false);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PitchBoxFrame.this.pnlChooser.stop();
                PitchBoxFrame.this.setVisible(false);
                PitchBoxFrame.this.dispose();
                System.exit(0);
            }
        });
        super.setLayout(new BorderLayout());
        Font titleFont = new Font("Dialog", 0, 12);
        TitledBorder lineBorder = new TitledBorder("Audio source");
        lineBorder.setTitleFont(titleFont);
        this.pnlLine.setBorder(lineBorder);
        this.add((Component)this.pnlLine, "North");
        this.add((Component)this.lower, "Center");
        this.lower.setLayout(new BorderLayout());
        TitledBorder chooserBorder = new TitledBorder("Audio effect");
        chooserBorder.setTitleFont(titleFont);
        this.pnlChooser.setBorder(chooserBorder);
        this.lower.add((Component)this.pnlChooser, "North");
        TitledBorder controlBorder = new TitledBorder("Controls");
        controlBorder.setTitleFont(titleFont);
        this.pnlControl.setPreferredSize(new Dimension(100, 130));
        this.pnlControl.setBorder(controlBorder);
        this.lower.add((Component)this.pnlControl, "Center");
        this.pnlChooser.setControlPanel(this.pnlControl);
        ImageIcon icon = IconLoader.createImageIcon(PitchBoxFrame.class, "PitchTech.png", -1, -1);
        super.setIconImage(icon.getImage());
    }

    public void init() {
        this.pnlChooser.init();
    }

    public void start() {
        System.setProperty("audio.line.startup-time", Double.valueOf(0.25).toString());
        AudioIO.instance().setAutoFallbackMode(true);
        this.pnlLine.start();
        this.pnlChooser.start();
    }
}

