/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.BeatBox;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class BeatFilter
extends SoundEffect {
    private BeatBox beatBox;

    public void initEngine(Engine engine) {
        super.init(engine, PowerOf2.p512);
        this.beatBox = new BeatBox();
        super.addFourierEffect(engine, this.beatBox, PowerOf2.p2048);
    }

    public void initGui(final Engine engine, JPanel panel) {
        JLabel label = new JLabel("Effect: ");
        panel.add(label);
        final LinkedHashMap<String, BeatBox.Preset> presets = new LinkedHashMap<String, BeatBox.Preset>();
        presets.put("Filter beats", BeatBox.Preset.BeatFilter);
        presets.put("Extract beats", BeatBox.Preset.BeatExtract);
        presets.put("Boost beats", BeatBox.Preset.BeatSoftEnhance);
        final JComboBox<Object> combo = new JComboBox<Object>(presets.keySet().toArray());
        panel.add(combo);
        engine.setInput(this.beatBox.inPreset, BeatBox.Preset.BeatFilter);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = (String)combo.getSelectedItem();
                if (item != null) {
                    BeatBox.Preset value = (BeatBox.Preset)presets.get(item);
                    engine.setInput(((BeatFilter)BeatFilter.this).beatBox.inPreset, value);
                }
            }
        });
    }
}

