/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.effect.base.Gain;
import org.corebounce.decklight.bouncelets.audio.effect.wave.amplitude.Saturate;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.Octaver;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class Distort
extends SoundEffect {
    private int mode;

    public void initEngine(Engine engine) {
        super.init(engine, PowerOf2.p1);
        if (this.mode == 0) {
            Octaver octaver = new Octaver();
            engine.addBouncelets(octaver);
            engine.connect(this.sourcePort, octaver.inAudio);
            engine.connect(octaver.outAudio, this.targetPort);
            engine.setInput(octaver.inStrength, 0.5);
        } else if (this.mode == 1) {
            Octaver octaver = new Octaver();
            engine.addBouncelets(octaver);
            engine.connect(this.sourcePort, octaver.inAudio);
            engine.connect(octaver.outAudio, this.targetPort);
            engine.setInput(octaver.inStrength, 1.0);
        } else if (this.mode == 2) {
            Saturate saturate = new Saturate();
            Gain gain = new Gain();
            engine.addBouncelets(saturate, gain);
            engine.connect(this.sourcePort, saturate.inAudio);
            engine.connect(saturate.outAudio, gain.inAudio);
            engine.connect(gain.outAudio, this.targetPort);
            engine.setInput(gain.inGain, -4.0);
        }
    }

    public void initGui(final Engine engine, JPanel panel) {
        JLabel label = new JLabel("Type: ");
        panel.add(label);
        final JComboBox<String> combo = new JComboBox<String>(new String[]{"Half Wave", "Full Wave", "Saturate"});
        panel.add(combo);
        combo.setSelectedIndex(this.mode);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!combo.isEnabled()) {
                    return;
                }
                Distort.this.mode = combo.getSelectedIndex();
                Distort.this.rebuildEngine(engine);
            }
        });
    }
}

