/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.convert.format.SpectrumToWave;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.effect.base.Volume;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PitchShiftOctave;
import org.corebounce.decklight.bouncelets.audio.flow.Mixer;
import org.corebounce.decklight.bouncelets.audio.flow.Synchronize;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class OctaveShifter
extends SoundEffect {
    private WaveToSpectrum wave2spectrum;
    private Volume dryVolume = new Volume();
    private Volume wetVolume = new Volume();
    private int mode = 0;

    public void initEngine(Engine engine) {
        if (this.mode == 0) {
            super.init(engine, PowerOf2.p32);
        } else if (this.mode == 1) {
            super.init(engine, PowerOf2.p64);
        } else {
            super.init(engine, PowerOf2.p128);
        }
        this.wave2spectrum = new WaveToSpectrum();
        PitchShiftOctave octave = new PitchShiftOctave();
        SpectrumToWave spectrum2wave = new SpectrumToWave();
        BlockSize blockSize1 = new BlockSize();
        BlockSize blockSize2 = new BlockSize();
        Synchronize sync = new Synchronize();
        Mixer mixer = new Mixer();
        engine.addBouncelets(this.wave2spectrum, octave, spectrum2wave, blockSize1, blockSize2, this.dryVolume, this.wetVolume, sync, mixer);
        engine.connect(this.sourcePort, this.wave2spectrum.inAudio());
        engine.connect(this.wave2spectrum.outSpectrum(), octave.inSpectrum);
        engine.connect(octave.outSpectrum, spectrum2wave.inSpectrum());
        engine.connect(spectrum2wave.outAudio(), blockSize1.inAudio);
        engine.connect(blockSize1.outAudio, this.wetVolume.inAudio);
        engine.connect(this.wetVolume.outAudio, sync.inAudio1);
        engine.connect(sync.outAudio1, mixer.inAudio1);
        engine.connect(this.sourcePort, blockSize2.inAudio);
        engine.connect(blockSize2.outAudio, this.dryVolume.inAudio);
        engine.connect(this.dryVolume.outAudio, sync.inAudio2);
        engine.connect(sync.outAudio2, mixer.inAudio2);
        engine.connect(mixer.outAudio, this.targetPort);
        engine.setInput(blockSize1.inBlockSize, this.blockSize);
        engine.setInput(blockSize2.inBlockSize, this.blockSize);
        engine.setInput(spectrum2wave.inWindow(), WindowType.HannShrink16);
        engine.setInput(this.wave2spectrum.inOverlap(), PowerOf2.p32);
        engine.setInput(mixer.inNormalized, false);
        if (this.mode == 0) {
            engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p1024);
        } else if (this.mode == 1) {
            engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p2048);
        } else {
            engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p4096);
        }
    }

    public void initGui(final Engine engine, JPanel panel) {
        super.addDoubleSliderLinear(engine, panel, "Strength: ", 0.0, 1.0, 1.0, new SoundEffect.SliderListener(){

            public void apply(Engine engine, double value) {
                engine.setInput(((OctaveShifter)OctaveShifter.this).dryVolume.inVolume, Math.sqrt(1.0 - value));
                engine.setInput(((OctaveShifter)OctaveShifter.this).wetVolume.inVolume, -Math.sqrt(value));
            }
        });
        JLabel label = new JLabel("Mode: ");
        panel.add(label);
        final JComboBox<String> combo = new JComboBox<String>(new String[]{"Voice", "Mixed", "Music"});
        panel.add(combo);
        combo.setSelectedIndex(this.mode);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!combo.isEnabled()) {
                    return;
                }
                OctaveShifter.this.mode = combo.getSelectedIndex();
                OctaveShifter.this.rebuildEngine(engine);
            }
        });
    }

    public void initMode(SoundEffect.SourceMode srcMode) {
        this.mode = srcMode == SoundEffect.SourceMode.AUDIO_IN ? 0 : (srcMode == SoundEffect.SourceMode.MIXED ? 1 : 2);
    }
}

