/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class PitchScrew
extends SoundEffect {
    private org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PitchScrew pitchScrew = new org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PitchScrew();
    private int mode = 0;

    public void initEngine(Engine engine) {
        if (this.mode == 0) {
            super.init(engine, PowerOf2.p256);
            super.addFourierEffect(engine, this.pitchScrew, PowerOf2.p1024);
        } else if (this.mode == 1) {
            super.init(engine, PowerOf2.p512);
            super.addFourierEffect(engine, this.pitchScrew, PowerOf2.p2048);
        } else {
            super.init(engine, PowerOf2.p1024);
            super.addFourierEffect(engine, this.pitchScrew, PowerOf2.p4096);
        }
    }

    public void initGui(final Engine engine, JPanel panel) {
        super.addDoubleSliderLinear(engine, panel, "Strength: ", 0.0, 1.0, 1.0, new SoundEffect.SliderListener(){

            public void apply(Engine engine, double value) {
                engine.setInput(((PitchScrew)PitchScrew.this).pitchScrew.inDryLevel, Math.sqrt(1.0 - value));
                engine.setInput(((PitchScrew)PitchScrew.this).pitchScrew.inWetLevel, Math.sqrt(value) * 1.2);
            }
        });
        JLabel label = new JLabel("Mode: ");
        panel.add(label);
        final JComboBox<String> combo = new JComboBox<String>(new String[]{"Voice", "Mixed", "Music"});
        panel.add(combo);
        combo.setSelectedIndex(this.mode);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!combo.isEnabled()) {
                    return;
                }
                PitchScrew.this.mode = combo.getSelectedIndex();
                PitchScrew.this.rebuildEngine(engine);
            }
        });
    }

    public void initMode(SoundEffect.SourceMode srcMode) {
        this.mode = srcMode == SoundEffect.SourceMode.AUDIO_IN ? 0 : (srcMode == SoundEffect.SourceMode.MIXED ? 1 : 2);
    }
}

