/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.BitSet;

public class TableLayout
extends GridBagLayout {
    private static final long serialVersionUID = 5511537663228706394L;
    private final int nbColumns;
    private GridBagConstraints dfltConstraint = new GridBagConstraints();
    private final BitSet usedCells = new BitSet();
    private int x = 0;
    private int y = 0;

    public TableLayout(int nbColumns) {
        this.nbColumns = nbColumns;
    }

    public TableLayout(int nbColumns, GridBagConstraints dfltConstraint) {
        this(nbColumns);
        this.dfltConstraint = dfltConstraint;
    }

    public GridBagConstraints getDfltConstraint() {
        return this.dfltConstraint;
    }

    public void setDfltConstraint(GridBagConstraints dfltConstraint) {
        this.dfltConstraint = dfltConstraint;
    }

    public void invalidateLayout(Container target) {
        super.invalidateLayout(target);
        this.usedCells.clear();
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        GridBagConstraints gbc = (GridBagConstraints)constraints;
        if (gbc == null) {
            gbc = (GridBagConstraints)this.dfltConstraint.clone();
        }
        gbc.gridx = this.x;
        gbc.gridy = this.y;
        this.fill(gbc);
        while (this.isUsed(this.x, this.y)) {
            ++this.x;
            if (this.x < this.nbColumns) continue;
            this.x = 0;
            ++this.y;
        }
        super.addLayoutComponent(comp, gbc);
    }

    private void fill(GridBagConstraints gbc) {
        int h = 0;
        while (h < gbc.gridwidth) {
            int v = 0;
            while (v < gbc.gridheight) {
                this.setUsed(this.x + h, this.y + v, true);
                ++v;
            }
            ++h;
        }
        this.setUsed(this.x, this.y, true);
    }

    private void setUsed(int x, int y, boolean value) {
        if (x < 0 || y < 0 || x >= this.nbColumns) {
            return;
        }
        this.usedCells.set(y * this.nbColumns + x, value);
    }

    private boolean isUsed(int x, int y) {
        if (x < 0 || y < 0 || x >= this.nbColumns) {
            return true;
        }
        return this.usedCells.get(y * this.nbColumns + x);
    }
}

