/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.test;

import java.io.File;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.Decklight;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.music.MidiAction;
import org.corebounce.decklight.bouncelets.music.MidiEvent;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateChangeListener;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecklightTest {
    private final Decklight server = new Decklight();
    private final Map<String, BounceletBase> bounceletTypes = this.server.getBounceletTypes();

    private DecklightTest() {
    }

    private BounceletBase createBouncelet(String name) {
        BounceletBase template = this.bounceletTypes.get(name);
        if (template == null) {
            throw new IllegalArgumentException("Unknown bouncelet: " + name);
        }
        try {
            BounceletBase result = (BounceletBase)template.getClass().newInstance();
            this.server.addBouncelet(result);
            return result;
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot instanciate " + name, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot access " + name, ex);
        }
    }

    private InputPort<?> getInputPort(BounceletBase b, String name) {
        for (InputPort<?> port : b.getInputPorts()) {
            if (!port.getName().equalsIgnoreCase(name)) continue;
            return port;
        }
        throw new IllegalArgumentException("Unknown input port name: " + b + ":" + name);
    }

    private OutputPort<?> getOutputPort(BounceletBase b, String name) {
        for (OutputPort<?> port : b.getOutputPorts()) {
            if (!port.getName().equalsIgnoreCase(name)) continue;
            return port;
        }
        throw new IllegalArgumentException("Unknown output port name: " + b + ":" + name);
    }

    private void connect(BounceletBase src, String outPortName, BounceletBase dst, String inPortName) {
        OutputPort<?> outputPort = this.getOutputPort(src, outPortName);
        InputPort<?> inputPort = this.getInputPort(dst, inPortName);
        this.server.addConnection(outputPort, inputPort);
    }

    private <E> void setInput(BounceletBase b, String inpPortName, E value) {
        InputPort<?> port = this.getInputPort(b, inpPortName);
        this.server.setInput(port, value);
    }

    private void commit() {
        this.server.commit();
    }

    private void commit(long when) {
        this.server.commit(when);
    }

    private void commitAndPlay() {
        this.commitAndPlay(0L);
    }

    private void commitAndPlay(long delay) {
        this.server.setPlayState(PlayState.PLAY, this.server.getTime() + delay, new Runnable(){

            public void run() {
                System.out.println("Now playing");
            }
        });
        this.server.commit(this.server.getTime() + delay);
    }

    private void sleep(double seconds) {
        try {
            Thread.sleep((long)(seconds * 1000.0));
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void testLine() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p64);
        this.setInput(audioConfig, "buffers", 8);
        this.commitAndPlay();
        this.sleep(200.0);
    }

    public void testFileReader() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase fileReader = this.createBouncelet("audio.line.filereader");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(fileReader, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "buffers", 4);
        File file = new File("D:\\Music\\Imagine.mp3");
        this.setInput(fileReader, "file", file);
        final CountDownLatch barrier = new CountDownLatch(1);
        this.server.addPlayStateChangeListener(new PlayStateChangeListener(){

            public void playStateChanged(PlayState newState, long when) {
                if (newState == PlayState.STOP) {
                    barrier.countDown();
                }
            }
        });
        this.commitAndPlay(0L);
        try {
            barrier.await();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Terminated");
    }

    public void testFileReaderPitchshift() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase fileReader = this.createBouncelet("audio.line.filereader");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase pitchShift = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(fileReader, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", pitchShift, "in");
        this.connect(pitchShift, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p2048);
        this.setInput(wave2spectrum, "overlap", PowerOf2.p4);
        this.setInput(pitchShift, "zeroPadding", PowerOf2.p1);
        this.setInput(pitchShift, "ratio", 1.4);
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "buffers", 4);
        File file = new File("C:\\Documents and Settings\\User\\My Documents\\My Music\\DanseMacabre.mp3");
        this.setInput(fileReader, "file", file);
        this.setInput(audioOut, "startup", 5.0);
        final CountDownLatch barrier = new CountDownLatch(1);
        this.server.addPlayStateChangeListener(new PlayStateChangeListener(){

            public void playStateChanged(PlayState newState, long when) {
                if (newState == PlayState.STOP) {
                    barrier.countDown();
                }
            }
        });
        this.commitAndPlay(0L);
        try {
            barrier.await();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setInput(fileReader, "file", "");
        System.out.println("Terminated");
    }

    public void testFileReaderPitchshiftL() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase fileReader = this.createBouncelet("audio.line.filereader");
        BounceletBase value = this.createBouncelet("math.const.real");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase beatx = this.createBouncelet("audio.effect.spectrum.time.beatx");
        BounceletBase spectrum2waveL = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase spectrum2waveS = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase wave2spectrum1 = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase wave2spectrum2 = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase pitchShift1 = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift");
        BounceletBase pitchShift2 = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift");
        BounceletBase spectrum2wave1 = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase spectrum2wave2 = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase synchronizer = this.createBouncelet("audio.flow.synchronize");
        BounceletBase mixer = this.createBouncelet("audio.flow.mixer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(fileReader, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", beatx, "in");
        this.connect(beatx, "out.long", spectrum2waveL, "in");
        this.connect(beatx, "out.short", spectrum2waveS, "in");
        this.connect(spectrum2waveL, "out", wave2spectrum1, "in");
        this.connect(spectrum2waveS, "out", wave2spectrum2, "in");
        this.connect(wave2spectrum1, "out", pitchShift1, "in");
        this.connect(wave2spectrum2, "out", pitchShift2, "in");
        this.connect(pitchShift1, "out", spectrum2wave1, "in");
        this.connect(pitchShift2, "out", spectrum2wave2, "in");
        this.connect(spectrum2wave1, "out", synchronizer, "in0");
        this.connect(spectrum2wave2, "out", synchronizer, "in1");
        this.connect(synchronizer, "out0", mixer, "in0");
        this.connect(synchronizer, "out1", mixer, "in1");
        this.connect(mixer, "out", audioOut, "in");
        this.connect(value, "out", pitchShift1, "ratio");
        this.connect(value, "out", pitchShift2, "ratio");
        this.setInput(mixer, "normalized", false);
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p512);
        this.setInput(beatx, "threshold", 0.05);
        this.setInput(beatx, "smoothing", 0.01);
        this.setInput(beatx, "decay.enabled", true);
        this.setInput(beatx, "adjusted", true);
        this.setInput(wave2spectrum1, "blockSize", PowerOf2.p2048);
        this.setInput(wave2spectrum1, "overlap", PowerOf2.p8);
        this.setInput(wave2spectrum2, "blockSize", PowerOf2.p512);
        this.setInput(wave2spectrum2, "overlap", PowerOf2.p8);
        this.setInput(pitchShift2, "zeroPadding", PowerOf2.p4);
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "buffers", 4);
        this.setInput(value, "in", 1.4);
        File file = new File("C:\\Documents and Settings\\User\\My Documents\\My Music\\1 Simona's dream.mp3");
        this.setInput(fileReader, "file", file);
        this.setInput(audioOut, "startup", 5.0);
        final CountDownLatch barrier = new CountDownLatch(1);
        this.server.addPlayStateChangeListener(new PlayStateChangeListener(){

            public void playStateChanged(PlayState newState, long when) {
                if (newState == PlayState.STOP) {
                    barrier.countDown();
                }
            }
        });
        this.commitAndPlay(0L);
        try {
            barrier.await();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Terminated");
    }

    public void testFileReaderWhisper() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase fileReader = this.createBouncelet("audio.line.filereader");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase wave2spectrumNoise = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase getShape = this.createBouncelet("audio.analysis.spectralshape");
        BounceletBase signal = this.createBouncelet("audio.synth.wave.whitenoise");
        BounceletBase toStereo = this.createBouncelet("audio.convert.channels.toMulti");
        BounceletBase shaper = this.createBouncelet("audio.effect.spectrum.filter.shaper");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(fileReader, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", getShape, "in");
        this.connect(signal, "out", toStereo, "in");
        this.connect(toStereo, "out", wave2spectrumNoise, "in");
        this.connect(wave2spectrumNoise, "out", shaper, "in");
        this.connect(getShape, "shape", shaper, "shape");
        this.connect(shaper, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "buffers", 4);
        File file = new File("/home/juillera/music/Imagine.mp3");
        this.setInput(fileReader, "file", file);
        final CountDownLatch barrier = new CountDownLatch(1);
        this.server.addPlayStateChangeListener(new PlayStateChangeListener(){

            public void playStateChanged(PlayState newState, long when) {
                if (newState == PlayState.STOP) {
                    barrier.countDown();
                }
            }
        });
        this.commitAndPlay(2 * AudioConfig.getSampleRate());
        try {
            barrier.await();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Terminated");
    }

    public void testStereo2Quad() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase stereo2quad = this.createBouncelet("audio.effect.spectrum.channels.stereo2quad");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase splitChans = this.createBouncelet("audio.convert.channels.splitChannels");
        BounceletBase mergeChans = this.createBouncelet("audio.convert.channels.mergeChannels");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", stereo2quad, "in");
        this.connect(stereo2quad, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", splitChans, "in");
        this.connect(splitChans, "out0", mergeChans, "in0");
        this.connect(splitChans, "out1", mergeChans, "in1");
        this.connect(mergeChans, "out", audioOut, "in");
        this.setInput(stereo2quad, "surround", true);
        this.setInput(stereo2quad, "strength", 2);
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "buffers", 4);
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testChannels() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase split = this.createBouncelet("audio.convert.channels.splitChannels");
        BounceletBase merge = this.createBouncelet("audio.convert.channels.mergeChannels");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", split, "in");
        this.connect(split, "out0", merge, "in1");
        this.connect(split, "out1", merge, "in0");
        this.connect(merge, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testMixer() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase mixer = this.createBouncelet("audio.flow.mixer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", mixer, "in0");
        this.connect(audioIn, "out", mixer, "in1");
        this.connect(audioIn, "out", mixer, "in2");
        this.connect(audioIn, "out", mixer, "in3");
        this.connect(audioIn, "out", mixer, "in4");
        this.connect(audioIn, "out", mixer, "in5");
        this.connect(audioIn, "out", mixer, "in6");
        this.connect(audioIn, "out", mixer, "in7");
        this.connect(audioIn, "out", mixer, "in8");
        this.connect(audioIn, "out", mixer, "in9");
        this.connect(mixer, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testSubChannels() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase sub = this.createBouncelet("audio.effect.subchannels");
        BounceletBase toStereo = this.createBouncelet("audio.convert.toMulti");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", sub, "in");
        this.connect(sub, "out", toStereo, "in");
        this.connect(toStereo, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testAutoGain() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase dcBlock = this.createBouncelet("audio.effect.dcblock");
        BounceletBase autoGain = this.createBouncelet("audio.effect.autogain");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", dcBlock, "in");
        this.connect(dcBlock, "out", autoGain, "in");
        this.connect(autoGain, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testSaturate() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase dcBlock = this.createBouncelet("audio.effect.dcblock");
        BounceletBase autoGain = this.createBouncelet("audio.effect.autogain");
        BounceletBase saturate = this.createBouncelet("audio.effect.saturate");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", dcBlock, "in");
        this.connect(dcBlock, "out", autoGain, "in");
        this.connect(autoGain, "out", saturate, "in");
        this.connect(saturate, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testHighpass() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase filter = this.createBouncelet("audio.effect.wave.highpass");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", filter, "in");
        this.connect(filter, "out", audioOut, "in");
        this.setInput(filter, "frequency", 20.0);
        this.commitAndPlay();
        double freq = 30.0;
        long sr = AudioConfig.getSampleRate();
        long time = this.server.getTime() + 5L * sr;
        while (freq < 22000.0) {
            this.setInput(filter, "frequency", freq);
            this.commit(time += sr);
            freq *= 1.5;
        }
        this.sleep(20.0);
    }

    public void testLowpass() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase filter = this.createBouncelet("audio.effect.wave.lowpass");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", filter, "in");
        this.connect(filter, "out", audioOut, "in");
        this.setInput(filter, "frequency", 22000.0);
        this.commitAndPlay();
        double freq = 16000.0;
        long sr = AudioConfig.getSampleRate();
        long time = this.server.getTime() + 5L * sr;
        while (freq > 20.0) {
            this.setInput(filter, "frequency", freq);
            this.commit(time += sr);
            freq /= 1.5;
        }
        this.sleep(20.0);
    }

    public void testBandpass() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase filter = this.createBouncelet("audio.effect.wave.bandpass");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", filter, "in");
        this.connect(filter, "out", audioOut, "in");
        this.setInput(filter, "lower", 10.0);
        this.setInput(filter, "upper", 22000.0);
        this.commitAndPlay();
        double upper = 20000.0;
        double lower = 21.0;
        long sr = AudioConfig.getSampleRate();
        long time = this.server.getTime() + 3L * sr;
        while (upper > lower) {
            this.setInput(filter, "upper", upper);
            this.setInput(filter, "lower", lower);
            this.commit(time += sr);
            upper /= 1.25;
            lower *= 1.25;
        }
        this.sleep(20.0);
        this.setInput(filter, "lower", 10.0);
        this.setInput(filter, "upper", 100.0);
        this.commit();
        this.sleep(10.0);
        this.setInput(filter, "lower", 11025.0);
        this.setInput(filter, "upper", 22050.0);
        this.commit();
        this.sleep(10.0);
    }

    public void testEqualizer() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase filter = this.createBouncelet("audio.effect.wave.equalizer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", filter, "in");
        this.connect(filter, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(3.0);
        Random rnd = new Random(0L);
        int i = 0;
        while (i < 15) {
            this.sleep(5.0);
            System.out.println("\nEqualizing:");
            int b = 0;
            while (b < 10) {
                float db = rnd.nextFloat() * 50.0f - 40.0f;
                int j = -50;
                while (j < 10) {
                    if (j == 0) {
                        System.out.print("0");
                    } else if (j < (int)db) {
                        System.out.print("#");
                    } else {
                        System.out.print(" ");
                    }
                    ++j;
                }
                System.out.println();
                this.setInput(filter, "band" + b, Float.valueOf(db));
                ++b;
            }
            this.commit();
            ++i;
        }
    }

    public void testEqualizer1() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase filter = this.createBouncelet("audio.effect.wave.equalizer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", filter, "in");
        this.connect(filter, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p16);
        this.setInput(audioConfig, "buffers", 2);
        this.commitAndPlay();
        this.sleep(8.0);
        System.out.println("Surfing...");
        int i = 0;
        while (i < 500) {
            this.sleep(0.1);
            int b = 0;
            while (b < 10) {
                int f = (b * 9 + 3) % 10;
                double gain = Math.sin((double)(f * i) / 2.0 * Math.PI / 180.0) * 20.0 - 18.0;
                this.setInput(filter, "band" + b, gain);
                ++b;
            }
            this.commit();
            ++i;
        }
    }

    public void testEqualizer2() {
        int j;
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase filter = this.createBouncelet("audio.effect.spectrum.equalizer2");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", filter, "in");
        this.connect(filter, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(wave2spectrum, "overlap", PowerOf2.p2);
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p1024);
        this.setInput(spectrum2wave, "blockSize", PowerOf2.p64);
        this.commitAndPlay();
        this.sleep(3.0);
        int i = 9;
        while (i >= 0) {
            System.out.println("Removing band " + i);
            this.setInput(filter, "band" + i, -100.0);
            this.commit();
            this.sleep(2.0);
            --i;
        }
        i = 9;
        while (i >= 0) {
            System.out.println("Adding band " + i);
            this.setInput(filter, "band" + i, 0.0);
            this.commit();
            this.sleep(2.0);
            --i;
        }
        i = 0;
        while (i <= 9) {
            System.out.println("band pass " + i);
            j = 0;
            while (j <= 9) {
                this.setInput(filter, "band" + j, j == i ? 0.0 : Double.NEGATIVE_INFINITY);
                ++j;
            }
            this.commit();
            this.sleep(2.0);
            ++i;
        }
        i = 0;
        while (i <= 9) {
            System.out.println("band stop " + i);
            j = 0;
            while (j <= 9) {
                this.setInput(filter, "band" + j, j != i ? 0.0 : Double.NEGATIVE_INFINITY);
                ++j;
            }
            this.commit();
            this.sleep(2.0);
            ++i;
        }
        System.out.println("Flying...");
        i = 0;
        while (i < 500) {
            this.sleep(0.1);
            int b = 0;
            while (b < 10) {
                int f = (b * 9 + 3) % 10;
                double gain = Math.sin((double)(f * i) / 2.0 * Math.PI / 180.0) * 20.0 - 18.0;
                this.setInput(filter, "band" + b, gain);
                ++b;
            }
            this.commit();
            ++i;
        }
    }

    public void testDjSplitter() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase filter = this.createBouncelet("audio.effect.wave.djsplit");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", filter, "in");
        this.connect(filter, "out.high", audioOut, "in");
        this.commitAndPlay();
        this.sleep(40.0);
    }

    public void testDjEqualizer() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase filter = this.createBouncelet("audio.effect.wave.djeq");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", filter, "in");
        this.connect(filter, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(8.0);
        System.out.println("Sliding high");
        int i = 0;
        while (i < 20) {
            this.setInput(filter, "high", Double.valueOf(i));
            this.commit();
            this.sleep(0.1);
            ++i;
        }
        i = 20;
        while (i >= -40) {
            this.setInput(filter, "high", Double.valueOf(i));
            this.commit();
            this.sleep(0.1);
            --i;
        }
        this.setInput(filter, "high", 0.0);
        System.out.println("Sliding low");
        i = 0;
        while (i < 20) {
            this.setInput(filter, "low", Double.valueOf(i));
            this.commit();
            this.sleep(0.1);
            ++i;
        }
        i = 20;
        while (i >= -40) {
            this.setInput(filter, "low", Double.valueOf(i));
            this.commit();
            this.sleep(0.1);
            --i;
        }
        this.setInput(filter, "low", 0.0);
        System.out.println("Sliding mid");
        i = 0;
        while (i < 20) {
            this.setInput(filter, "mid", Double.valueOf(i));
            this.commit();
            this.sleep(0.1);
            ++i;
        }
        i = 20;
        while (i >= -40) {
            this.setInput(filter, "mid", Double.valueOf(i));
            this.commit();
            this.sleep(0.1);
            --i;
        }
    }

    public void testEcho() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase echo = this.createBouncelet("audio.effect.wave.echo");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", echo, "in");
        this.connect(echo, "out", audioOut, "in");
        this.setInput(echo, "forw1.level", -0.3);
        this.setInput(echo, "forw1.delay", 0.3);
        this.setInput(echo, "forw2.level", 0.3);
        this.setInput(echo, "forw2.delay", 0.2);
        this.setInput(echo, "back1.level", 0.3);
        this.setInput(echo, "back1.delay", 0.2);
        this.setInput(echo, "back2.level", -0.3);
        this.setInput(echo, "back2.delay", 0.3);
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testTimeNoiseGate() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase bandsplit = this.createBouncelet("audio.effect.wave.bandsplit");
        BounceletBase bandmerge = this.createBouncelet("audio.effect.wave.bandmerge");
        BounceletBase noisegate = this.createBouncelet("audio.effect.noisegate");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", bandsplit, "in");
        this.connect(bandsplit, "out", noisegate, "in");
        this.connect(noisegate, "out", bandmerge, "in");
        this.connect(bandmerge, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testDelay() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase delay = this.createBouncelet("audio.effect.wave.delay");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", delay, "in");
        this.connect(delay, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testSideEcho() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase echo = this.createBouncelet("audio.effect.wave.echo.side");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", echo, "in");
        this.connect(echo, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testClimbEcho() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase echo = this.createBouncelet("audio.effect.wave.echo.climb");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", echo, "in");
        this.connect(echo, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testSledgehammer() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase autoGain = this.createBouncelet("audio.effect.autogain");
        BounceletBase hammer = this.createBouncelet("audio.effect.wave.sledgehammer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", autoGain, "in");
        this.connect(autoGain, "out", hammer, "in");
        this.connect(hammer, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testFlanger() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase split = this.createBouncelet("audio.convert.splitChannels");
        BounceletBase flanger0 = this.createBouncelet("audio.effect.wave.flanger");
        BounceletBase flanger1 = this.createBouncelet("audio.effect.wave.flanger");
        BounceletBase merge = this.createBouncelet("audio.convert.mergeChannels");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", split, "in");
        this.connect(split, "out0", flanger0, "in");
        this.connect(split, "out1", flanger1, "in");
        this.connect(flanger0, "out", merge, "in0");
        this.connect(flanger1, "out", merge, "in1");
        this.connect(merge, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p256);
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testStereoExpand() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase sexp = this.createBouncelet("audio.effect.stereoexpand");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", sexp, "in");
        this.connect(sexp, "out", audioOut, "in");
        this.setInput(sexp, "factor", 0.0);
        this.commitAndPlay();
        this.sleep(5.0);
        int i = 0;
        while (i <= 32) {
            System.out.println("Expansion: " + i + "/32");
            this.setInput(sexp, "factor", (double)i / 32.0);
            this.commit();
            this.sleep(1.0);
            ++i;
        }
        this.sleep(60.0);
    }

    public void testBalance() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase balance = this.createBouncelet("audio.effect.pan");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        BounceletBase wave2windows = this.createBouncelet("audio.convert.wave2windows");
        BounceletBase windows2wave = this.createBouncelet("audio.convert.windows2wave");
        this.connect(audioIn, "out", wave2windows, "in");
        this.connect(wave2windows, "out", balance, "in");
        this.connect(balance, "out", windows2wave, "in");
        this.connect(windows2wave, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(5.0);
        int i = 0;
        while (i <= 80) {
            float pan = (float)i / 10.0f;
            if (pan > 4.0f) {
                pan -= 8.0f;
            }
            System.out.println("Pan position: " + pan);
            this.setInput(balance, "pan", Float.valueOf(pan));
            this.commit();
            this.sleep(0.5);
            ++i;
        }
        this.sleep(3.0);
    }

    public void testPitchShift() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase pitchShift = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", pitchShift, "in");
        this.connect(pitchShift, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(pitchShift, "ratio", 1.125);
        this.setInput(audioConfig, "blockSize", PowerOf2.p64);
        this.setInput(audioConfig, "buffers", 4);
        this.commitAndPlay();
        this.sleep(100.0);
    }

    public void testPitchShiftLength() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase value = this.createBouncelet("math.const.real");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase beatx = this.createBouncelet("audio.effect.spectrum.time.beatx");
        BounceletBase spectrum2waveL = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase spectrum2waveS = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase wave2spectrum1 = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase wave2spectrum2 = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase pitchShift1 = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift");
        BounceletBase pitchShift2 = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift");
        BounceletBase spectrum2wave1 = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase spectrum2wave2 = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase synchronizer = this.createBouncelet("audio.flow.synchronize");
        BounceletBase mixer = this.createBouncelet("audio.flow.mixer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", beatx, "in");
        this.connect(beatx, "out.long", spectrum2waveL, "in");
        this.connect(beatx, "out.short", spectrum2waveS, "in");
        this.connect(spectrum2waveL, "out", wave2spectrum1, "in");
        this.connect(spectrum2waveS, "out", wave2spectrum2, "in");
        this.connect(wave2spectrum1, "out", pitchShift1, "in");
        this.connect(wave2spectrum2, "out", pitchShift2, "in");
        this.connect(pitchShift1, "out", spectrum2wave1, "in");
        this.connect(pitchShift2, "out", spectrum2wave2, "in");
        this.connect(spectrum2wave1, "out", synchronizer, "in0");
        this.connect(spectrum2wave2, "out", synchronizer, "in1");
        this.connect(synchronizer, "out0", mixer, "in0");
        this.connect(synchronizer, "out1", mixer, "in1");
        this.connect(mixer, "out", audioOut, "in");
        this.connect(value, "out", pitchShift1, "ratio");
        this.connect(value, "out", pitchShift2, "ratio");
        this.setInput(mixer, "normalized", false);
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p512);
        this.setInput(beatx, "threshold", 0.05);
        this.setInput(beatx, "smoothing", 0.01);
        this.setInput(beatx, "decay.enabled", true);
        this.setInput(beatx, "adjusted", false);
        this.setInput(wave2spectrum1, "blockSize", PowerOf2.p2048);
        this.setInput(wave2spectrum1, "overlap", PowerOf2.p8);
        this.setInput(wave2spectrum2, "blockSize", PowerOf2.p512);
        this.setInput(wave2spectrum2, "overlap", PowerOf2.p8);
        this.setInput(pitchShift2, "zeroPadding", PowerOf2.p4);
        this.setInput(audioConfig, "blockSize", PowerOf2.p256);
        this.setInput(audioConfig, "buffers", 4);
        this.setInput(value, "in", 1.4);
        this.commitAndPlay();
        this.sleep(200.0);
    }

    public void testPitchShiftMultiRes() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase value = this.createBouncelet("math.const.real");
        BounceletBase djSplit = this.createBouncelet("audio.effect.wave.djsplit");
        BounceletBase wave2spectrumL = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase pitchShiftL = this.createBouncelet("audio.effect.spectrum.pitchshift");
        BounceletBase spectrum2waveL = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase wave2spectrumM = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase pitchShiftM = this.createBouncelet("audio.effect.spectrum.pitchshift");
        BounceletBase spectrum2waveM = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase wave2spectrumH = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase pitchShiftH = this.createBouncelet("audio.effect.spectrum.pitchshift");
        BounceletBase spectrum2waveH = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase synchronizer = this.createBouncelet("audio.flow.synchronize");
        BounceletBase mixer = this.createBouncelet("audio.flow.mixer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", djSplit, "in");
        this.connect(djSplit, "out.low", wave2spectrumL, "in");
        this.connect(wave2spectrumL, "out", pitchShiftL, "in");
        this.connect(pitchShiftL, "out", spectrum2waveL, "in");
        this.connect(spectrum2waveL, "out", synchronizer, "in0");
        this.connect(synchronizer, "out0", mixer, "in0");
        this.setInput(wave2spectrumL, "overlap", PowerOf2.p8);
        this.setInput(wave2spectrumL, "blockSize", PowerOf2.p4096);
        this.setInput(pitchShiftL, "zeroPadding", PowerOf2.p1);
        this.connect(djSplit, "out.mid", wave2spectrumM, "in");
        this.connect(wave2spectrumM, "out", pitchShiftM, "in");
        this.connect(pitchShiftM, "out", spectrum2waveM, "in");
        this.connect(spectrum2waveM, "out", synchronizer, "in1");
        this.connect(synchronizer, "out1", mixer, "in1");
        this.setInput(wave2spectrumM, "overlap", PowerOf2.p8);
        this.setInput(wave2spectrumM, "blockSize", PowerOf2.p2048);
        this.setInput(pitchShiftM, "zeroPadding", PowerOf2.p2);
        this.connect(djSplit, "out.high", wave2spectrumH, "in");
        this.connect(wave2spectrumH, "out", pitchShiftH, "in");
        this.connect(pitchShiftH, "out", spectrum2waveH, "in");
        this.connect(spectrum2waveH, "out", synchronizer, "in2");
        this.connect(synchronizer, "out2", mixer, "in2");
        this.setInput(wave2spectrumH, "overlap", PowerOf2.p8);
        this.setInput(wave2spectrumH, "blockSize", PowerOf2.p1024);
        this.setInput(pitchShiftH, "zeroPadding", PowerOf2.p4);
        this.connect(value, "out", pitchShiftL, "ratio");
        this.connect(value, "out", pitchShiftM, "ratio");
        this.connect(value, "out", pitchShiftH, "ratio");
        this.connect(mixer, "out", audioOut, "in");
        this.setInput(mixer, "normalized", false);
        this.setInput(audioConfig, "blockSize", PowerOf2.p64);
        this.setInput(audioConfig, "buffers", 4);
        this.setInput(value, "in", 1.4);
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testNoiseGate() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase noiseGate = this.createBouncelet("audio.effect.spectrum.noise.gate");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", noiseGate, "in");
        this.connect(noiseGate, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(noiseGate, "threshold", -30.0);
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testNoiseReducer() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase noiseReducer = this.createBouncelet("audio.effect.spectrum.noise.reducer");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", noiseReducer, "in");
        this.connect(noiseReducer, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p256);
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testNoiseFilter() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase compress = this.createBouncelet("audio.effect.spectrum.compress");
        BounceletBase noiseRemover = this.createBouncelet("audio.effect.spectrum.noise.filter");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", compress, "in");
        this.connect(compress, "out", noiseRemover, "in");
        this.connect(noiseRemover, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(wave2spectrum, "window", WindowType.Chebyshev100);
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "buffers", 4);
        this.setInput(compress, "factor", 0.0);
        this.commitAndPlay();
        this.sleep(200.0);
    }

    public void testRumple() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase rumple = this.createBouncelet("audio.effect.spectrum.rumple");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", rumple, "in");
        this.connect(rumple, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testTurbo() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase turbo = this.createBouncelet("audio.effect.spectrum.turbo");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", turbo, "in");
        this.connect(turbo, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p512);
        this.commitAndPlay();
        this.sleep(200.0);
    }

    public void testSmooth(double ratio) {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase smooth = this.createBouncelet("audio.effect.spectrum.smooth");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", smooth, "in");
        this.connect(smooth, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "blockSize", PowerOf2.p128);
        this.setInput(smooth, "ratio", ratio);
        this.commitAndPlay();
        this.sleep(200.0);
    }

    public void testRobotizer() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase k2000 = this.createBouncelet("audio.effect.spectrum.robotizer");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", k2000, "in");
        this.connect(k2000, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testShortExtract() {
        this.testBeatExtract("out.short");
    }

    public void testLongExtract() {
        this.testBeatExtract("out.long");
    }

    public void testBeatExtract(String portName) {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase beatx = this.createBouncelet("audio.effect.spectrum.time.beatx");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", beatx, "in");
        this.connect(beatx, portName, spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p512);
        this.setInput(audioConfig, "blockSize", PowerOf2.p128);
        this.commitAndPlay();
        this.sleep(500.0);
    }

    public void testShake() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase shake = this.createBouncelet("audio.effect.spectrum.shake");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", shake, "in");
        this.connect(shake, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testRandomPhase() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase rndPhase = this.createBouncelet("audio.effect.spectrum.randomphase");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", rndPhase, "in");
        this.connect(rndPhase, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testHelicopter() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase helicopter = this.createBouncelet("audio.effect.spectrum.helicopter");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", helicopter, "in");
        this.connect(helicopter, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.setInput(wave2spectrum, "overlap", PowerOf2.p2);
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p1024);
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testPinkFilter() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase filter = this.createBouncelet("audio.effect.spectrum.highfilter");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", filter, "in");
        this.connect(filter, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testWhisper() {
        this.testCrossSynthesis("audio.synth.wave.whitenoise");
    }

    public void testPlane() {
        this.testCrossSynthesis("audio.synth.wave.pluck");
    }

    public void testThunder() {
        this.testCrossSynthesis("audio.synth.wave.thunder");
    }

    private void testCrossSynthesis(String signalBounceletName) {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase wave2spectrumNoise = this.createBouncelet("audio.convert.format.wave2spectrum");
        BounceletBase getShape = this.createBouncelet("audio.analysis.spectralshape");
        BounceletBase signal = this.createBouncelet(signalBounceletName);
        BounceletBase toStereo = this.createBouncelet("audio.convert.channels.toMulti");
        BounceletBase shaper = this.createBouncelet("audio.effect.spectrum.filter.shaper");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.format.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", getShape, "in");
        this.connect(signal, "out", toStereo, "in");
        this.connect(toStereo, "out", wave2spectrumNoise, "in");
        this.connect(wave2spectrumNoise, "out", shaper, "in");
        this.connect(getShape, "shape", shaper, "shape");
        this.connect(shaper, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p256);
        this.setInput(wave2spectrum, "blockSize", PowerOf2.p2048);
        this.setInput(wave2spectrumNoise, "blockSize", PowerOf2.p2048);
        this.setInput(audioConfig, "buffers", 4);
        this.commitAndPlay();
        this.sleep(600.0);
    }

    public void testCompress() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase compress = this.createBouncelet("audio.effect.spectrum.compress");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", compress, "in");
        this.connect(compress, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(compress, "factor", 0.0);
        this.commitAndPlay();
        this.sleep(5.0);
        int i = 0;
        while (i < 80) {
            this.setInput(compress, "factor", Double.valueOf(i));
            System.out.println("Compressing: " + i);
            this.commit();
            this.sleep(0.4);
            ++i;
        }
        this.sleep(20.0);
    }

    public void testExpand() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase expand = this.createBouncelet("audio.effect.spectrum.expand");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", expand, "in");
        this.connect(expand, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(expand, "factor", 0.0);
        this.commitAndPlay();
        this.sleep(5.0);
        int i = 0;
        while (i < 80) {
            this.setInput(expand, "factor", Double.valueOf(i));
            System.out.println("Expanding: " + i);
            this.commit();
            this.sleep(0.4);
            ++i;
        }
        this.sleep(20.0);
    }

    public void testMonster() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase splitter = this.createBouncelet("audio.effect.spectrum.monster");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase highFilter = this.createBouncelet("audio.effect.highfilter");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", splitter, "in");
        this.connect(splitter, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", highFilter, "in");
        this.connect(highFilter, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p512);
        this.commitAndPlay();
        this.sleep(120.0);
    }

    public void testAmplitudeSplitter() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase autoGain = this.createBouncelet("audio.effect.autogain");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase splitter = this.createBouncelet("audio.effect.spectrum.ampsplit");
        BounceletBase spectrum2wave1 = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase spectrum2wave2 = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase gain1 = this.createBouncelet("audio.effect.gain");
        BounceletBase gain2 = this.createBouncelet("audio.effect.gain");
        BounceletBase mixer = this.createBouncelet("audio.flow.mixer");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", autoGain, "in");
        this.connect(autoGain, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", splitter, "in");
        this.connect(splitter, "loud", spectrum2wave1, "in");
        this.connect(splitter, "soft", spectrum2wave2, "in");
        this.connect(spectrum2wave1, "out", gain1, "in");
        this.connect(spectrum2wave2, "out", gain2, "in");
        this.connect(gain1, "out", mixer, "in1");
        this.connect(gain2, "out", mixer, "in2");
        this.connect(mixer, "out", audioOut, "in");
        this.setInput(mixer, "normalized", false);
        this.setInput(gain1, "gain", 0.5);
        this.setInput(gain2, "gain", 2.0);
        this.commitAndPlay();
        this.sleep(20.0);
    }

    public void testChord() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase chord = this.createBouncelet("audio.effect.spectrum.thor");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", chord, "in");
        this.connect(chord, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p128);
        this.commitAndPlay();
        this.sleep(200.0);
    }

    public void testDetune() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase wave2spectrum = this.createBouncelet("audio.convert.wave2spectrum");
        BounceletBase detune = this.createBouncelet("audio.effect.spectrum.detune");
        BounceletBase spectrum2wave = this.createBouncelet("audio.convert.spectrum2wave");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", wave2spectrum, "in");
        this.connect(wave2spectrum, "out", detune, "in");
        this.connect(detune, "out", spectrum2wave, "in");
        this.connect(spectrum2wave, "out", audioOut, "in");
        this.setInput(detune, "shift", 0.0);
        this.commitAndPlay();
        long sr = AudioConfig.getSampleRate();
        long time = this.server.getTime() + 4L * sr;
        int i = 1;
        while (i < 50) {
            this.setInput(detune, "shift", -44100.0 * (double)i / 16384.0);
            this.commit(time += sr);
            ++i;
        }
        time += sr;
        i = 0;
        while (i <= 10) {
            this.setInput(detune, "shift", -44100.0 * (double)(i * 20 + 50) / 16384.0);
            this.commit(time);
            time += 5L * sr;
            ++i;
        }
        this.sleep(115.0);
    }

    public void testPitchShiftLowLatency() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase block1 = this.createBouncelet("audio.convert.format.blocksize");
        BounceletBase split = this.createBouncelet("audio.convert.format.advanced.splitwindows");
        BounceletBase forwFFT = this.createBouncelet("audio.convert.format.advanced.ForwardFFT");
        BounceletBase pitchShift = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift");
        BounceletBase backFFT = this.createBouncelet("audio.convert.format.advanced.BackwardFFT");
        BounceletBase merge = this.createBouncelet("audio.convert.format.advanced.mergewindows");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(audioIn, "out", block1, "in");
        this.connect(block1, "out", split, "in");
        this.connect(split, "out", forwFFT, "in");
        this.connect(forwFFT, "out", pitchShift, "in");
        this.connect(pitchShift, "out", backFFT, "in");
        this.connect(backFFT, "out", merge, "in");
        this.connect(merge, "out", audioOut, "in");
        this.setInput(block1, "blockSize", PowerOf2.p128);
        this.setInput(split, "blockSize", PowerOf2.p512);
        this.setInput(pitchShift, "zeroPadding", PowerOf2.p8);
        this.setInput(audioConfig, "blockSize", PowerOf2.p64);
        this.setInput(audioConfig, "buffers", 2);
        this.setInput(split, "window", WindowType.Kaiser50);
        this.setInput(pitchShift, "ratio", 1.4);
        this.commitAndPlay();
        this.sleep(60.0);
    }

    public void testIsolation() {
        BounceletBase merge = this.createBouncelet("audio.convert.advanced.mergeWindows");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        this.connect(merge, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(5.0);
    }

    public void testSine() {
        BounceletBase sine = this.createBouncelet("audio.synth.wave.pluck");
        BounceletBase audioOut = this.createBouncelet("audio.line.out");
        BounceletBase lowPass = this.createBouncelet("audio.effect.highfilter");
        this.connect(sine, "out", lowPass, "in");
        this.connect(lowPass, "out", audioOut, "in");
        this.commitAndPlay();
        this.sleep(5.0);
        float freq = 220.0f;
        int i = 0;
        while (i < 100) {
            this.setInput(sine, "frequency", Float.valueOf(freq *= 1.01f));
            this.commit();
            this.sleep(0.05);
            ++i;
        }
        this.sleep(2.0);
        i = 0;
        while (i <= 100) {
            float skew = (float)((i + 50) % 100) / 100.0f;
            this.setInput(sine, "skew", Float.valueOf(skew));
            this.commit();
            this.sleep(0.05);
            ++i;
        }
        this.sleep(2.0);
    }

    public void testMidiNote2() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase square = this.createBouncelet("music.tone.square");
        BounceletBase gong4 = this.createBouncelet("music.effect.gongof4");
        BounceletBase chord = this.createBouncelet("music.effect.chord");
        BounceletBase cache = this.createBouncelet("music.effect.cache");
        BounceletBase enveloppe = this.createBouncelet("music.amplitude.enveloppe");
        BounceletBase instrument = this.createBouncelet("music.instrument");
        BounceletBase toMulti = this.createBouncelet("audio.convert.channels.toStereo");
        BounceletBase audioOut = this.createBouncelet("audio.line.audio-out");
        this.connect(square, "out", gong4, "in");
        this.connect(gong4, "out", chord, "in");
        this.connect(chord, "out", cache, "in");
        this.connect(cache, "out", instrument, "tone");
        this.connect(enveloppe, "out", instrument, "am");
        this.connect(instrument, "out", toMulti, "in");
        this.connect(toMulti, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p64);
        this.commitAndPlay();
        this.sleep(6.0);
        int k = 0;
        while (k < 4) {
            int[] notes = new int[]{64, 66, 68, 64, 68, 71, 76};
            int[] nArray = new int[5];
            nArray[1] = 2;
            nArray[2] = 4;
            nArray[3] = 5;
            nArray[4] = 7;
            int[] offsets = nArray;
            int i = 0;
            while (i < offsets.length) {
                int j = 0;
                while (j < notes.length) {
                    double duration = j == notes.length - 1 ? 1.2 : 0.3;
                    this.pressNote(instrument, notes[j] + offsets[i] - k * 12, duration);
                    ++j;
                }
                ++i;
            }
            this.sleep(1.2);
            ++k;
        }
        this.sleep(3.0);
    }

    public void testFM() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase signal = this.createBouncelet("music.tone.sine");
        BounceletBase modulator = this.createBouncelet("music.tone.sine");
        BounceletBase rate = this.createBouncelet("music.effect.frate");
        BounceletBase fm = this.createBouncelet("music.effect.fm");
        BounceletBase gong4 = this.createBouncelet("music.effect.gongof4");
        BounceletBase cache = this.createBouncelet("music.effect.cache");
        BounceletBase enveloppe = this.createBouncelet("music.amplitude.enveloppe");
        BounceletBase instrument = this.createBouncelet("music.instrument");
        BounceletBase toMulti = this.createBouncelet("audio.convert.channels.toStereo");
        BounceletBase audioOut = this.createBouncelet("audio.line.audio-out");
        this.connect(signal, "out", fm, "in1");
        this.connect(modulator, "out", rate, "in");
        this.connect(rate, "out", fm, "in2");
        this.setInput(rate, "num", 100);
        this.setInput(rate, "denom", 100);
        this.setInput(fm, "depth", 3.0);
        this.connect(fm, "out", gong4, "in");
        this.connect(gong4, "out", cache, "in");
        this.connect(cache, "out", instrument, "tone");
        this.connect(enveloppe, "out", instrument, "am");
        this.connect(instrument, "out", toMulti, "in");
        this.connect(toMulti, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p64);
        this.commitAndPlay();
        double when = 6.0;
        int k = 0;
        while (k < 4) {
            int[] notes = new int[]{64, 66, 68, 64, 68, 71, 76};
            int[] nArray = new int[5];
            nArray[1] = 2;
            nArray[2] = 4;
            nArray[3] = 5;
            nArray[4] = 7;
            int[] offsets = nArray;
            int i = 0;
            while (i < offsets.length) {
                int j = 0;
                while (j < notes.length) {
                    double duration = j == notes.length - 1 ? 1.2 : 0.3;
                    this.pressNote(instrument, notes[j] + offsets[i] - k * 12, duration, when);
                    when += duration;
                    ++j;
                }
                ++i;
            }
            when += 1.2;
            ++k;
        }
        this.sleep(when + 4.0);
    }

    public void testAM() {
        BounceletBase audioConfig = this.createBouncelet("audio.config");
        BounceletBase signal = this.createBouncelet("music.tone.sine");
        BounceletBase modulator = this.createBouncelet("music.tone.sine");
        BounceletBase rate = this.createBouncelet("music.effect.frate");
        BounceletBase amplify = this.createBouncelet("music.effect.amplify");
        BounceletBase am = this.createBouncelet("music.effect.am");
        BounceletBase gong4 = this.createBouncelet("music.effect.gongof4");
        BounceletBase cache = this.createBouncelet("music.effect.cache");
        BounceletBase enveloppe = this.createBouncelet("music.amplitude.enveloppe");
        BounceletBase instrument = this.createBouncelet("music.instrument");
        BounceletBase toMulti = this.createBouncelet("audio.convert.channels.toStereo");
        BounceletBase audioOut = this.createBouncelet("audio.line.audio-out");
        this.connect(signal, "out", am, "in1");
        this.connect(modulator, "out", rate, "in");
        this.connect(rate, "out", amplify, "in");
        this.connect(amplify, "out", am, "in2");
        this.setInput(rate, "num", 1);
        this.setInput(rate, "denom", 5);
        this.setInput(amplify, "offset", 0.2);
        this.setInput(amplify, "level", 0.8);
        this.connect(am, "out", gong4, "in");
        this.connect(am, "out", cache, "in");
        this.connect(cache, "out", instrument, "tone");
        this.connect(enveloppe, "out", instrument, "am");
        this.connect(instrument, "out", toMulti, "in");
        this.connect(toMulti, "out", audioOut, "in");
        this.setInput(audioConfig, "blockSize", PowerOf2.p64);
        this.commitAndPlay();
        double when = 6.0;
        int k = 0;
        while (k < 4) {
            int[] notes = new int[]{64, 66, 68, 64, 68, 71, 76};
            int[] nArray = new int[5];
            nArray[1] = 2;
            nArray[2] = 4;
            nArray[3] = 5;
            nArray[4] = 7;
            int[] offsets = nArray;
            int i = 0;
            while (i < offsets.length) {
                int j = 0;
                while (j < notes.length) {
                    double duration = j == notes.length - 1 ? 1.2 : 0.3;
                    this.pressNote(instrument, notes[j] + offsets[i] - k * 12, duration, when);
                    when += duration;
                    ++j;
                }
                ++i;
            }
            when += 1.2;
            ++k;
        }
        this.sleep(when + 4.0);
    }

    public void testMidiNote() {
        BounceletBase square0 = this.createBouncelet("audio.synth.wave.square");
        BounceletBase square1 = this.createBouncelet("audio.synth.wave.square");
        BounceletBase square2 = this.createBouncelet("audio.synth.wave.square");
        BounceletBase square3 = this.createBouncelet("audio.synth.wave.square");
        BounceletBase fshift0 = this.createBouncelet("signal.math.mul");
        BounceletBase fshift1 = this.createBouncelet("signal.math.mul");
        BounceletBase fshift2 = this.createBouncelet("signal.math.mul");
        BounceletBase fshift3 = this.createBouncelet("signal.math.mul");
        BounceletBase mixer = this.createBouncelet("audio.flow.mixer");
        BounceletBase lowPass = this.createBouncelet("audio.effect.wave.filter.highfilter");
        BounceletBase midi = this.createBouncelet("music.instrument");
        BounceletBase audioOut = this.createBouncelet("audio.line.audio-out");
        this.connect(square0, "out", mixer, "in0");
        this.connect(square1, "out", mixer, "in1");
        this.connect(square2, "out", mixer, "in2");
        this.connect(square3, "out", mixer, "in3");
        this.connect(mixer, "out", lowPass, "in");
        this.connect(lowPass, "out", midi, "in");
        this.connect(midi, "out", audioOut, "in");
        this.connect(midi, "note.frequency", fshift0, "v1");
        this.connect(midi, "note.frequency", fshift1, "v1");
        this.connect(midi, "note.frequency", fshift2, "v1");
        this.connect(midi, "note.frequency", fshift3, "v1");
        this.connect(fshift0, "result", square0, "frequency");
        this.connect(fshift1, "result", square1, "frequency");
        this.connect(fshift2, "result", square2, "frequency");
        this.connect(fshift3, "result", square3, "frequency");
        this.setInput(fshift0, "v2", Float.valueOf(1.0f));
        this.setInput(fshift1, "v2", Float.valueOf(1.006f));
        this.setInput(fshift2, "v2", Float.valueOf(1.01f));
        this.setInput(fshift3, "v2", Float.valueOf(1.014f));
        this.commitAndPlay();
        this.sleep(3.0);
        int k = 0;
        while (k < 4) {
            int[] notes = new int[]{64, 66, 68, 64, 68, 71, 76};
            int[] nArray = new int[5];
            nArray[1] = 2;
            nArray[2] = 4;
            nArray[3] = 5;
            nArray[4] = 7;
            int[] offsets = nArray;
            int i = 0;
            while (i < offsets.length) {
                int j = 0;
                while (j < notes.length) {
                    double duration = j == notes.length - 1 ? 1.2 : 0.3;
                    this.pressNote(midi, notes[j] + offsets[i] - k * 12, duration);
                    ++j;
                }
                ++i;
            }
            this.sleep(1.2);
            ++k;
        }
        this.sleep(3.0);
    }

    private void pressNote(BounceletBase midi, int note, double duration) {
        MidiEvent noteOn = new MidiEvent(MidiAction.NOTE_ON, 0, note, 80);
        this.setInput(midi, "midi", noteOn);
        this.commit();
        this.sleep(duration);
        MidiEvent noteOff = new MidiEvent(MidiAction.NOTE_OFF, 0, note, 80);
        this.setInput(midi, "midi", noteOff);
        this.commit();
    }

    private void pressNote(BounceletBase midi, int note, double duration, double when) {
        MidiEvent noteOn = new MidiEvent(MidiAction.NOTE_ON, 0, note, 80);
        this.setInput(midi, "midi", noteOn);
        this.commit((long)(when * (double)AudioConfig.getSampleRate()));
        MidiEvent noteOff = new MidiEvent(MidiAction.NOTE_OFF, 0, note, 80);
        this.setInput(midi, "midi", noteOff);
        this.commit((long)((when + duration) * (double)AudioConfig.getSampleRate()));
    }

    public void testBeatTracker() {
        BounceletBase audioIn = this.createBouncelet("audio.line.in");
        BounceletBase dcBlock = this.createBouncelet("audio.effect.dcblock");
        BounceletBase autoGain = this.createBouncelet("audio.effect.autogain");
        BounceletBase wave2freqs = this.createBouncelet("audio.convert.wave2frequencies");
        BounceletBase bandLevel = this.createBouncelet("audio.analysis.bandlevel");
        BounceletBase beatTrack = this.createBouncelet("audio.analysis.beat");
        BounceletBase bpmCalc = this.createBouncelet("audio.analysis.bpmcalc");
        this.connect(audioIn, "out", dcBlock, "in");
        this.connect(dcBlock, "out", autoGain, "in");
        this.connect(autoGain, "out", wave2freqs, "in");
        this.connect(wave2freqs, "out", bandLevel, "in");
        this.connect(bandLevel, "level", beatTrack, "level");
        this.connect(beatTrack, "clock", bpmCalc, "clock");
        this.setInput(wave2freqs, "blockSize", PowerOf2.p256);
        this.commitAndPlay();
        this.sleep(180.0);
    }

    protected void trash() {
        this.testFileReaderPitchshift();
        this.server.dispose();
    }

    protected void main() {
        this.testFM();
        this.server.dispose();
    }

    public static void main(String[] args) {
        DecklightTest test = new DecklightTest();
        test.main();
    }
}

