/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.test;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.Decklight;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateChangeListener;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P3Batch {
    private static final String BASE_DIR = "C:\\Documents and Settings\\juillern\\Desktop\\Audio\\Octave";
    private Decklight server;
    private Map<String, BounceletBase> bounceletTypes;

    private P3Batch() {
    }

    private void init() {
        this.server = new Decklight();
        this.bounceletTypes = this.server.getBounceletTypes();
    }

    private void flush() {
        this.server.dispose();
        this.server = null;
        this.bounceletTypes = null;
    }

    private BounceletBase createBouncelet(String name) {
        BounceletBase template = this.bounceletTypes.get(name);
        if (template == null) {
            throw new IllegalArgumentException("Unknown bouncelet: " + name);
        }
        try {
            BounceletBase result = (BounceletBase)template.getClass().newInstance();
            this.server.addBouncelet(result);
            return result;
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot instanciate " + name, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot access " + name, ex);
        }
    }

    private InputPort<?> getInputPort(BounceletBase b, String name) {
        for (InputPort<?> port : b.getInputPorts()) {
            if (!port.getName().equalsIgnoreCase(name)) continue;
            return port;
        }
        throw new IllegalArgumentException("Unknown input port name: " + b + ":" + name);
    }

    private OutputPort<?> getOutputPort(BounceletBase b, String name) {
        for (OutputPort<?> port : b.getOutputPorts()) {
            if (!port.getName().equalsIgnoreCase(name)) continue;
            return port;
        }
        throw new IllegalArgumentException("Unknown output port name: " + b + ":" + name);
    }

    private void connect(BounceletBase src, String outPortName, BounceletBase dst, String inPortName) {
        OutputPort<?> outputPort = this.getOutputPort(src, outPortName);
        InputPort<?> inputPort = this.getInputPort(dst, inPortName);
        this.server.addConnection(outputPort, inputPort);
    }

    private <E> void setInput(BounceletBase b, String inpPortName, E value) {
        InputPort<?> port = this.getInputPort(b, inpPortName);
        this.server.setInput(port, value);
    }

    private void commitAndPlay(long delay) {
        this.server.setPlayState(PlayState.PLAY, this.server.getTime() + delay, new Runnable(){

            public void run() {
                System.out.println("Now playing");
            }
        });
        this.server.commit(this.server.getTime() + delay);
    }

    private void sleep(double seconds) {
        try {
            Thread.sleep((long)(seconds * 1000.0));
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void processOctave(String inFile, String outFile, HqxMode mode) {
        this.init();
        try {
            BounceletBase fileReader = this.createBouncelet("audio.line.file.file-reader");
            BounceletBase wave2sharp = this.createBouncelet("audio.convert.format.wave2sharp");
            BounceletBase octave = this.createBouncelet("audio.effect.spectrum.pitch.pitchshift-octave");
            BounceletBase sharp2wave = this.createBouncelet("audio.convert.format.sharp2wave");
            BounceletBase fileWriter = this.createBouncelet("audio.line.file.file-writer");
            this.connect(fileReader, "out", wave2sharp, "in");
            this.connect(wave2sharp, "out", octave, "in");
            this.connect(octave, "out", sharp2wave, "in");
            this.connect(sharp2wave, "out", fileWriter, "in");
            this.setInput(wave2sharp, "mode", mode);
            File source = new File(BASE_DIR, inFile);
            if (!source.exists()) {
                System.err.println("Source file does not exist: " + source);
                return;
            }
            File target = new File(BASE_DIR, outFile);
            try {
                this.setInput(fileReader, "file", source.toURI().toURL());
                this.setInput(fileWriter, "file", target.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new InternalError();
            }
            final CountDownLatch barrier = new CountDownLatch(1);
            this.server.addPlayStateChangeListener(new PlayStateChangeListener(){

                public void playStateChanged(PlayState newState, long when) {
                    if (newState == PlayState.STOP) {
                        barrier.countDown();
                    }
                }
            });
            this.commitAndPlay(AudioConfig.getSampleRate());
            try {
                barrier.await();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.sleep(10.0);
        }
        finally {
            this.flush();
        }
    }

    public void process(String inFile, String outFile, double psRatio, double tsRatio) {
        this.init();
        try {
            BounceletBase fileReader = this.createBouncelet("audio.line.file.file-reader");
            BounceletBase pitchShift = this.createBouncelet("audio.effect.fourier.pitch.rainbow.pitchshift-rainbow");
            BounceletBase fileWriter = this.createBouncelet("audio.line.file.file-writer");
            this.connect(fileReader, "out", pitchShift, "in");
            this.connect(pitchShift, "out", fileWriter, "in");
            this.setInput(pitchShift, "ratio", psRatio);
            File source = new File(BASE_DIR, inFile);
            if (!source.exists()) {
                System.err.println("Source file does not exist: " + source);
                return;
            }
            File target = new File(BASE_DIR, outFile);
            try {
                this.setInput(fileReader, "file", source.toURI().toURL());
                this.setInput(fileWriter, "file", target.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new InternalError();
            }
            final CountDownLatch barrier = new CountDownLatch(1);
            this.server.addPlayStateChangeListener(new PlayStateChangeListener(){

                public void playStateChanged(PlayState newState, long when) {
                    if (newState == PlayState.STOP) {
                        barrier.countDown();
                    }
                }
            });
            this.commitAndPlay(AudioConfig.getSampleRate());
            try {
                barrier.await();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.sleep(10.0);
        }
        finally {
            this.flush();
        }
    }

    void test() {
        this.process("EminemR16.wav", "Eminem16.wav", 1.6, 1.6);
        this.process("DanseMacabreR16.wav", "DanseMacabre16.wav", 1.6, 1.6);
        this.process("ChariotsR16.wav", "Chariots16.wav", 1.6, 1.6);
        this.process("SkopsR16.wav", "Skops16.wav", 1.6, 1.6);
        this.process("QuieroContarteR16.wav", "QuieroContarte16.wav", 1.6, 1.6);
        this.process("ZoolookologieR16.wav", "Zoolookologie16.wav", 1.6, 1.6);
        this.process("EminemR2.wav", "EminemD.wav", 2.0, 2.0);
        this.process("DanseMacabreR2.wav", "DanseMacabreD.wav", 2.0, 2.0);
        this.process("ChariotsR2.wav", "ChariotsD.wav", 2.0, 2.0);
        this.process("SkopsR2.wav", "SkopsD.wav", 2.0, 2.0);
        this.process("QuieroContarteR2.wav", "QuieroContarteD.wav", 2.0, 2.0);
        this.process("ZoolookologieR2.wav", "ZoolookologieD.wav", 2.0, 2.0);
        this.process("Eminem.wav", "Eminem2.wav", 2.0, 1.0);
        this.process("DanseMacabre.wav", "DanseMacabre2.wav", 2.0, 1.0);
        this.process("Chariots.wav", "Chariots2.wav", 2.0, 1.0);
        this.process("Skops.wav", "Skops2.wav", 2.0, 1.0);
        this.process("QuieroContarte.wav", "QuieroContarte2.wav", 2.0, 1.0);
        this.process("Zoolookologie.wav", "Zoolookologie2.wav", 2.0, 1.0);
        this.process("EminemR324.wav", "Eminem324.wav", 3.24, 3.24);
        this.process("DanseMacabreR324.wav", "DanseMacabre324.wav", 3.24, 3.24);
        this.process("ChariotsR324.wav", "Chariots324.wav", 3.24, 3.24);
        this.process("SkopsR324.wav", "Skops324.wav", 3.24, 3.24);
        this.process("QuieroContarteR324.wav", "QuieroContarte324.wav", 3.24, 3.24);
        this.process("ZoolookologieR324.wav", "Zoolookologie324.wav", 3.24, 3.24);
        this.process("EminemR256.wav", "Eminem256.wav", 2.56, 2.56);
        this.process("DanseMacabreR256.wav", "DanseMacabre256.wav", 2.56, 2.56);
        this.process("ChariotsR256.wav", "Chariots256.wav", 2.56, 2.56);
        this.process("SkopsR256.wav", "Skops256.wav", 2.56, 2.56);
        this.process("QuieroContarteR256.wav", "QuieroContarte256.wav", 2.56, 2.56);
        this.process("ZoolookologieR256.wav", "Zoolookologie256.wav", 2.56, 2.56);
        this.process("Eminem.wav", "Eminem13.wav", 1.3, 1.0);
        this.process("DanseMacabre.wav", "DanseMacabre13.wav", 1.3, 1.0);
        this.process("Chariots.wav", "Chariots13.wav", 1.3, 1.0);
        this.process("Skops.wav", "Skops13.wav", 1.3, 1.0);
        this.process("QuieroContarte.wav", "QuieroContarte13.wav", 1.3, 1.0);
        this.process("Zoolookologie.wav", "Zoolookologie13.wav", 1.3, 1.0);
    }

    void autoTest() {
        File dir = new File(BASE_DIR);
        Object[] files = dir.listFiles();
        System.out.println(Arrays.toString(files));
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isFile() && ((File)file).getName().endsWith("R2.wav")) {
                String source = ((File)file).getName();
                String name = source.replace("R2.wav", ".wav");
                String target = name.replace(".wav", "Drb.wav");
                this.process(source, target, 2.0, 2.0);
                source = name.replace(".wav", "R105.wav");
                target = name.replace(".wav", "105.wav");
                this.process(source, target, 1.05, 1.05);
                source = name.replace(".wav", "R13.wav");
                target = name.replace(".wav", "13.wav");
                this.process(source, target, 1.3, 1.3);
                source = name.replace(".wav", ".mp3");
                target = name.replace(".wav", "07.wav");
                this.process(source, target, 0.7, 0.7);
                source = name.replace(".wav", ".mp3");
                target = name.replace(".wav", "2.wav");
                this.process(source, target, 2.0, 1.0);
                target = name.replace(".wav", "06.wav");
                this.process(source, target, 0.6, 1.0);
                target = name.replace(".wav", "14.wav");
                this.process(source, target, 1.414213, 1.0);
            }
            ++n2;
        }
    }

    void autoTestOctave() {
        File dir = new File(BASE_DIR);
        Object[] files = dir.listFiles();
        System.out.println(Arrays.toString(files));
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isFile() && ((File)file).getName().endsWith("R2.wav")) {
                String name = ((File)file).getName();
                String target = name.replace("R2.wav", "Do.wav");
                this.processOctave(name, target, HqxMode.DOUBLE_OCTAVE_TS);
                name = name.replace("R2.wav", ".mp3");
                target = name.replace(".mp3", "2o.wav");
                this.processOctave(name, target, HqxMode.DOUBLE_OCTAVE_PS);
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        Thread.currentThread().setPriority(2);
        P3Batch batch = new P3Batch();
        batch.autoTestOctave();
        System.out.println(Calendar.getInstance().getTime().toString());
    }
}

