/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.utils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.corebounce.utils.MemberInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo<T> {
    private final Map<String, MemberInfo> fields = new LinkedHashMap<String, MemberInfo>();

    public <M extends T> ClassInfo(Class<M> type) {
        Object[] objectArray = type.getFields();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = objectArray[n2];
            int mod = field.getModifiers();
            if (!(Modifier.isStatic(mod) || Modifier.isTransient(mod) || Modifier.isFinal(mod))) {
                MemberInfo member = new MemberInfo(field);
                this.fields.put(member.getName(), member);
            }
            ++n2;
        }
        try {
            objectArray = Introspector.getBeanInfo(type).getPropertyDescriptors();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object property = objectArray[n2];
                if (((PropertyDescriptor)property).getReadMethod() != null && ((PropertyDescriptor)property).getWriteMethod() != null) {
                    MemberInfo member = new MemberInfo((PropertyDescriptor)property);
                    this.fields.put(member.getName(), member);
                }
                ++n2;
            }
        }
        catch (IntrospectionException ex) {
            ex.printStackTrace();
        }
    }

    public Collection<MemberInfo> getMembers() {
        return this.fields.values();
    }
}

