/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.corebounce.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryLoader {
    private static Preferences prefs = Preferences.userNodeForPackage(LibraryLoader.class);
    private static Set<String> libFiles = new HashSet<String>();
    private static final Set<Pair<Class<?>, String>> loadedLibraries = new HashSet();

    public static synchronized void loadLibrary(Class<?> forClass, String libName) throws IOException {
        Pair key = new Pair(forClass, libName);
        if (loadedLibraries.contains(key)) {
            return;
        }
        loadedLibraries.add(key);
        libName = System.mapLibraryName(libName);
        InputStream input = null;
        OutputStream output = null;
        File tempFile = null;
        try {
            String suffix;
            String prefix;
            input = forClass.getResourceAsStream(libName);
            if (input == null) {
                throw new UnsatisfiedLinkError("Library not found for " + forClass + ": " + libName);
            }
            BufferedInputStream binput = new BufferedInputStream(input);
            int sepPos = libName.lastIndexOf(".");
            if (sepPos < 0) {
                prefix = libName;
                suffix = null;
            } else {
                prefix = libName.substring(0, sepPos);
                suffix = libName.substring(sepPos);
            }
            tempFile = File.createTempFile(prefix, suffix);
            LibraryLoader.cleanupAndAdd(tempFile.getAbsolutePath());
            output = new FileOutputStream(tempFile);
            BufferedOutputStream boutput = new BufferedOutputStream(output);
            byte[] data = new byte[32768];
            int read = binput.read(data);
            while (read > 0) {
                boutput.write(data, 0, read);
                read = binput.read(data);
            }
            boutput.flush();
            boutput.close();
            output = null;
            binput.close();
            input = null;
            System.load(tempFile.getAbsolutePath());
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
            if (tempFile != null && !tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }

    private static void cleanupAndAdd(String libFileName) {
        String[] fileArr;
        String oldFiles = prefs.get("Libraries", "");
        String[] stringArray = fileArr = oldFiles.split(Pattern.quote(File.pathSeparator));
        int n = fileArr.length;
        int n2 = 0;
        while (n2 < n) {
            String oldFile = stringArray[n2];
            if (!libFiles.contains(oldFile)) {
                new File(oldFile).delete();
            }
            ++n2;
        }
        libFiles.add(libFileName);
        StringBuilder newFiles = new StringBuilder();
        for (String file : libFiles) {
            if (newFiles.length() > 0) {
                newFiles.append(File.separator);
            }
            newFiles.append(file);
        }
        prefs.put("Libraries", newFiles.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }
}

