/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.utils;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import org.corebounce.utils.ShaolinMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaolinBag<E>
extends AbstractCollection<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1474197453676159677L;
    private final ShaolinExt<E> map;

    public ShaolinBag() {
        this.map = new ShaolinExt();
    }

    public ShaolinBag(Comparator<? super E> c) {
        this.map = new ShaolinExt<E>(c);
    }

    private ShaolinBag(ShaolinExt<E> map) {
        this.map = map;
    }

    @Override
    public Iterator<E> iterator() {
        return new ShaolinBagIterator(this.map.keySet().iterator());
    }

    @Override
    public int size() {
        return ((ShaolinExt)this.map).weight;
    }

    @Override
    public boolean add(E o) {
        Integer count = (Integer)this.map.get(o);
        if (count == null) {
            this.map.put(o, 1);
        } else {
            this.map.put(o, count + 1);
            this.map.updateSizes(o);
        }
        this.map.incrementWeight();
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.map.setWeight(0);
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public int indexOf(E element) {
        return this.map.indexOfKey(element);
    }

    public E get(int index) {
        return (E)this.map.getKey(index);
    }

    @Override
    public boolean remove(Object o) {
        Integer count = (Integer)this.map.get(o);
        if (count == null) {
            return false;
        }
        if (count == 1) {
            this.map.remove(o);
            this.map.decrementWeight();
            return true;
        }
        this.map.put(o, count - 1);
        this.map.updateSizes(o);
        this.map.decrementWeight();
        return true;
    }

    protected ShaolinBag<E> clone() {
        return new ShaolinBag<E>((ShaolinExt)this.map.clone());
    }

    public static void main(String[] args) {
        int xxx = 0;
        while (xxx < 1000) {
            int SIZE = 100;
            ShaolinBag<Integer> bag = new ShaolinBag<Integer>();
            Random rnd = new Random();
            int seed = rnd.nextInt();
            System.out.println("Seed: " + seed);
            rnd = new Random(seed);
            int i = 0;
            while (i < 100) {
                bag.add(rnd.nextInt(100));
                ++i;
            }
            Integer[] arr = new Integer[100];
            bag.toArray(arr);
            System.out.println("Result: " + bag);
            int index = bag.indexOf(50);
            System.out.println("Index of 50: " + index);
            assert (index < 0 || arr[index] == 50);
            int value = (Integer)bag.get(50);
            System.out.println("Item at 50: " + value);
            assert (arr[50] == value);
            int i2 = 0;
            while (i2 < 100) {
                bag.remove(rnd.nextInt(100));
                ++i2;
            }
            ++xxx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShaolinBagIterator
    implements Iterator<E> {
        private final Iterator<E> target;
        private E current = null;
        private int repeat = 0;

        public ShaolinBagIterator(Iterator<E> target) {
            this.target = target;
        }

        @Override
        public boolean hasNext() {
            if (this.repeat > 0) {
                return true;
            }
            return this.target.hasNext();
        }

        @Override
        public E next() {
            if (this.repeat > 0) {
                --this.repeat;
            } else {
                this.current = this.target.next();
                if (this.current != null) {
                    this.repeat = (Integer)ShaolinBag.this.map.get(this.current) - 1;
                }
            }
            return this.current;
        }

        @Override
        public void remove() {
            ShaolinBag.this.map.remove(this.current);
            ShaolinBag.this.map.decrementWeight();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShaolinExt<K>
    extends ShaolinMap<K, Integer> {
        private static final long serialVersionUID = 5285750948142783376L;
        private int weight;

        public ShaolinExt() {
        }

        public ShaolinExt(Comparator<? super K> c) {
            super(c);
        }

        void incrementWeight() {
            ++this.weight;
        }

        void decrementWeight() {
            --this.weight;
        }

        void setWeight(int weight) {
            this.weight = weight;
        }

        @Override
        protected int weight() {
            return this.weight;
        }

        @Override
        protected int entrySubSize(ShaolinMap.Entry<K, Integer> entry) {
            return entry.value == null ? 0 : (Integer)entry.value;
        }
    }
}

