/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.core;

import java.util.Iterator;
import java.util.Set;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;
import org.tritonus.core.TInit;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMidiConfig {
    private static Set<MidiDeviceProvider> sm_midiDeviceProviders = null;
    private static Set<MidiFileReader> sm_midiFileReaders = null;
    private static Set<MidiFileWriter> sm_midiFileWriters = null;
    private static Set<SoundbankReader> sm_soundbankReaders = null;
    private static MidiDevice.Info sm_defaultMidiInDeviceInfo = null;
    private static MidiDevice.Info sm_defaultMidiOutDeviceInfo = null;
    private static MidiDevice.Info sm_defaultSequencerInfo = null;
    private static MidiDevice.Info sm_defaultSynthesizerInfo = null;

    static {
        TMidiConfig.init();
    }

    private TMidiConfig() {
    }

    private static void init() {
        TMidiConfig.getMidiDeviceProvidersImpl();
        TMidiConfig.getMidiFileReadersImpl();
        TMidiConfig.getMidiFileWritersImpl();
        TMidiConfig.getSoundbankReadersImpl();
    }

    private static void registerMidiDeviceProviders() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)obj;
                TMidiConfig.addMidiDeviceProvider(midiDeviceProvider);
            }
        };
        TInit.registerClasses(MidiDeviceProvider.class, action);
    }

    private static void registerMidiFileReaders() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                MidiFileReader provider = (MidiFileReader)obj;
                TMidiConfig.addMidiFileReader(provider);
            }
        };
        TInit.registerClasses(MidiFileReader.class, action);
    }

    private static void registerMidiFileWriters() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                MidiFileWriter provider = (MidiFileWriter)obj;
                TMidiConfig.addMidiFileWriter(provider);
            }
        };
        TInit.registerClasses(MidiFileWriter.class, action);
    }

    private static void registerSoundbankReaders() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                SoundbankReader provider = (SoundbankReader)obj;
                TMidiConfig.addSoundbankReader(provider);
            }
        };
        TInit.registerClasses(SoundbankReader.class, action);
    }

    public static synchronized void addMidiDeviceProvider(MidiDeviceProvider provider) {
        TMidiConfig.getMidiDeviceProvidersImpl().add(provider);
        if (TMidiConfig.getDefaultMidiInDeviceInfo() == null || TMidiConfig.getDefaultMidiOutDeviceInfo() == null || TMidiConfig.getDefaultSynthesizerInfo() == null || TMidiConfig.getDefaultSequencerInfo() == null) {
            MidiDevice.Info[] infos = provider.getDeviceInfo();
            int i = 0;
            while (i < infos.length) {
                MidiDevice device;
                MidiDevice.Info info;
                block14: {
                    info = infos[i];
                    device = null;
                    try {
                        device = provider.getDevice(info);
                    }
                    catch (IllegalArgumentException e) {
                        if (!TDebug.TraceAllExceptions) break block14;
                        TDebug.out(e);
                    }
                }
                if (device instanceof Synthesizer) {
                    if (TMidiConfig.getDefaultSynthesizerInfo() == null) {
                        sm_defaultSynthesizerInfo = info;
                    }
                } else if (device instanceof Sequencer) {
                    if (TMidiConfig.getDefaultSequencerInfo() == null) {
                        sm_defaultSequencerInfo = info;
                    }
                } else if (device.getMaxTransmitters() != 0) {
                    if (TMidiConfig.getDefaultMidiInDeviceInfo() == null) {
                        sm_defaultMidiInDeviceInfo = info;
                    }
                } else if (device.getMaxReceivers() != 0 && TMidiConfig.getDefaultMidiOutDeviceInfo() == null) {
                    sm_defaultMidiOutDeviceInfo = info;
                }
                ++i;
            }
        }
    }

    public static synchronized void removeMidiDeviceProvider(MidiDeviceProvider provider) {
        TMidiConfig.getMidiDeviceProvidersImpl().remove(provider);
    }

    public static synchronized Iterator<MidiDeviceProvider> getMidiDeviceProviders() {
        return TMidiConfig.getMidiDeviceProvidersImpl().iterator();
    }

    private static synchronized Set<MidiDeviceProvider> getMidiDeviceProvidersImpl() {
        if (sm_midiDeviceProviders == null) {
            sm_midiDeviceProviders = new ArraySet<MidiDeviceProvider>();
            TMidiConfig.registerMidiDeviceProviders();
        }
        return sm_midiDeviceProviders;
    }

    public static synchronized void addMidiFileReader(MidiFileReader reader) {
        if (TDebug.TraceMidiConfig) {
            TDebug.out("TMidiConfig.addMidiFileReader(): adding " + reader);
        }
        TMidiConfig.getMidiFileReadersImpl().add(reader);
        if (TDebug.TraceMidiConfig) {
            TDebug.out("TMidiConfig.addMidiFileReader(): size " + sm_midiFileReaders.size());
        }
    }

    public static synchronized void removeMidiFileReader(MidiFileReader reader) {
        TMidiConfig.getMidiFileReadersImpl().remove(reader);
    }

    public static synchronized Iterator<MidiFileReader> getMidiFileReaders() {
        return TMidiConfig.getMidiFileReadersImpl().iterator();
    }

    private static synchronized Set<MidiFileReader> getMidiFileReadersImpl() {
        if (sm_midiFileReaders == null) {
            sm_midiFileReaders = new ArraySet<MidiFileReader>();
            TMidiConfig.registerMidiFileReaders();
        }
        return sm_midiFileReaders;
    }

    public static synchronized void addMidiFileWriter(MidiFileWriter reader) {
        TMidiConfig.getMidiFileWritersImpl().add(reader);
    }

    public static synchronized void removeMidiFileWriter(MidiFileWriter reader) {
        TMidiConfig.getMidiFileWritersImpl().remove(reader);
    }

    public static synchronized Iterator<MidiFileWriter> getMidiFileWriters() {
        return TMidiConfig.getMidiFileWritersImpl().iterator();
    }

    private static synchronized Set<MidiFileWriter> getMidiFileWritersImpl() {
        if (sm_midiFileWriters == null) {
            sm_midiFileWriters = new ArraySet<MidiFileWriter>();
            TMidiConfig.registerMidiFileWriters();
        }
        return sm_midiFileWriters;
    }

    public static synchronized void addSoundbankReader(SoundbankReader reader) {
        TMidiConfig.getSoundbankReadersImpl().add(reader);
    }

    public static synchronized void removeSoundbankReader(SoundbankReader reader) {
        TMidiConfig.getSoundbankReadersImpl().remove(reader);
    }

    public static synchronized Iterator<SoundbankReader> getSoundbankReaders() {
        return TMidiConfig.getSoundbankReadersImpl().iterator();
    }

    private static synchronized Set<SoundbankReader> getSoundbankReadersImpl() {
        if (sm_soundbankReaders == null) {
            sm_soundbankReaders = new ArraySet<SoundbankReader>();
            TMidiConfig.registerSoundbankReaders();
        }
        return sm_soundbankReaders;
    }

    public static MidiDevice.Info getDefaultMidiInDeviceInfo() {
        return sm_defaultMidiInDeviceInfo;
    }

    public static MidiDevice.Info getDefaultMidiOutDeviceInfo() {
        return sm_defaultMidiOutDeviceInfo;
    }

    public static MidiDevice.Info getDefaultSynthesizerInfo() {
        return sm_defaultSynthesizerInfo;
    }

    public static MidiDevice.Info getDefaultSequencerInfo() {
        return sm_defaultSequencerInfo;
    }
}

