/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Profile {
    UNKNOWN(-1, "unknown", false),
    AAC_MAIN(1, "AAC Main Profile", true),
    AAC_LC(2, "AAC Low Complexity", true),
    AAC_SSR(3, "AAC Scalable Sample Rate", false),
    AAC_LTP(4, "AAC Long Term Prediction", false),
    AAC_SBR(5, "AAC SBR", true),
    AAC_SCALABLE(6, "Scalable AAC", false),
    TWIN_VQ(7, "TwinVQ", false),
    AAC_LD(11, "AAC Low Delay", false),
    ER_AAC_LC(17, "Error Resilient AAC Low Complexity", true),
    ER_AAC_SSR(18, "Error Resilient AAC SSR", false),
    ER_AAC_LTP(19, "Error Resilient AAC Long Term Prediction", false),
    ER_AAC_SCALABLE(20, "Error Resilient Scalable AAC", false),
    ER_TWIN_VQ(21, "Error Resilient TwinVQ", false),
    ER_BSAC(22, "Error Resilient BSAC", false),
    ER_AAC_LD(23, "Error Resilient AAC Low Delay", false);

    private static final Profile[] ALL;
    private final int num;
    private final String descr;
    private final boolean supported;

    static {
        Profile[] profileArray = new Profile[23];
        profileArray[0] = AAC_MAIN;
        profileArray[1] = AAC_LC;
        profileArray[2] = AAC_SSR;
        profileArray[3] = AAC_LTP;
        profileArray[4] = AAC_SBR;
        profileArray[5] = AAC_SCALABLE;
        profileArray[6] = TWIN_VQ;
        profileArray[10] = AAC_LD;
        profileArray[16] = ER_AAC_LC;
        profileArray[17] = ER_AAC_SSR;
        profileArray[18] = ER_AAC_LTP;
        profileArray[19] = ER_AAC_SCALABLE;
        profileArray[20] = ER_TWIN_VQ;
        profileArray[21] = ER_BSAC;
        profileArray[22] = ER_AAC_LD;
        ALL = profileArray;
    }

    public static Profile forInt(int i) {
        Profile p = i <= 0 || i > ALL.length ? UNKNOWN : ALL[i - 1];
        return p;
    }

    private Profile(int num, String descr, boolean supported) {
        this.num = num;
        this.descr = descr;
        this.supported = supported;
    }

    public int getIndex() {
        return this.num;
    }

    public String getDescription() {
        return this.descr;
    }

    public String toString() {
        return this.descr;
    }

    public boolean isDecodingSupported() {
        return this.supported;
    }

    public boolean isErrorResilientProfile() {
        return this.num > 16;
    }
}

