/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.error;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.error.BitsBuffer;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.Constants;
import net.sourceforge.jaad.aac.syntax.ICSInfo;
import net.sourceforge.jaad.aac.syntax.ICStream;

public class HCR
implements Constants {
    private static final int NUM_CB = 6;
    private static final int NUM_CB_ER = 22;
    private static final int MAX_CB = 32;
    private static final int VCB11_FIRST = 16;
    private static final int VCB11_LAST = 31;
    private static final int[] PRE_SORT_CB_STD = new int[]{11, 9, 7, 5, 3, 1};
    private static final int[] PRE_SORT_CB_ER = new int[]{11, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 9, 7, 5, 3, 1};
    private static final int[] MAX_CW_LEN;
    private static final int[] S;
    private static final int[] B;

    static {
        int[] nArray = new int[32];
        nArray[1] = 11;
        nArray[2] = 9;
        nArray[3] = 20;
        nArray[4] = 16;
        nArray[5] = 13;
        nArray[6] = 11;
        nArray[7] = 14;
        nArray[8] = 12;
        nArray[9] = 17;
        nArray[10] = 14;
        nArray[11] = 49;
        nArray[16] = 14;
        nArray[17] = 17;
        nArray[18] = 21;
        nArray[19] = 21;
        nArray[20] = 25;
        nArray[21] = 25;
        nArray[22] = 29;
        nArray[23] = 29;
        nArray[24] = 29;
        nArray[25] = 29;
        nArray[26] = 33;
        nArray[27] = 33;
        nArray[28] = 33;
        nArray[29] = 37;
        nArray[30] = 37;
        nArray[31] = 41;
        MAX_CW_LEN = nArray;
        S = new int[]{1, 2, 4, 8, 16};
        B = new int[]{0x55555555, 0x33333333, 0xF0F0F0F, 0xFF00FF, 65535};
    }

    private static int rewindReverse(int v, int len) {
        v = v >> S[0] & B[0] | v << S[0] & ~B[0];
        v = v >> S[1] & B[1] | v << S[1] & ~B[1];
        v = v >> S[2] & B[2] | v << S[2] & ~B[2];
        v = v >> S[3] & B[3] | v << S[3] & ~B[3];
        v = v >> S[4] & B[4] | v << S[4] & ~B[4];
        return v >>= 32 - len;
    }

    static int[] rewindReverse64(int hi, int lo, int len) {
        int[] i = new int[2];
        if (len <= 32) {
            i[0] = 0;
            i[1] = HCR.rewindReverse(lo, len);
        } else {
            lo = lo >> S[0] & B[0] | lo << S[0] & ~B[0];
            hi = hi >> S[0] & B[0] | hi << S[0] & ~B[0];
            lo = lo >> S[1] & B[1] | lo << S[1] & ~B[1];
            hi = hi >> S[1] & B[1] | hi << S[1] & ~B[1];
            lo = lo >> S[2] & B[2] | lo << S[2] & ~B[2];
            hi = hi >> S[2] & B[2] | hi << S[2] & ~B[2];
            lo = lo >> S[3] & B[3] | lo << S[3] & ~B[3];
            hi = hi >> S[3] & B[3] | hi << S[3] & ~B[3];
            lo = lo >> S[4] & B[4] | lo << S[4] & ~B[4];
            hi = hi >> S[4] & B[4] | hi << S[4] & ~B[4];
            i[1] = hi >> 64 - len | lo << len - 32;
            i[1] = lo >> 64 - len;
        }
        return i;
    }

    private static boolean isGoodCB(int cb, int sectCB) {
        boolean b = false;
        if (sectCB > 0 && sectCB <= 11 || sectCB >= 16 && sectCB <= 31) {
            b = cb < 11 ? sectCB == cb || sectCB == cb + 1 : sectCB == cb;
        }
        return b;
    }

    /*
     * WARNING - void declaration
     */
    public static void decodeReorderedSpectralData(ICStream ics, BitStream in, short[] spectralData, boolean sectionDataResilience) throws AACException {
        int i;
        int lastCB;
        int[] preSortCB;
        ICSInfo info = ics.getInfo();
        int windowGroupCount = info.getWindowGroupCount();
        int maxSFB = info.getMaxSFB();
        int[] swbOffsets = info.getSWBOffsets();
        int swbOffsetMax = info.getSWBOffsetMax();
        Object sectStart = null;
        Object sectEnd = null;
        Object numSec = null;
        Object sectCB = null;
        Object sectSFBOffsets = null;
        int spDataLen = ics.getReorderedSpectralDataLength();
        if (spDataLen == 0) {
            return;
        }
        int longestLen = ics.getLongestCodewordLength();
        if (longestLen == 0 || longestLen >= spDataLen) {
            throw new AACException("length of longest HCR codeword out of range");
        }
        int[] spOffsets = new int[8];
        int shortFrameLen = spectralData.length / 8;
        spOffsets[0] = 0;
        int g = 1;
        while (g < windowGroupCount) {
            spOffsets[g] = spOffsets[g - 1] + shortFrameLen * info.getWindowGroupLength(g - 1);
            ++g;
        }
        Codeword[] codeword = new Codeword[512];
        BitsBuffer[] segment = new BitsBuffer[512];
        if (sectionDataResilience) {
            preSortCB = PRE_SORT_CB_ER;
            lastCB = 22;
        } else {
            preSortCB = PRE_SORT_CB_STD;
            lastCB = 6;
        }
        boolean PCWs_done = false;
        int segmentsCount = 0;
        int numberOfCodewords = 0;
        int bitsread = 0;
        int sortloop = 0;
        while (sortloop < lastCB) {
            int thisCB = preSortCB[sortloop];
            int sfb = 0;
            while (sfb < maxSFB) {
                int w_idx = 0;
                while (4 * w_idx < Math.min(swbOffsets[sfb + 1], swbOffsetMax) - swbOffsets[sfb]) {
                    g = 0;
                    while (g < windowGroupCount) {
                        i = 0;
                        while (i < numSec[g]) {
                            void thisSectCB;
                            if (sectStart[g][i] <= sfb && sectEnd[g][i] > sfb && HCR.isGoodCB(thisCB, (int)(thisSectCB = sectCB[g][i]))) {
                                void sect_sfb_size = sectSFBOffsets[g][sfb + 1] - sectSFBOffsets[g][sfb];
                                int inc = thisSectCB < 5 ? 4 : 2;
                                int group_cws_count = 4 * info.getWindowGroupLength(g) / inc;
                                int segwidth = Math.min(MAX_CW_LEN[thisSectCB], longestLen);
                                int cws = 0;
                                while (cws < group_cws_count && cws + w_idx * group_cws_count < sect_sfb_size) {
                                    int sp = spOffsets[g] + sectSFBOffsets[g][sfb] + inc * (cws + w_idx * group_cws_count);
                                    if (!PCWs_done) {
                                        if (bitsread + segwidth <= spDataLen) {
                                            segment[segmentsCount].readSegment(segwidth, in);
                                            bitsread += segwidth;
                                            segment[segmentsCount].rewindReverse();
                                            ++segmentsCount;
                                        } else {
                                            if (bitsread < spDataLen) {
                                                int additional_bits = spDataLen - bitsread;
                                                segment[segmentsCount].readSegment(additional_bits, in);
                                                segment[segmentsCount].len += segment[segmentsCount - 1].len;
                                                segment[segmentsCount].rewindReverse();
                                                if (segment[segmentsCount - 1].len > 32) {
                                                    segment[segmentsCount - 1].bufb = segment[segmentsCount].bufb + segment[segmentsCount - 1].showBits(segment[segmentsCount - 1].len - 32);
                                                    segment[segmentsCount - 1].bufa = segment[segmentsCount].bufa + segment[segmentsCount - 1].showBits(32);
                                                } else {
                                                    segment[segmentsCount - 1].bufa = segment[segmentsCount].bufa + segment[segmentsCount - 1].showBits(segment[segmentsCount - 1].len);
                                                    segment[segmentsCount - 1].bufb = segment[segmentsCount].bufb;
                                                }
                                                segment[segmentsCount - 1].len += additional_bits;
                                            }
                                            bitsread = spDataLen;
                                            PCWs_done = true;
                                            codeword[0].fill(sp, (int)thisSectCB);
                                        }
                                    } else {
                                        codeword[numberOfCodewords - segmentsCount].fill(sp, (int)thisSectCB);
                                    }
                                    ++numberOfCodewords;
                                    ++cws;
                                }
                            }
                            ++i;
                        }
                        ++g;
                    }
                    ++w_idx;
                }
                ++sfb;
            }
            ++sortloop;
        }
        if (segmentsCount == 0) {
            throw new AACException("no segments in HCR");
        }
        int numberOfSets = numberOfCodewords / segmentsCount;
        int set = 1;
        while (set <= numberOfSets) {
            int trial = 0;
            while (trial < segmentsCount) {
                int codewordBase = 0;
                while (codewordBase < segmentsCount) {
                    int segmentID = (trial + codewordBase) % segmentsCount;
                    int codewordID = codewordBase + set * segmentsCount - segmentsCount;
                    if (codewordID >= numberOfCodewords - segmentsCount) break;
                    if (codeword[codewordID].decoded == 0 && segment[segmentID].len > 0) {
                        if (codeword[codewordID].bits.len != 0) {
                            segment[segmentID].concatBits(codeword[codewordID].bits);
                        }
                        int n = segment[segmentID].len;
                    }
                    ++codewordBase;
                }
                ++trial;
            }
            i = 0;
            while (i < segmentsCount) {
                segment[i].rewindReverse();
                ++i;
            }
            ++set;
        }
    }

    private static class Codeword {
        int cb;
        int decoded;
        int sp_offset;
        BitsBuffer bits;

        private Codeword() {
        }

        private void fill(int sp, int cb) {
            this.sp_offset = sp;
            this.cb = cb;
            this.decoded = 0;
            this.bits = new BitsBuffer();
        }
    }
}

