/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.ps2;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.ps2.PSTables;
import net.sourceforge.jaad.aac.syntax.BitStream;

class PSHeader
implements PSTables {
    private boolean iidEnabled = false;
    private int iidMode = 0;
    private int iidPars = 0;
    private boolean iidQuant;
    private boolean iccEnabled = false;
    private int iccMode = 0;
    private int iccPars = 0;
    private boolean iccMixingB;
    private boolean ipdopdEnabled = false;
    private int ipdopdPars = 0;
    private boolean extEnabled = false;
    private boolean use34;
    private boolean use34Prev;

    PSHeader() {
    }

    void decode(BitStream in) throws AACException {
        this.iidEnabled = in.readBool();
        if (this.iidEnabled) {
            this.iidMode = in.readBits(3);
            this.iidPars = IID_PARS[this.iidMode % 3];
            this.iidQuant = this.iidMode > 2;
            this.ipdopdPars = IPD_OPD_PARS[this.iidMode % 3];
        } else {
            this.iidMode = 0;
            this.iidPars = 0;
            this.iidQuant = false;
            this.ipdopdPars = 0;
        }
        this.iccEnabled = in.readBool();
        if (this.iccEnabled) {
            this.iccMode = in.readBits(3);
            this.iccPars = IID_PARS[this.iccMode];
            this.iccMixingB = this.iccMode > 2;
        } else {
            this.iccMode = 1;
            this.iccPars = 1;
            this.iccMixingB = false;
        }
        this.extEnabled = in.readBool();
    }

    void startNewFrame() {
        if (this.iidEnabled || this.iccEnabled) {
            this.use34Prev = this.use34;
            this.use34 = this.iidEnabled && this.iidPars == 34 || this.iccEnabled && this.iccPars == 34;
        }
    }

    public boolean isIIDEnabled() {
        return this.iidEnabled;
    }

    public int getIIDMode() {
        return this.iidMode;
    }

    public int getIIDPars() {
        return this.iidPars;
    }

    public boolean useIIDQuantFine() {
        return this.iidQuant;
    }

    public boolean isIPDOPDEnabled() {
        return this.ipdopdEnabled;
    }

    void setIPDOPDEnabled(boolean enabled) {
        this.ipdopdEnabled = enabled;
    }

    public int getIPDOPDPars() {
        return this.ipdopdPars;
    }

    public boolean isICCEnabled() {
        return this.iccEnabled;
    }

    public int getICCMode() {
        return this.iccMode;
    }

    public int getICCPars() {
        return this.iccPars;
    }

    public boolean useICCMixingB() {
        return this.iccMixingB;
    }

    public boolean isExtEnabled() {
        return this.extEnabled;
    }

    public boolean use34Bands(boolean previous) {
        return previous ? this.use34Prev : this.use34;
    }

    public int getBandMode() {
        return this.use34 ? 1 : 0;
    }
}

