/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import net.sourceforge.jaad.aac.sbr.FilterbankTables;

class Filterbank
implements FilterbankTables {
    private static final int FFT_LENGTH = 32;
    private final float[] tmp = new float[2];

    Filterbank() {
    }

    void computeDCT4Kernel(float[][] in, float[][] out) {
        int iRev;
        float f;
        int i = 0;
        while (i < 32) {
            this.tmp[0] = in[i][0];
            this.tmp[1] = in[i][1];
            f = (this.tmp[0] + this.tmp[1]) * DCT4_64_TABLE[i];
            in[i][0] = this.tmp[1] * DCT4_64_TABLE[i + 64] + f;
            in[i][1] = this.tmp[0] * DCT4_64_TABLE[i + 32] + f;
            ++i;
        }
        this.computeFFT(in);
        i = 0;
        while (i < 16) {
            iRev = BIT_REVERSE_TABLE[i];
            this.tmp[0] = in[iRev][0];
            this.tmp[1] = in[iRev][1];
            f = (this.tmp[0] + this.tmp[1]) * DCT4_64_TABLE[i + 96];
            out[i][0] = this.tmp[1] * DCT4_64_TABLE[i + 160] + f;
            out[i][1] = this.tmp[0] * DCT4_64_TABLE[i + 128] + f;
            ++i;
        }
        out[16][1] = (in[1][1] - in[1][0]) * DCT4_64_TABLE[112];
        out[16][0] = (in[1][0] + in[1][1]) * DCT4_64_TABLE[112];
        i = 17;
        while (i < 32) {
            iRev = BIT_REVERSE_TABLE[i];
            this.tmp[0] = in[iRev][0];
            this.tmp[1] = in[iRev][1];
            f = (this.tmp[0] + this.tmp[1]) * DCT4_64_TABLE[i + 96];
            out[i][0] = this.tmp[1] * DCT4_64_TABLE[i + 160] + f;
            out[i][1] = this.tmp[0] * DCT4_64_TABLE[i + 128] + f;
            ++i;
        }
    }

    private void computeFFT(float[][] in) {
        float im2;
        float re2;
        int z;
        float im1;
        float re1;
        int i = 0;
        while (i < 16) {
            re1 = in[i][0];
            im1 = in[i][1];
            z = i + 16;
            re2 = in[z][0];
            im2 = in[z][1];
            this.tmp[0] = FFT_TABLE[i][0];
            this.tmp[1] = FFT_TABLE[i][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray2 = in[i];
            fArray2[1] = fArray2[1] + im2;
            in[z][0] = (re1 -= re2) * this.tmp[0] - (im1 -= im2) * this.tmp[1];
            in[z][1] = re1 * this.tmp[1] + im1 * this.tmp[0];
            ++i;
        }
        int index = 0;
        int j = 0;
        while (j < 8) {
            this.tmp[0] = FFT_TABLE[index][0];
            this.tmp[1] = FFT_TABLE[index][1];
            index += 2;
            i = j;
            re1 = in[i][0];
            im1 = in[i][1];
            z = i + 8;
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray3 = in[i];
            fArray3[1] = fArray3[1] + im2;
            in[z][0] = (re1 -= re2) * this.tmp[0] - (im1 -= im2) * this.tmp[1];
            in[z][1] = re1 * this.tmp[1] + im1 * this.tmp[0];
            i = j + 16;
            re1 = in[i][0];
            im1 = in[i][1];
            z = i + 8;
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray4 = in[i];
            fArray4[0] = fArray4[0] + re2;
            float[] fArray5 = in[i];
            fArray5[1] = fArray5[1] + im2;
            in[z][0] = (re1 -= re2) * this.tmp[0] - (im1 -= im2) * this.tmp[1];
            in[z][1] = re1 * this.tmp[1] + im1 * this.tmp[0];
            ++j;
        }
        i = 0;
        while (i < 32) {
            z = i + 4;
            re1 = in[i][0];
            im1 = in[i][1];
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray6 = in[i];
            fArray6[1] = fArray6[1] + im2;
            in[z][0] = re1 - re2;
            in[z][1] = im1 - im2;
            i += 8;
        }
        this.tmp[0] = FFT_TABLE[4][0];
        i = 1;
        while (i < 32) {
            z = i + 4;
            re1 = in[i][0];
            im1 = in[i][1];
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray7 = in[i];
            fArray7[1] = fArray7[1] + im2;
            in[z][0] = ((re1 -= re2) + (im1 -= im2)) * this.tmp[0];
            in[z][1] = (im1 - re1) * this.tmp[0];
            i += 8;
        }
        i = 2;
        while (i < 32) {
            z = i + 4;
            re1 = in[i][0];
            im1 = in[i][1];
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray8 = in[i];
            fArray8[1] = fArray8[1] + im2;
            in[z][0] = im1 - im2;
            in[z][1] = re2 - re1;
            i += 8;
        }
        this.tmp[0] = FFT_TABLE[12][0];
        i = 3;
        while (i < 32) {
            z = i + 4;
            re1 = in[i][0];
            im1 = in[i][1];
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray9 = in[i];
            fArray9[1] = fArray9[1] + im2;
            in[z][0] = ((re1 -= re2) - (im1 -= im2)) * this.tmp[0];
            in[z][1] = (re1 + im1) * this.tmp[0];
            i += 8;
        }
        i = 0;
        while (i < 32) {
            z = i + 2;
            re1 = in[i][0];
            im1 = in[i][1];
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray10 = in[i];
            fArray10[1] = fArray10[1] + im2;
            in[z][0] = re1 - re2;
            in[z][1] = im1 - im2;
            i += 4;
        }
        i = 1;
        while (i < 32) {
            z = i + 2;
            re1 = in[i][0];
            im1 = in[i][1];
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray11 = in[i];
            fArray11[1] = fArray11[1] + im2;
            in[z][0] = im1 - im2;
            in[z][1] = re2 - re1;
            i += 4;
        }
        i = 0;
        while (i < 32) {
            z = i + 1;
            re1 = in[i][0];
            im1 = in[i][1];
            re2 = in[z][0];
            im2 = in[z][1];
            float[] fArray = in[i];
            fArray[0] = fArray[0] + re2;
            float[] fArray12 = in[i];
            fArray12[1] = fArray12[1] + im2;
            in[z][0] = re1 - re2;
            in[z][1] = im1 - im2;
            i += 2;
        }
    }
}

