/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import net.sourceforge.jaad.aac.sbr.Filterbank;
import net.sourceforge.jaad.aac.sbr.FilterbankTables;

class QMFSynthesis
implements FilterbankTables {
    private static final float SCALE = 0.015625f;
    private final Filterbank filterBank;
    private final float[] v;
    private final float[][] x;
    private final float[][] tmpIn1;
    private final float[][] tmpOut1;
    private final float[][] tmpIn2;
    private final float[][] tmpOut2;
    private int vIndex;
    private final float[] buf;

    QMFSynthesis(Filterbank filterBank, int channels) {
        this.filterBank = filterBank;
        this.v = new float[40 * channels];
        this.x = new float[2][32];
        this.tmpIn1 = new float[32][2];
        this.tmpOut1 = new float[32][2];
        this.tmpIn2 = new float[32][2];
        this.tmpOut2 = new float[32][2];
        this.vIndex = 0;
        this.buf = new float[398];
    }

    void performSynthesis32(float[][][] in, float[] out, int len) {
        int off = 0;
        int l = 0;
        while (l < len) {
            int k = 0;
            while (k < 32) {
                this.x[0][k] = in[l][k][0] * QMF32_PRE_TWIDDLE[k][0] - in[l][k][1] * QMF32_PRE_TWIDDLE[k][1];
                this.x[1][k] = in[l][k][1] * QMF32_PRE_TWIDDLE[k][0] + in[l][k][0] * QMF32_PRE_TWIDDLE[k][1];
                float[] fArray = this.x[0];
                int n = k;
                fArray[n] = fArray[n] * 0.015625f;
                float[] fArray2 = this.x[1];
                int n2 = k++;
                fArray2[n2] = fArray2[n2] * 0.015625f;
            }
            this.computeDCT(this.x[0]);
            this.computeDST(this.x[1]);
            int n = 0;
            while (n < 32) {
                float d;
                this.v[this.vIndex + n] = d = -this.x[0][n] + this.x[1][n];
                this.v[this.vIndex + 640 + n] = d;
                this.v[this.vIndex + 63 - n] = d = this.x[0][n] + this.x[1][n];
                this.v[this.vIndex + 640 + 63 - n] = d;
                ++n;
            }
            k = 0;
            while (k < 32) {
                out[off++] = this.v[this.vIndex + k] * QMF_C[2 * k] + this.v[this.vIndex + 96 + k] * QMF_C[64 + 2 * k] + this.v[this.vIndex + 128 + k] * QMF_C[128 + 2 * k] + this.v[this.vIndex + 224 + k] * QMF_C[192 + 2 * k] + this.v[this.vIndex + 256 + k] * QMF_C[256 + 2 * k] + this.v[this.vIndex + 352 + k] * QMF_C[320 + 2 * k] + this.v[this.vIndex + 384 + k] * QMF_C[384 + 2 * k] + this.v[this.vIndex + 480 + k] * QMF_C[448 + 2 * k] + this.v[this.vIndex + 512 + k] * QMF_C[512 + 2 * k] + this.v[this.vIndex + 608 + k] * QMF_C[576 + 2 * k];
                ++k;
            }
            this.vIndex -= 64;
            if (this.vIndex < 0) {
                this.vIndex = 576;
            }
            ++l;
        }
    }

    void performSynthesis64(float[][][] in, float[] out, int len) {
        int off = 0;
        int l = 0;
        while (l < len) {
            float[][] pX = in[l];
            this.tmpIn1[31][1] = 0.015625f * pX[1][0];
            this.tmpIn1[0][0] = 0.015625f * pX[0][0];
            this.tmpIn2[31][1] = 0.015625f * pX[62][1];
            this.tmpIn2[0][0] = 0.015625f * pX[63][1];
            int k = 1;
            while (k < 31) {
                this.tmpIn1[31 - k][1] = 0.015625f * pX[2 * k + 1][0];
                this.tmpIn1[k][0] = 0.015625f * pX[2 * k][0];
                this.tmpIn2[31 - k][1] = 0.015625f * pX[63 - (2 * k + 1)][1];
                this.tmpIn2[k][0] = 0.015625f * pX[63 - 2 * k][1];
                ++k;
            }
            this.tmpIn1[0][1] = 0.015625f * pX[63][0];
            this.tmpIn1[31][0] = 0.015625f * pX[62][0];
            this.tmpIn2[0][1] = 0.015625f * pX[0][1];
            this.tmpIn2[31][0] = 0.015625f * pX[1][1];
            this.filterBank.computeDCT4Kernel(this.tmpIn1, this.tmpOut1);
            this.filterBank.computeDCT4Kernel(this.tmpIn2, this.tmpOut2);
            int buf1 = this.vIndex;
            int buf2 = this.vIndex + 1280;
            int n = 0;
            while (n < 32) {
                float f = this.tmpOut2[n][0] - this.tmpOut1[n][0];
                this.v[buf2 + 2 * n] = f;
                this.v[buf1 + 2 * n] = f;
                float f2 = this.tmpOut2[n][0] + this.tmpOut1[n][0];
                this.v[buf2 + 127 - 2 * n] = f2;
                this.v[buf1 + 127 - 2 * n] = f2;
                float f3 = this.tmpOut2[31 - n][1] + this.tmpOut1[31 - n][1];
                this.v[buf2 + 2 * n + 1] = f3;
                this.v[buf1 + 2 * n + 1] = f3;
                float f4 = this.tmpOut2[31 - n][1] - this.tmpOut1[31 - n][1];
                this.v[buf2 + 127 - (2 * n + 1)] = f4;
                this.v[buf1 + 127 - (2 * n + 1)] = f4;
                ++n;
            }
            buf1 = this.vIndex;
            k = 0;
            while (k < 64) {
                out[off++] = this.v[buf1 + k + 0] * QMF_C[k + 0] + this.v[buf1 + k + 192] * QMF_C[k + 64] + this.v[buf1 + k + 256] * QMF_C[k + 128] + this.v[buf1 + k + 448] * QMF_C[k + 192] + this.v[buf1 + k + 512] * QMF_C[k + 256] + this.v[buf1 + k + 704] * QMF_C[k + 320] + this.v[buf1 + k + 768] * QMF_C[k + 384] + this.v[buf1 + k + 960] * QMF_C[k + 448] + this.v[buf1 + k + 1024] * QMF_C[k + 512] + this.v[buf1 + k + 1216] * QMF_C[k + 576];
                ++k;
            }
            this.vIndex -= 128;
            if (this.vIndex < 0) {
                this.vIndex = 1152;
            }
            ++l;
        }
    }

    private void computeDCT(float[] in) {
        this.buf[0] = in[15] - in[16];
        this.buf[1] = in[15] + in[16];
        this.buf[2] = DCT_TABLE[0] * this.buf[1];
        this.buf[3] = DCT_TABLE[1] * this.buf[0];
        this.buf[4] = in[8] - in[23];
        this.buf[5] = in[8] + in[23];
        this.buf[6] = DCT_TABLE[2] * this.buf[5];
        this.buf[7] = DCT_TABLE[3] * this.buf[4];
        this.buf[8] = in[12] - in[19];
        this.buf[9] = in[12] + in[19];
        this.buf[10] = DCT_TABLE[4] * this.buf[9];
        this.buf[11] = DCT_TABLE[5] * this.buf[8];
        this.buf[12] = in[11] - in[20];
        this.buf[13] = in[11] + in[20];
        this.buf[14] = DCT_TABLE[6] * this.buf[13];
        this.buf[15] = DCT_TABLE[7] * this.buf[12];
        this.buf[16] = in[14] - in[17];
        this.buf[17] = in[14] + in[17];
        this.buf[18] = DCT_TABLE[8] * this.buf[17];
        this.buf[19] = DCT_TABLE[9] * this.buf[16];
        this.buf[20] = in[9] - in[22];
        this.buf[21] = in[9] + in[22];
        this.buf[22] = DCT_TABLE[10] * this.buf[21];
        this.buf[23] = DCT_TABLE[11] * this.buf[20];
        this.buf[24] = in[13] - in[18];
        this.buf[25] = in[13] + in[18];
        this.buf[26] = DCT_TABLE[12] * this.buf[25];
        this.buf[27] = DCT_TABLE[13] * this.buf[24];
        this.buf[28] = in[10] - in[21];
        this.buf[29] = in[10] + in[21];
        this.buf[30] = DCT_TABLE[14] * this.buf[29];
        this.buf[31] = DCT_TABLE[15] * this.buf[28];
        this.buf[32] = in[0] - this.buf[2];
        this.buf[33] = in[0] + this.buf[2];
        this.buf[34] = in[31] - this.buf[3];
        this.buf[35] = in[31] + this.buf[3];
        this.buf[36] = in[7] - this.buf[6];
        this.buf[37] = in[7] + this.buf[6];
        this.buf[38] = in[24] - this.buf[7];
        this.buf[39] = in[24] + this.buf[7];
        this.buf[40] = in[3] - this.buf[10];
        this.buf[41] = in[3] + this.buf[10];
        this.buf[42] = in[28] - this.buf[11];
        this.buf[43] = in[28] + this.buf[11];
        this.buf[44] = in[4] - this.buf[14];
        this.buf[45] = in[4] + this.buf[14];
        this.buf[46] = in[27] - this.buf[15];
        this.buf[47] = in[27] + this.buf[15];
        this.buf[48] = in[1] - this.buf[18];
        this.buf[49] = in[1] + this.buf[18];
        this.buf[50] = in[30] - this.buf[19];
        this.buf[51] = in[30] + this.buf[19];
        this.buf[52] = in[6] - this.buf[22];
        this.buf[53] = in[6] + this.buf[22];
        this.buf[54] = in[25] - this.buf[23];
        this.buf[55] = in[25] + this.buf[23];
        this.buf[56] = in[2] - this.buf[26];
        this.buf[57] = in[2] + this.buf[26];
        this.buf[58] = in[29] - this.buf[27];
        this.buf[59] = in[29] + this.buf[27];
        this.buf[60] = in[5] - this.buf[30];
        this.buf[61] = in[5] + this.buf[30];
        this.buf[62] = in[26] - this.buf[31];
        this.buf[63] = in[26] + this.buf[31];
        this.buf[64] = this.buf[39] + this.buf[37];
        this.buf[65] = DCT_TABLE[16] * this.buf[39];
        this.buf[66] = DCT_TABLE[17] * this.buf[64];
        this.buf[67] = DCT_TABLE[18] * this.buf[37];
        this.buf[68] = this.buf[65] + this.buf[66];
        this.buf[69] = this.buf[67] - this.buf[66];
        this.buf[70] = this.buf[38] + this.buf[36];
        this.buf[71] = DCT_TABLE[19] * this.buf[38];
        this.buf[72] = DCT_TABLE[20] * this.buf[70];
        this.buf[73] = DCT_TABLE[21] * this.buf[36];
        this.buf[74] = this.buf[71] + this.buf[72];
        this.buf[75] = this.buf[73] - this.buf[72];
        this.buf[76] = this.buf[47] + this.buf[45];
        this.buf[77] = DCT_TABLE[22] * this.buf[47];
        this.buf[78] = DCT_TABLE[23] * this.buf[76];
        this.buf[79] = DCT_TABLE[24] * this.buf[45];
        this.buf[80] = this.buf[77] + this.buf[78];
        this.buf[81] = this.buf[79] - this.buf[78];
        this.buf[82] = this.buf[46] + this.buf[44];
        this.buf[83] = DCT_TABLE[25] * this.buf[46];
        this.buf[84] = DCT_TABLE[26] * this.buf[82];
        this.buf[85] = DCT_TABLE[27] * this.buf[44];
        this.buf[86] = this.buf[83] + this.buf[84];
        this.buf[87] = this.buf[85] - this.buf[84];
        this.buf[88] = this.buf[55] + this.buf[53];
        this.buf[89] = DCT_TABLE[28] * this.buf[55];
        this.buf[90] = DCT_TABLE[29] * this.buf[88];
        this.buf[91] = DCT_TABLE[30] * this.buf[53];
        this.buf[92] = this.buf[89] + this.buf[90];
        this.buf[93] = this.buf[91] - this.buf[90];
        this.buf[94] = this.buf[54] + this.buf[52];
        this.buf[95] = DCT_TABLE[31] * this.buf[54];
        this.buf[96] = DCT_TABLE[32] * this.buf[94];
        this.buf[97] = DCT_TABLE[33] * this.buf[52];
        this.buf[98] = this.buf[95] + this.buf[96];
        this.buf[99] = this.buf[97] - this.buf[96];
        this.buf[100] = this.buf[63] + this.buf[61];
        this.buf[101] = DCT_TABLE[34] * this.buf[63];
        this.buf[102] = DCT_TABLE[35] * this.buf[100];
        this.buf[103] = DCT_TABLE[36] * this.buf[61];
        this.buf[104] = this.buf[101] + this.buf[102];
        this.buf[105] = this.buf[103] - this.buf[102];
        this.buf[106] = this.buf[62] + this.buf[60];
        this.buf[107] = DCT_TABLE[37] * this.buf[62];
        this.buf[108] = DCT_TABLE[38] * this.buf[106];
        this.buf[109] = DCT_TABLE[39] * this.buf[60];
        this.buf[110] = this.buf[107] + this.buf[108];
        this.buf[111] = this.buf[109] - this.buf[108];
        this.buf[112] = this.buf[33] - this.buf[68];
        this.buf[113] = this.buf[33] + this.buf[68];
        this.buf[114] = this.buf[35] - this.buf[69];
        this.buf[115] = this.buf[35] + this.buf[69];
        this.buf[116] = this.buf[32] - this.buf[74];
        this.buf[117] = this.buf[32] + this.buf[74];
        this.buf[118] = this.buf[34] - this.buf[75];
        this.buf[119] = this.buf[34] + this.buf[75];
        this.buf[120] = this.buf[41] - this.buf[80];
        this.buf[121] = this.buf[41] + this.buf[80];
        this.buf[122] = this.buf[43] - this.buf[81];
        this.buf[123] = this.buf[43] + this.buf[81];
        this.buf[124] = this.buf[40] - this.buf[86];
        this.buf[125] = this.buf[40] + this.buf[86];
        this.buf[126] = this.buf[42] - this.buf[87];
        this.buf[127] = this.buf[42] + this.buf[87];
        this.buf[128] = this.buf[49] - this.buf[92];
        this.buf[129] = this.buf[49] + this.buf[92];
        this.buf[130] = this.buf[51] - this.buf[93];
        this.buf[131] = this.buf[51] + this.buf[93];
        this.buf[132] = this.buf[48] - this.buf[98];
        this.buf[133] = this.buf[48] + this.buf[98];
        this.buf[134] = this.buf[50] - this.buf[99];
        this.buf[135] = this.buf[50] + this.buf[99];
        this.buf[136] = this.buf[57] - this.buf[104];
        this.buf[137] = this.buf[57] + this.buf[104];
        this.buf[138] = this.buf[59] - this.buf[105];
        this.buf[139] = this.buf[59] + this.buf[105];
        this.buf[140] = this.buf[56] - this.buf[110];
        this.buf[141] = this.buf[56] + this.buf[110];
        this.buf[142] = this.buf[58] - this.buf[111];
        this.buf[143] = this.buf[58] + this.buf[111];
        this.buf[144] = this.buf[123] + this.buf[121];
        this.buf[145] = DCT_TABLE[40] * this.buf[123];
        this.buf[146] = DCT_TABLE[41] * this.buf[144];
        this.buf[147] = DCT_TABLE[42] * this.buf[121];
        this.buf[148] = this.buf[145] + this.buf[146];
        this.buf[149] = this.buf[147] - this.buf[146];
        this.buf[150] = this.buf[127] + this.buf[125];
        this.buf[151] = DCT_TABLE[43] * this.buf[127];
        this.buf[152] = DCT_TABLE[44] * this.buf[150];
        this.buf[153] = DCT_TABLE[45] * this.buf[125];
        this.buf[154] = this.buf[151] + this.buf[152];
        this.buf[155] = this.buf[153] - this.buf[152];
        this.buf[156] = this.buf[122] + this.buf[120];
        this.buf[157] = DCT_TABLE[46] * this.buf[122];
        this.buf[158] = DCT_TABLE[47] * this.buf[156];
        this.buf[159] = DCT_TABLE[48] * this.buf[120];
        this.buf[160] = this.buf[157] + this.buf[158];
        this.buf[161] = this.buf[159] - this.buf[158];
        this.buf[162] = this.buf[126] + this.buf[124];
        this.buf[163] = DCT_TABLE[49] * this.buf[126];
        this.buf[164] = DCT_TABLE[50] * this.buf[162];
        this.buf[165] = DCT_TABLE[51] * this.buf[124];
        this.buf[166] = this.buf[163] + this.buf[164];
        this.buf[167] = this.buf[165] - this.buf[164];
        this.buf[168] = this.buf[139] + this.buf[137];
        this.buf[169] = DCT_TABLE[52] * this.buf[139];
        this.buf[170] = DCT_TABLE[53] * this.buf[168];
        this.buf[171] = DCT_TABLE[54] * this.buf[137];
        this.buf[172] = this.buf[169] + this.buf[170];
        this.buf[173] = this.buf[171] - this.buf[170];
        this.buf[174] = this.buf[143] + this.buf[141];
        this.buf[175] = DCT_TABLE[55] * this.buf[143];
        this.buf[176] = DCT_TABLE[56] * this.buf[174];
        this.buf[177] = DCT_TABLE[57] * this.buf[141];
        this.buf[178] = this.buf[175] + this.buf[176];
        this.buf[179] = this.buf[177] - this.buf[176];
        this.buf[180] = this.buf[138] + this.buf[136];
        this.buf[181] = DCT_TABLE[58] * this.buf[138];
        this.buf[182] = DCT_TABLE[59] * this.buf[180];
        this.buf[183] = DCT_TABLE[60] * this.buf[136];
        this.buf[184] = this.buf[181] + this.buf[182];
        this.buf[185] = this.buf[183] - this.buf[182];
        this.buf[186] = this.buf[142] + this.buf[140];
        this.buf[187] = DCT_TABLE[61] * this.buf[142];
        this.buf[188] = DCT_TABLE[62] * this.buf[186];
        this.buf[189] = DCT_TABLE[63] * this.buf[140];
        this.buf[190] = this.buf[187] + this.buf[188];
        this.buf[191] = this.buf[189] - this.buf[188];
        this.buf[192] = this.buf[113] - this.buf[148];
        this.buf[193] = this.buf[113] + this.buf[148];
        this.buf[194] = this.buf[115] - this.buf[149];
        this.buf[195] = this.buf[115] + this.buf[149];
        this.buf[196] = this.buf[117] - this.buf[154];
        this.buf[197] = this.buf[117] + this.buf[154];
        this.buf[198] = this.buf[119] - this.buf[155];
        this.buf[199] = this.buf[119] + this.buf[155];
        this.buf[200] = this.buf[112] - this.buf[160];
        this.buf[201] = this.buf[112] + this.buf[160];
        this.buf[202] = this.buf[114] - this.buf[161];
        this.buf[203] = this.buf[114] + this.buf[161];
        this.buf[204] = this.buf[116] - this.buf[166];
        this.buf[205] = this.buf[116] + this.buf[166];
        this.buf[206] = this.buf[118] - this.buf[167];
        this.buf[207] = this.buf[118] + this.buf[167];
        this.buf[208] = this.buf[129] - this.buf[172];
        this.buf[209] = this.buf[129] + this.buf[172];
        this.buf[210] = this.buf[131] - this.buf[173];
        this.buf[211] = this.buf[131] + this.buf[173];
        this.buf[212] = this.buf[133] - this.buf[178];
        this.buf[213] = this.buf[133] + this.buf[178];
        this.buf[214] = this.buf[135] - this.buf[179];
        this.buf[215] = this.buf[135] + this.buf[179];
        this.buf[216] = this.buf[128] - this.buf[184];
        this.buf[217] = this.buf[128] + this.buf[184];
        this.buf[218] = this.buf[130] - this.buf[185];
        this.buf[219] = this.buf[130] + this.buf[185];
        this.buf[220] = this.buf[132] - this.buf[190];
        this.buf[221] = this.buf[132] + this.buf[190];
        this.buf[222] = this.buf[134] - this.buf[191];
        this.buf[223] = this.buf[134] + this.buf[191];
        this.buf[224] = this.buf[211] + this.buf[209];
        this.buf[225] = DCT_TABLE[64] * this.buf[211];
        this.buf[226] = DCT_TABLE[65] * this.buf[224];
        this.buf[227] = DCT_TABLE[66] * this.buf[209];
        this.buf[228] = this.buf[225] + this.buf[226];
        this.buf[229] = this.buf[227] - this.buf[226];
        this.buf[230] = this.buf[215] + this.buf[213];
        this.buf[231] = DCT_TABLE[67] * this.buf[215];
        this.buf[232] = DCT_TABLE[68] * this.buf[230];
        this.buf[233] = DCT_TABLE[69] * this.buf[213];
        this.buf[234] = this.buf[231] + this.buf[232];
        this.buf[235] = this.buf[233] - this.buf[232];
        this.buf[236] = this.buf[219] + this.buf[217];
        this.buf[237] = DCT_TABLE[70] * this.buf[219];
        this.buf[238] = DCT_TABLE[71] * this.buf[236];
        this.buf[239] = DCT_TABLE[72] * this.buf[217];
        this.buf[240] = this.buf[237] + this.buf[238];
        this.buf[241] = this.buf[239] - this.buf[238];
        this.buf[242] = this.buf[223] + this.buf[221];
        this.buf[243] = DCT_TABLE[73] * this.buf[223];
        this.buf[244] = DCT_TABLE[74] * this.buf[242];
        this.buf[245] = DCT_TABLE[75] * this.buf[221];
        this.buf[246] = this.buf[243] + this.buf[244];
        this.buf[247] = this.buf[245] - this.buf[244];
        this.buf[248] = this.buf[210] + this.buf[208];
        this.buf[249] = DCT_TABLE[76] * this.buf[210];
        this.buf[250] = DCT_TABLE[77] * this.buf[248];
        this.buf[251] = DCT_TABLE[78] * this.buf[208];
        this.buf[252] = this.buf[249] + this.buf[250];
        this.buf[253] = this.buf[251] - this.buf[250];
        this.buf[254] = this.buf[214] + this.buf[212];
        this.buf[255] = DCT_TABLE[79] * this.buf[214];
        this.buf[256] = DCT_TABLE[80] * this.buf[254];
        this.buf[257] = DCT_TABLE[81] * this.buf[212];
        this.buf[258] = this.buf[255] + this.buf[256];
        this.buf[259] = this.buf[257] - this.buf[256];
        this.buf[260] = this.buf[218] + this.buf[216];
        this.buf[261] = DCT_TABLE[82] * this.buf[218];
        this.buf[262] = DCT_TABLE[83] * this.buf[260];
        this.buf[263] = DCT_TABLE[84] * this.buf[216];
        this.buf[264] = this.buf[261] + this.buf[262];
        this.buf[265] = this.buf[263] - this.buf[262];
        this.buf[266] = this.buf[222] + this.buf[220];
        this.buf[267] = DCT_TABLE[85] * this.buf[222];
        this.buf[268] = DCT_TABLE[86] * this.buf[266];
        this.buf[269] = DCT_TABLE[87] * this.buf[220];
        this.buf[270] = this.buf[267] + this.buf[268];
        this.buf[271] = this.buf[269] - this.buf[268];
        this.buf[272] = this.buf[193] - this.buf[228];
        this.buf[273] = this.buf[193] + this.buf[228];
        this.buf[274] = this.buf[195] - this.buf[229];
        this.buf[275] = this.buf[195] + this.buf[229];
        this.buf[276] = this.buf[197] - this.buf[234];
        this.buf[277] = this.buf[197] + this.buf[234];
        this.buf[278] = this.buf[199] - this.buf[235];
        this.buf[279] = this.buf[199] + this.buf[235];
        this.buf[280] = this.buf[201] - this.buf[240];
        this.buf[281] = this.buf[201] + this.buf[240];
        this.buf[282] = this.buf[203] - this.buf[241];
        this.buf[283] = this.buf[203] + this.buf[241];
        this.buf[284] = this.buf[205] - this.buf[246];
        this.buf[285] = this.buf[205] + this.buf[246];
        this.buf[286] = this.buf[207] - this.buf[247];
        this.buf[287] = this.buf[207] + this.buf[247];
        this.buf[288] = this.buf[192] - this.buf[252];
        this.buf[289] = this.buf[192] + this.buf[252];
        this.buf[290] = this.buf[194] - this.buf[253];
        this.buf[291] = this.buf[194] + this.buf[253];
        this.buf[292] = this.buf[196] - this.buf[258];
        this.buf[293] = this.buf[196] + this.buf[258];
        this.buf[294] = this.buf[198] - this.buf[259];
        this.buf[295] = this.buf[198] + this.buf[259];
        this.buf[296] = this.buf[200] - this.buf[264];
        this.buf[297] = this.buf[200] + this.buf[264];
        this.buf[298] = this.buf[202] - this.buf[265];
        this.buf[299] = this.buf[202] + this.buf[265];
        this.buf[300] = this.buf[204] - this.buf[270];
        this.buf[301] = this.buf[204] + this.buf[270];
        this.buf[302] = this.buf[206] - this.buf[271];
        this.buf[303] = this.buf[206] + this.buf[271];
        this.buf[304] = this.buf[275] + this.buf[273];
        this.buf[305] = DCT_TABLE[88] * this.buf[275];
        this.buf[306] = DCT_TABLE[89] * this.buf[304];
        this.buf[307] = DCT_TABLE[90] * this.buf[273];
        in[0] = this.buf[305] + this.buf[306];
        in[31] = this.buf[307] - this.buf[306];
        this.buf[310] = this.buf[279] + this.buf[277];
        this.buf[311] = DCT_TABLE[91] * this.buf[279];
        this.buf[312] = DCT_TABLE[92] * this.buf[310];
        this.buf[313] = DCT_TABLE[93] * this.buf[277];
        in[2] = this.buf[311] + this.buf[312];
        in[29] = this.buf[313] - this.buf[312];
        this.buf[316] = this.buf[283] + this.buf[281];
        this.buf[317] = DCT_TABLE[94] * this.buf[283];
        this.buf[318] = DCT_TABLE[95] * this.buf[316];
        this.buf[319] = DCT_TABLE[96] * this.buf[281];
        in[4] = this.buf[317] + this.buf[318];
        in[27] = this.buf[319] - this.buf[318];
        this.buf[322] = this.buf[287] + this.buf[285];
        this.buf[323] = DCT_TABLE[97] * this.buf[287];
        this.buf[324] = DCT_TABLE[98] * this.buf[322];
        this.buf[325] = DCT_TABLE[99] * this.buf[285];
        in[6] = this.buf[323] + this.buf[324];
        in[25] = this.buf[325] - this.buf[324];
        this.buf[328] = this.buf[291] + this.buf[289];
        this.buf[329] = DCT_TABLE[100] * this.buf[291];
        this.buf[330] = DCT_TABLE[101] * this.buf[328];
        this.buf[331] = DCT_TABLE[102] * this.buf[289];
        in[8] = this.buf[329] + this.buf[330];
        in[23] = this.buf[331] - this.buf[330];
        this.buf[334] = this.buf[295] + this.buf[293];
        this.buf[335] = DCT_TABLE[103] * this.buf[295];
        this.buf[336] = DCT_TABLE[104] * this.buf[334];
        this.buf[337] = DCT_TABLE[105] * this.buf[293];
        in[10] = this.buf[335] + this.buf[336];
        in[21] = this.buf[337] - this.buf[336];
        this.buf[340] = this.buf[299] + this.buf[297];
        this.buf[341] = DCT_TABLE[106] * this.buf[299];
        this.buf[342] = DCT_TABLE[107] * this.buf[340];
        this.buf[343] = DCT_TABLE[108] * this.buf[297];
        in[12] = this.buf[341] + this.buf[342];
        in[19] = this.buf[343] - this.buf[342];
        this.buf[346] = this.buf[303] + this.buf[301];
        this.buf[347] = DCT_TABLE[109] * this.buf[303];
        this.buf[348] = DCT_TABLE[110] * this.buf[346];
        this.buf[349] = DCT_TABLE[111] * this.buf[301];
        in[14] = this.buf[347] + this.buf[348];
        in[17] = this.buf[349] - this.buf[348];
        this.buf[352] = this.buf[274] + this.buf[272];
        this.buf[353] = DCT_TABLE[112] * this.buf[274];
        this.buf[354] = DCT_TABLE[113] * this.buf[352];
        this.buf[355] = DCT_TABLE[114] * this.buf[272];
        in[16] = this.buf[353] + this.buf[354];
        in[15] = this.buf[355] - this.buf[354];
        this.buf[358] = this.buf[278] + this.buf[276];
        this.buf[359] = DCT_TABLE[115] * this.buf[278];
        this.buf[360] = DCT_TABLE[116] * this.buf[358];
        this.buf[361] = DCT_TABLE[117] * this.buf[276];
        in[18] = this.buf[359] + this.buf[360];
        in[13] = this.buf[361] - this.buf[360];
        this.buf[364] = this.buf[282] + this.buf[280];
        this.buf[365] = DCT_TABLE[118] * this.buf[282];
        this.buf[366] = DCT_TABLE[119] * this.buf[364];
        this.buf[367] = DCT_TABLE[120] * this.buf[280];
        in[20] = this.buf[365] + this.buf[366];
        in[11] = this.buf[367] - this.buf[366];
        this.buf[370] = this.buf[286] + this.buf[284];
        this.buf[371] = DCT_TABLE[121] * this.buf[286];
        this.buf[372] = DCT_TABLE[122] * this.buf[370];
        this.buf[373] = DCT_TABLE[123] * this.buf[284];
        in[22] = this.buf[371] + this.buf[372];
        in[9] = this.buf[373] - this.buf[372];
        this.buf[376] = this.buf[290] + this.buf[288];
        this.buf[377] = DCT_TABLE[124] * this.buf[290];
        this.buf[378] = DCT_TABLE[125] * this.buf[376];
        this.buf[379] = DCT_TABLE[126] * this.buf[288];
        in[24] = this.buf[377] + this.buf[378];
        in[7] = this.buf[379] - this.buf[378];
        this.buf[382] = this.buf[294] + this.buf[292];
        this.buf[383] = DCT_TABLE[127] * this.buf[294];
        this.buf[384] = DCT_TABLE[128] * this.buf[382];
        this.buf[385] = DCT_TABLE[129] * this.buf[292];
        in[26] = this.buf[383] + this.buf[384];
        in[5] = this.buf[385] - this.buf[384];
        this.buf[388] = this.buf[298] + this.buf[296];
        this.buf[389] = DCT_TABLE[130] * this.buf[298];
        this.buf[390] = DCT_TABLE[131] * this.buf[388];
        this.buf[391] = DCT_TABLE[132] * this.buf[296];
        in[28] = this.buf[389] + this.buf[390];
        in[3] = this.buf[391] - this.buf[390];
        this.buf[394] = this.buf[302] + this.buf[300];
        this.buf[395] = DCT_TABLE[133] * this.buf[302];
        this.buf[396] = DCT_TABLE[134] * this.buf[394];
        this.buf[397] = DCT_TABLE[135] * this.buf[300];
        in[30] = this.buf[395] + this.buf[396];
        in[1] = this.buf[397] - this.buf[396];
    }

    private void computeDST(float[] in) {
        this.buf[0] = in[0] - in[1];
        this.buf[1] = in[2] - in[1];
        this.buf[2] = in[2] - in[3];
        this.buf[3] = in[4] - in[3];
        this.buf[4] = in[4] - in[5];
        this.buf[5] = in[6] - in[5];
        this.buf[6] = in[6] - in[7];
        this.buf[7] = in[8] - in[7];
        this.buf[8] = in[8] - in[9];
        this.buf[9] = in[10] - in[9];
        this.buf[10] = in[10] - in[11];
        this.buf[11] = in[12] - in[11];
        this.buf[12] = in[12] - in[13];
        this.buf[13] = in[14] - in[13];
        this.buf[14] = in[14] - in[15];
        this.buf[15] = in[16] - in[15];
        this.buf[16] = in[16] - in[17];
        this.buf[17] = in[18] - in[17];
        this.buf[18] = in[18] - in[19];
        this.buf[19] = in[20] - in[19];
        this.buf[20] = in[20] - in[21];
        this.buf[21] = in[22] - in[21];
        this.buf[22] = in[22] - in[23];
        this.buf[23] = in[24] - in[23];
        this.buf[24] = in[24] - in[25];
        this.buf[25] = in[26] - in[25];
        this.buf[26] = in[26] - in[27];
        this.buf[27] = in[28] - in[27];
        this.buf[28] = in[28] - in[29];
        this.buf[29] = in[30] - in[29];
        this.buf[30] = in[30] - in[31];
        this.buf[31] = DST_TABLE[0] * this.buf[15];
        this.buf[32] = in[0] - this.buf[31];
        this.buf[33] = in[0] + this.buf[31];
        this.buf[34] = this.buf[7] + this.buf[23];
        this.buf[35] = DST_TABLE[1] * this.buf[7];
        this.buf[36] = DST_TABLE[2] * this.buf[34];
        this.buf[37] = DST_TABLE[3] * this.buf[23];
        this.buf[38] = this.buf[35] + this.buf[36];
        this.buf[39] = this.buf[37] - this.buf[36];
        this.buf[40] = this.buf[33] - this.buf[39];
        this.buf[41] = this.buf[33] + this.buf[39];
        this.buf[42] = this.buf[32] - this.buf[38];
        this.buf[43] = this.buf[32] + this.buf[38];
        this.buf[44] = this.buf[11] - this.buf[19];
        this.buf[45] = this.buf[11] + this.buf[19];
        this.buf[46] = DST_TABLE[4] * this.buf[45];
        this.buf[47] = this.buf[3] - this.buf[46];
        this.buf[48] = this.buf[3] + this.buf[46];
        this.buf[49] = DST_TABLE[5] * this.buf[44];
        this.buf[50] = this.buf[49] - this.buf[27];
        this.buf[51] = this.buf[49] + this.buf[27];
        this.buf[52] = this.buf[51] + this.buf[48];
        this.buf[53] = DST_TABLE[6] * this.buf[51];
        this.buf[54] = DST_TABLE[7] * this.buf[52];
        this.buf[55] = DST_TABLE[8] * this.buf[48];
        this.buf[56] = this.buf[53] + this.buf[54];
        this.buf[57] = this.buf[55] - this.buf[54];
        this.buf[58] = this.buf[50] + this.buf[47];
        this.buf[59] = DST_TABLE[9] * this.buf[50];
        this.buf[60] = DST_TABLE[10] * this.buf[58];
        this.buf[61] = DST_TABLE[11] * this.buf[47];
        this.buf[62] = this.buf[59] + this.buf[60];
        this.buf[63] = this.buf[61] - this.buf[60];
        this.buf[64] = this.buf[41] - this.buf[56];
        this.buf[65] = this.buf[41] + this.buf[56];
        this.buf[66] = this.buf[43] - this.buf[62];
        this.buf[67] = this.buf[43] + this.buf[62];
        this.buf[68] = this.buf[42] - this.buf[63];
        this.buf[69] = this.buf[42] + this.buf[63];
        this.buf[70] = this.buf[40] - this.buf[57];
        this.buf[71] = this.buf[40] + this.buf[57];
        this.buf[72] = this.buf[5] - this.buf[9];
        this.buf[73] = this.buf[5] + this.buf[9];
        this.buf[74] = this.buf[13] - this.buf[17];
        this.buf[75] = this.buf[13] + this.buf[17];
        this.buf[76] = this.buf[21] - this.buf[25];
        this.buf[77] = this.buf[21] + this.buf[25];
        this.buf[78] = DST_TABLE[12] * this.buf[75];
        this.buf[79] = this.buf[1] - this.buf[78];
        this.buf[80] = this.buf[1] + this.buf[78];
        this.buf[81] = this.buf[73] + this.buf[77];
        this.buf[82] = DST_TABLE[13] * this.buf[73];
        this.buf[83] = DST_TABLE[14] * this.buf[81];
        this.buf[84] = DST_TABLE[15] * this.buf[77];
        this.buf[85] = this.buf[82] + this.buf[83];
        this.buf[86] = this.buf[84] - this.buf[83];
        this.buf[87] = this.buf[80] - this.buf[86];
        this.buf[88] = this.buf[80] + this.buf[86];
        this.buf[89] = this.buf[79] - this.buf[85];
        this.buf[90] = this.buf[79] + this.buf[85];
        this.buf[91] = DST_TABLE[16] * this.buf[74];
        this.buf[92] = this.buf[29] - this.buf[91];
        this.buf[93] = this.buf[29] + this.buf[91];
        this.buf[94] = this.buf[76] + this.buf[72];
        this.buf[95] = DST_TABLE[17] * this.buf[76];
        this.buf[96] = DST_TABLE[18] * this.buf[94];
        this.buf[97] = DST_TABLE[19] * this.buf[72];
        this.buf[98] = this.buf[95] + this.buf[96];
        this.buf[99] = this.buf[97] - this.buf[96];
        this.buf[100] = this.buf[93] - this.buf[99];
        this.buf[101] = this.buf[93] + this.buf[99];
        this.buf[102] = this.buf[92] - this.buf[98];
        this.buf[103] = this.buf[92] + this.buf[98];
        this.buf[104] = this.buf[101] + this.buf[88];
        this.buf[105] = DST_TABLE[20] * this.buf[101];
        this.buf[106] = DST_TABLE[21] * this.buf[104];
        this.buf[107] = DST_TABLE[22] * this.buf[88];
        this.buf[108] = this.buf[105] + this.buf[106];
        this.buf[109] = this.buf[107] - this.buf[106];
        this.buf[110] = this.buf[90] - this.buf[103];
        this.buf[111] = DST_TABLE[23] * this.buf[103];
        this.buf[112] = DST_TABLE[24] * this.buf[110];
        this.buf[113] = DST_TABLE[25] * this.buf[90];
        this.buf[114] = this.buf[112] - this.buf[111];
        this.buf[115] = this.buf[113] - this.buf[112];
        this.buf[116] = this.buf[102] + this.buf[89];
        this.buf[117] = DST_TABLE[26] * this.buf[102];
        this.buf[118] = DST_TABLE[27] * this.buf[116];
        this.buf[119] = DST_TABLE[28] * this.buf[89];
        this.buf[120] = this.buf[117] + this.buf[118];
        this.buf[121] = this.buf[119] - this.buf[118];
        this.buf[122] = this.buf[87] - this.buf[100];
        this.buf[123] = DST_TABLE[29] * this.buf[100];
        this.buf[124] = DST_TABLE[30] * this.buf[122];
        this.buf[125] = DST_TABLE[31] * this.buf[87];
        this.buf[126] = this.buf[124] - this.buf[123];
        this.buf[127] = this.buf[125] - this.buf[124];
        this.buf[128] = this.buf[65] - this.buf[108];
        this.buf[129] = this.buf[65] + this.buf[108];
        this.buf[130] = this.buf[67] - this.buf[114];
        this.buf[131] = this.buf[67] + this.buf[114];
        this.buf[132] = this.buf[69] - this.buf[120];
        this.buf[133] = this.buf[69] + this.buf[120];
        this.buf[134] = this.buf[71] - this.buf[126];
        this.buf[135] = this.buf[71] + this.buf[126];
        this.buf[136] = this.buf[70] - this.buf[127];
        this.buf[137] = this.buf[70] + this.buf[127];
        this.buf[138] = this.buf[68] - this.buf[121];
        this.buf[139] = this.buf[68] + this.buf[121];
        this.buf[140] = this.buf[66] - this.buf[115];
        this.buf[141] = this.buf[66] + this.buf[115];
        this.buf[142] = this.buf[64] - this.buf[109];
        this.buf[143] = this.buf[64] + this.buf[109];
        this.buf[144] = this.buf[0] + this.buf[30];
        this.buf[145] = DST_TABLE[32] * this.buf[0];
        this.buf[146] = DST_TABLE[33] * this.buf[144];
        this.buf[147] = DST_TABLE[34] * this.buf[30];
        this.buf[148] = this.buf[145] + this.buf[146];
        this.buf[149] = this.buf[147] - this.buf[146];
        this.buf[150] = this.buf[4] + this.buf[26];
        this.buf[151] = DST_TABLE[35] * this.buf[4];
        this.buf[152] = DST_TABLE[36] * this.buf[150];
        this.buf[153] = DST_TABLE[37] * this.buf[26];
        this.buf[154] = this.buf[151] + this.buf[152];
        this.buf[155] = this.buf[153] - this.buf[152];
        this.buf[156] = this.buf[8] + this.buf[22];
        this.buf[157] = DST_TABLE[38] * this.buf[8];
        this.buf[158] = DST_TABLE[39] * this.buf[156];
        this.buf[159] = DST_TABLE[40] * this.buf[22];
        this.buf[160] = this.buf[157] + this.buf[158];
        this.buf[161] = this.buf[159] - this.buf[158];
        this.buf[162] = this.buf[12] + this.buf[18];
        this.buf[163] = DST_TABLE[41] * this.buf[12];
        this.buf[164] = DST_TABLE[42] * this.buf[162];
        this.buf[165] = DST_TABLE[43] * this.buf[18];
        this.buf[166] = this.buf[163] + this.buf[164];
        this.buf[167] = this.buf[165] - this.buf[164];
        this.buf[168] = this.buf[16] + this.buf[14];
        this.buf[169] = DST_TABLE[44] * this.buf[16];
        this.buf[170] = DST_TABLE[45] * this.buf[168];
        this.buf[171] = DST_TABLE[46] * this.buf[14];
        this.buf[172] = this.buf[169] + this.buf[170];
        this.buf[173] = this.buf[171] - this.buf[170];
        this.buf[174] = this.buf[20] + this.buf[10];
        this.buf[175] = DST_TABLE[47] * this.buf[20];
        this.buf[176] = DST_TABLE[48] * this.buf[174];
        this.buf[177] = DST_TABLE[49] * this.buf[10];
        this.buf[178] = this.buf[175] + this.buf[176];
        this.buf[179] = this.buf[177] - this.buf[176];
        this.buf[180] = this.buf[24] + this.buf[6];
        this.buf[181] = DST_TABLE[50] * this.buf[24];
        this.buf[182] = DST_TABLE[51] * this.buf[180];
        this.buf[183] = DST_TABLE[52] * this.buf[6];
        this.buf[184] = this.buf[181] + this.buf[182];
        this.buf[185] = this.buf[183] - this.buf[182];
        this.buf[186] = this.buf[28] + this.buf[2];
        this.buf[187] = DST_TABLE[53] * this.buf[28];
        this.buf[188] = DST_TABLE[54] * this.buf[186];
        this.buf[189] = DST_TABLE[55] * this.buf[2];
        this.buf[190] = this.buf[187] + this.buf[188];
        this.buf[191] = this.buf[189] - this.buf[188];
        this.buf[192] = this.buf[149] - this.buf[173];
        this.buf[193] = this.buf[149] + this.buf[173];
        this.buf[194] = this.buf[148] - this.buf[172];
        this.buf[195] = this.buf[148] + this.buf[172];
        this.buf[196] = this.buf[155] - this.buf[179];
        this.buf[197] = this.buf[155] + this.buf[179];
        this.buf[198] = this.buf[154] - this.buf[178];
        this.buf[199] = this.buf[154] + this.buf[178];
        this.buf[200] = this.buf[161] - this.buf[185];
        this.buf[201] = this.buf[161] + this.buf[185];
        this.buf[202] = this.buf[160] - this.buf[184];
        this.buf[203] = this.buf[160] + this.buf[184];
        this.buf[204] = this.buf[167] - this.buf[191];
        this.buf[205] = this.buf[167] + this.buf[191];
        this.buf[206] = this.buf[166] - this.buf[190];
        this.buf[207] = this.buf[166] + this.buf[190];
        this.buf[208] = this.buf[192] + this.buf[194];
        this.buf[209] = DST_TABLE[56] * this.buf[192];
        this.buf[210] = DST_TABLE[57] * this.buf[208];
        this.buf[211] = DST_TABLE[58] * this.buf[194];
        this.buf[212] = this.buf[209] + this.buf[210];
        this.buf[213] = this.buf[211] - this.buf[210];
        this.buf[214] = this.buf[196] + this.buf[198];
        this.buf[215] = DST_TABLE[59] * this.buf[196];
        this.buf[216] = DST_TABLE[60] * this.buf[214];
        this.buf[217] = DST_TABLE[61] * this.buf[198];
        this.buf[218] = this.buf[215] + this.buf[216];
        this.buf[219] = this.buf[217] - this.buf[216];
        this.buf[220] = this.buf[200] + this.buf[202];
        this.buf[221] = DST_TABLE[62] * this.buf[200];
        this.buf[222] = DST_TABLE[63] * this.buf[220];
        this.buf[223] = DST_TABLE[64] * this.buf[202];
        this.buf[224] = this.buf[221] + this.buf[222];
        this.buf[225] = this.buf[223] - this.buf[222];
        this.buf[226] = this.buf[204] + this.buf[206];
        this.buf[227] = DST_TABLE[65] * this.buf[204];
        this.buf[228] = DST_TABLE[66] * this.buf[226];
        this.buf[229] = DST_TABLE[67] * this.buf[206];
        this.buf[230] = this.buf[227] + this.buf[228];
        this.buf[231] = this.buf[229] - this.buf[228];
        this.buf[232] = this.buf[193] - this.buf[201];
        this.buf[233] = this.buf[193] + this.buf[201];
        this.buf[234] = this.buf[195] - this.buf[203];
        this.buf[235] = this.buf[195] + this.buf[203];
        this.buf[236] = this.buf[197] - this.buf[205];
        this.buf[237] = this.buf[197] + this.buf[205];
        this.buf[238] = this.buf[199] - this.buf[207];
        this.buf[239] = this.buf[199] + this.buf[207];
        this.buf[240] = this.buf[213] - this.buf[225];
        this.buf[241] = this.buf[213] + this.buf[225];
        this.buf[242] = this.buf[212] - this.buf[224];
        this.buf[243] = this.buf[212] + this.buf[224];
        this.buf[244] = this.buf[219] - this.buf[231];
        this.buf[245] = this.buf[219] + this.buf[231];
        this.buf[246] = this.buf[218] - this.buf[230];
        this.buf[247] = this.buf[218] + this.buf[230];
        this.buf[248] = this.buf[232] + this.buf[234];
        this.buf[249] = DST_TABLE[68] * this.buf[232];
        this.buf[250] = DST_TABLE[69] * this.buf[248];
        this.buf[251] = DST_TABLE[70] * this.buf[234];
        this.buf[252] = this.buf[249] + this.buf[250];
        this.buf[253] = this.buf[251] - this.buf[250];
        this.buf[254] = this.buf[236] + this.buf[238];
        this.buf[255] = DST_TABLE[71] * this.buf[236];
        this.buf[256] = DST_TABLE[72] * this.buf[254];
        this.buf[257] = DST_TABLE[73] * this.buf[238];
        this.buf[258] = this.buf[255] + this.buf[256];
        this.buf[259] = this.buf[257] - this.buf[256];
        this.buf[260] = this.buf[240] + this.buf[242];
        this.buf[261] = DST_TABLE[74] * this.buf[240];
        this.buf[262] = DST_TABLE[75] * this.buf[260];
        this.buf[263] = DST_TABLE[76] * this.buf[242];
        this.buf[264] = this.buf[261] + this.buf[262];
        this.buf[265] = this.buf[263] - this.buf[262];
        this.buf[266] = this.buf[244] + this.buf[246];
        this.buf[267] = DST_TABLE[77] * this.buf[244];
        this.buf[268] = DST_TABLE[78] * this.buf[266];
        this.buf[269] = DST_TABLE[79] * this.buf[246];
        this.buf[270] = this.buf[267] + this.buf[268];
        this.buf[271] = this.buf[269] - this.buf[268];
        this.buf[272] = this.buf[233] - this.buf[237];
        this.buf[273] = this.buf[233] + this.buf[237];
        this.buf[274] = this.buf[235] - this.buf[239];
        this.buf[275] = this.buf[235] + this.buf[239];
        this.buf[276] = this.buf[253] - this.buf[259];
        this.buf[277] = this.buf[253] + this.buf[259];
        this.buf[278] = this.buf[252] - this.buf[258];
        this.buf[279] = this.buf[252] + this.buf[258];
        this.buf[280] = this.buf[241] - this.buf[245];
        this.buf[281] = this.buf[241] + this.buf[245];
        this.buf[282] = this.buf[243] - this.buf[247];
        this.buf[283] = this.buf[243] + this.buf[247];
        this.buf[284] = this.buf[265] - this.buf[271];
        this.buf[285] = this.buf[265] + this.buf[271];
        this.buf[286] = this.buf[264] - this.buf[270];
        this.buf[287] = this.buf[264] + this.buf[270];
        this.buf[288] = this.buf[272] - this.buf[274];
        this.buf[289] = this.buf[272] + this.buf[274];
        this.buf[290] = DST_TABLE[80] * this.buf[288];
        this.buf[291] = DST_TABLE[81] * this.buf[289];
        this.buf[292] = this.buf[276] - this.buf[278];
        this.buf[293] = this.buf[276] + this.buf[278];
        this.buf[294] = DST_TABLE[82] * this.buf[292];
        this.buf[295] = DST_TABLE[83] * this.buf[293];
        this.buf[296] = this.buf[280] - this.buf[282];
        this.buf[297] = this.buf[280] + this.buf[282];
        this.buf[298] = DST_TABLE[84] * this.buf[296];
        this.buf[299] = DST_TABLE[85] * this.buf[297];
        this.buf[300] = this.buf[284] - this.buf[286];
        this.buf[301] = this.buf[284] + this.buf[286];
        this.buf[302] = DST_TABLE[86] * this.buf[300];
        this.buf[303] = DST_TABLE[87] * this.buf[301];
        this.buf[304] = this.buf[129] - this.buf[273];
        this.buf[305] = this.buf[129] + this.buf[273];
        this.buf[306] = this.buf[131] - this.buf[281];
        this.buf[307] = this.buf[131] + this.buf[281];
        this.buf[308] = this.buf[133] - this.buf[285];
        this.buf[309] = this.buf[133] + this.buf[285];
        this.buf[310] = this.buf[135] - this.buf[277];
        this.buf[311] = this.buf[135] + this.buf[277];
        this.buf[312] = this.buf[137] - this.buf[295];
        this.buf[313] = this.buf[137] + this.buf[295];
        this.buf[314] = this.buf[139] - this.buf[303];
        this.buf[315] = this.buf[139] + this.buf[303];
        this.buf[316] = this.buf[141] - this.buf[299];
        this.buf[317] = this.buf[141] + this.buf[299];
        this.buf[318] = this.buf[143] - this.buf[291];
        this.buf[319] = this.buf[143] + this.buf[291];
        this.buf[320] = this.buf[142] - this.buf[290];
        this.buf[321] = this.buf[142] + this.buf[290];
        this.buf[322] = this.buf[140] - this.buf[298];
        this.buf[323] = this.buf[140] + this.buf[298];
        this.buf[324] = this.buf[138] - this.buf[302];
        this.buf[325] = this.buf[138] + this.buf[302];
        this.buf[326] = this.buf[136] - this.buf[294];
        this.buf[327] = this.buf[136] + this.buf[294];
        this.buf[328] = this.buf[134] - this.buf[279];
        this.buf[329] = this.buf[134] + this.buf[279];
        this.buf[330] = this.buf[132] - this.buf[287];
        this.buf[331] = this.buf[132] + this.buf[287];
        this.buf[332] = this.buf[130] - this.buf[283];
        this.buf[333] = this.buf[130] + this.buf[283];
        this.buf[334] = this.buf[128] - this.buf[275];
        this.buf[335] = this.buf[128] + this.buf[275];
        in[31] = DST_TABLE[88] * this.buf[305];
        in[30] = DST_TABLE[89] * this.buf[307];
        in[29] = DST_TABLE[90] * this.buf[309];
        in[28] = DST_TABLE[91] * this.buf[311];
        in[27] = DST_TABLE[92] * this.buf[313];
        in[26] = DST_TABLE[93] * this.buf[315];
        in[25] = DST_TABLE[94] * this.buf[317];
        in[24] = DST_TABLE[95] * this.buf[319];
        in[23] = DST_TABLE[96] * this.buf[321];
        in[22] = DST_TABLE[97] * this.buf[323];
        in[21] = DST_TABLE[98] * this.buf[325];
        in[20] = DST_TABLE[99] * this.buf[327];
        in[19] = DST_TABLE[100] * this.buf[329];
        in[18] = DST_TABLE[101] * this.buf[331];
        in[17] = DST_TABLE[102] * this.buf[333];
        in[16] = DST_TABLE[103] * this.buf[335];
        in[15] = DST_TABLE[104] * this.buf[334];
        in[14] = DST_TABLE[105] * this.buf[332];
        in[13] = DST_TABLE[106] * this.buf[330];
        in[12] = DST_TABLE[107] * this.buf[328];
        in[11] = DST_TABLE[108] * this.buf[326];
        in[10] = DST_TABLE[109] * this.buf[324];
        in[9] = DST_TABLE[110] * this.buf[322];
        in[8] = DST_TABLE[111] * this.buf[320];
        in[7] = DST_TABLE[112] * this.buf[318];
        in[6] = DST_TABLE[113] * this.buf[316];
        in[5] = DST_TABLE[114] * this.buf[314];
        in[4] = DST_TABLE[115] * this.buf[312];
        in[3] = DST_TABLE[116] * this.buf[310];
        in[2] = DST_TABLE[117] * this.buf[308];
        in[1] = DST_TABLE[118] * this.buf[306];
        in[0] = DST_TABLE[119] * this.buf[304];
    }
}

