/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import java.util.logging.Level;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.ps2.PS;
import net.sourceforge.jaad.aac.sbr2.AnalysisFilterbank;
import net.sourceforge.jaad.aac.sbr2.ChannelData;
import net.sourceforge.jaad.aac.sbr2.FrequencyTables;
import net.sourceforge.jaad.aac.sbr2.HFAdjuster;
import net.sourceforge.jaad.aac.sbr2.HFGenerator;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;
import net.sourceforge.jaad.aac.sbr2.SBRHeader;
import net.sourceforge.jaad.aac.sbr2.SynthesisFilterbank;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.Constants;

public class SBR
implements SBRConstants {
    private boolean stereo;
    private int sampleFrequency;
    private boolean downSampled;
    private final SBRHeader header;
    private final ChannelData[] cd;
    private final FrequencyTables tables;
    private boolean coupling;
    private final float[][][][] W;
    private final float[][][] Xlow;
    private final float[][][] Xhigh;
    private final float[][][][] Y;
    private final float[][][][] X;
    private final AnalysisFilterbank qmfA;
    private final SynthesisFilterbank qmfS;
    private PS ps;
    private boolean psUsed;

    public SBR(SampleFrequency sf, boolean downSampled) {
        this.sampleFrequency = sf.getFrequency() * 2;
        this.downSampled = downSampled;
        this.header = new SBRHeader();
        this.cd = new ChannelData[2];
        this.cd[0] = new ChannelData();
        this.cd[1] = new ChannelData();
        this.tables = new FrequencyTables();
        this.W = new float[2][32][32][2];
        this.Xlow = new float[32][40][2];
        this.Xhigh = new float[64][40][2];
        this.Y = new float[2][44][64][2];
        this.X = new float[2][64][38][2];
        this.qmfA = new AnalysisFilterbank();
        this.qmfS = new SynthesisFilterbank();
        this.psUsed = false;
    }

    public void decode(BitStream in, int count, boolean stereo, boolean crc) throws AACException {
        this.stereo = stereo;
        int pos = in.getPosition();
        if (crc) {
            Constants.LOGGER.info("SBR CRC bits present");
            in.skipBits(10);
        }
        if (in.readBool()) {
            this.header.decode(in);
            if (this.header.isReset()) {
                this.tables.calculate(this.header, this.sampleFrequency);
            }
        }
        if (this.header.isDecoded()) {
            this.decodeData(in, stereo);
            int len = in.getPosition() - pos;
            int bitsLeft = count - len;
            if (bitsLeft >= 8) {
                Constants.LOGGER.log(Level.WARNING, "SBR: bits left: {0}", bitsLeft);
            } else if (bitsLeft < 0) {
                throw new AACException("SBR data overread: " + bitsLeft);
            }
            in.skipBits(bitsLeft);
        } else {
            int left = count - pos + in.getPosition();
            in.skipBits(left);
            Constants.LOGGER.log(Level.INFO, "SBR frame without header, skipped {0} bits", left);
        }
    }

    private void decodeData(BitStream in, boolean stereo) throws AACException {
        if (stereo) {
            this.decodeChannelPairElement(in);
        } else {
            this.decodeSingleChannelElement(in);
        }
        if (in.readBool()) {
            int count = in.readBits(4);
            if (count == 15) {
                count += in.readBits(8);
            }
            int bitsLeft = 8 * count;
            while (bitsLeft > 7) {
                bitsLeft -= 2;
                int extensionID = in.readBits(2);
                bitsLeft -= this.decodeExtension(in, extensionID);
            }
            if (bitsLeft > 0) {
                in.skipBits(bitsLeft);
            }
        }
    }

    private void decodeSingleChannelElement(BitStream in) throws AACException {
        if (in.readBool()) {
            in.skipBits(4);
        }
        this.cd[0].decodeGrid(in, this.header, this.tables);
        this.cd[0].decodeDTDF(in);
        this.cd[0].decodeInvf(in, this.header, this.tables);
        this.cd[0].decodeEnvelope(in, this.header, this.tables, false, false);
        this.cd[0].decodeNoise(in, this.header, this.tables, false, false);
        this.cd[0].decodeSinusoidal(in, this.header, this.tables);
        this.dequantSingle(0);
    }

    private void decodeChannelPairElement(BitStream in) throws AACException {
        if (in.readBool()) {
            in.skipBits(8);
        }
        if (this.coupling = in.readBool()) {
            this.cd[0].decodeGrid(in, this.header, this.tables);
            this.cd[1].copyGrid(this.cd[0]);
            this.cd[0].decodeDTDF(in);
            this.cd[1].decodeDTDF(in);
            this.cd[0].decodeInvf(in, this.header, this.tables);
            this.cd[1].copyInvf(this.cd[0]);
            this.cd[0].decodeEnvelope(in, this.header, this.tables, false, this.coupling);
            this.cd[0].decodeNoise(in, this.header, this.tables, false, this.coupling);
            this.cd[1].decodeEnvelope(in, this.header, this.tables, true, this.coupling);
            this.cd[1].decodeNoise(in, this.header, this.tables, true, this.coupling);
            this.dequantCoupled();
        } else {
            this.cd[0].decodeGrid(in, this.header, this.tables);
            this.cd[1].decodeGrid(in, this.header, this.tables);
            this.cd[0].decodeDTDF(in);
            this.cd[1].decodeDTDF(in);
            this.cd[0].decodeInvf(in, this.header, this.tables);
            this.cd[1].decodeInvf(in, this.header, this.tables);
            this.cd[0].decodeEnvelope(in, this.header, this.tables, false, this.coupling);
            this.cd[1].decodeEnvelope(in, this.header, this.tables, true, this.coupling);
            this.cd[0].decodeNoise(in, this.header, this.tables, false, this.coupling);
            this.cd[1].decodeNoise(in, this.header, this.tables, true, this.coupling);
            this.dequantSingle(0);
            this.dequantSingle(1);
        }
        this.cd[0].decodeSinusoidal(in, this.header, this.tables);
        this.cd[1].decodeSinusoidal(in, this.header, this.tables);
    }

    private int decodeExtension(BitStream in, int extensionID) throws AACException {
        int start = in.getPosition();
        switch (extensionID) {
            case 2: {
                if (this.ps == null) {
                    this.ps = new PS();
                }
                this.ps.decode(in);
                if (this.psUsed || !this.ps.hasHeader()) break;
                this.psUsed = true;
                break;
            }
            default: {
                in.skipBits(6);
            }
        }
        return in.getPosition() - start;
    }

    private void dequantSingle(int ch) {
        float a = this.cd[ch].getAmpRes() ? 1.0f : 0.5f;
        float[][] e = this.cd[ch].getEnvelopeScalefactors();
        int[] freqRes = this.cd[ch].getFrequencyResolutions();
        int[] n = this.tables.getN();
        int l = 0;
        while (l < this.cd[ch].getEnvCount()) {
            int k = 0;
            while (k < n[freqRes[l]]) {
                e[l][k] = (float)Math.pow(2.0, e[l][k] * a + 6.0f);
                ++k;
            }
            ++l;
        }
        int nq = this.tables.getNq();
        int lq = this.cd[ch].getNoiseCount();
        float[][] q = this.cd[ch].getNoiseFloorData();
        int l2 = 0;
        while (l2 < lq) {
            int k = 0;
            while (k < nq) {
                q[l2][k] = (float)Math.pow(2.0, 6.0f - q[l2][k]);
                ++k;
            }
            ++l2;
        }
    }

    private void dequantCoupled() {
        float f3;
        float f2;
        float f1;
        float a = this.cd[0].getAmpRes() ? 1.0f : 0.5f;
        int panOffset = PAN_OFFSETS[this.cd[0].getAmpRes() ? 1 : 0];
        float[][] e0 = this.cd[0].getEnvelopeScalefactors();
        float[][] e1 = this.cd[1].getEnvelopeScalefactors();
        int[] r = this.cd[0].getFrequencyResolutions();
        int le = this.cd[0].getEnvCount();
        int[] n = this.tables.getN();
        int l = 0;
        while (l < le) {
            int k = 0;
            while (k < n[r[l]]) {
                f1 = (float)Math.pow(2.0, e0[l][k] * a + 7.0f);
                f2 = (float)Math.pow(2.0, ((float)panOffset - e1[l][k]) * a);
                e0[l][k] = f3 = f1 / (1.0f + f2);
                e1[l][k] = f3 * f2;
                ++k;
            }
            ++l;
        }
        float[][] q0 = this.cd[0].getNoiseFloorData();
        float[][] q1 = this.cd[1].getNoiseFloorData();
        int lq = this.cd[0].getNoiseCount();
        int nq = this.tables.getNq();
        int l2 = 0;
        while (l2 < lq) {
            int k = 0;
            while (k < nq) {
                f1 = (float)Math.pow(2.0, 6.0f - q0[l2][k] + 1.0f);
                f2 = (float)Math.pow(2.0, (float)PAN_OFFSETS[1] - q1[l2][k]);
                q0[l2][k] = f3 = f1 / (1.0f + f2);
                q0[l2][k] = f3 * f2;
                ++k;
            }
            ++l2;
        }
    }

    public boolean isPSUsed() {
        return this.psUsed;
    }

    public void process(float[] left, float[] right, boolean downSampled) throws AACException {
        this.processChannel(0, left);
        if (this.stereo) {
            this.processChannel(1, right);
        } else if (this.psUsed) {
            int l = 32;
            while (l < 38) {
                int k = 0;
                while (k < 5) {
                    this.X[0][k][l][0] = this.Xlow[k][l + 2][0];
                    this.X[0][k][l][1] = this.Xlow[k][l + 2][1];
                    ++k;
                }
                ++l;
            }
            this.ps.process(this.X[0], this.X[1]);
        }
        this.qmfS.process(this.X[0], left, 0);
        if (this.stereo || this.psUsed) {
            this.qmfS.process(this.X[1], right, 0);
        }
    }

    private void processChannel(int ch, float[] data) throws AACException {
        int k;
        int kxPrev = this.tables.getKx(true);
        int l = 0;
        while (l < 8) {
            k = 0;
            while (k < kxPrev) {
                this.Xlow[k][l][0] = this.W[ch][k][l + 32 - 8][0];
                this.Xlow[k][l][1] = this.W[ch][k][l + 32 - 8][1];
                ++k;
            }
            k = kxPrev;
            while (k < 32) {
                this.Xlow[k][l][0] = 0.0f;
                this.Xlow[k][l][1] = 0.0f;
                ++k;
            }
            ++l;
        }
        this.qmfA.process(data, this.W[ch], 0);
        int kx = this.tables.getKx(false);
        l = 8;
        while (l < 40) {
            k = 0;
            while (k < kx) {
                this.Xlow[k][l][0] = this.W[ch][l - 8][k][0];
                this.Xlow[k][l][1] = this.W[ch][l - 8][k][1];
                ++k;
            }
            k = kx;
            while (k < 32) {
                this.Xlow[k][l][0] = 0.0f;
                this.Xlow[k][l][1] = 0.0f;
                ++k;
            }
            ++l;
        }
        HFGenerator.process(this.tables, this.cd[ch], this.Xlow, this.Xhigh);
        int lTemp = this.cd[ch].getLTemp();
        int mPrev = this.tables.getM(true);
        int m = this.tables.getM(false);
        l = 0;
        while (l < lTemp) {
            k = 0;
            while (k < kxPrev) {
                this.X[ch][k][l][0] = this.Xlow[k][l + 2][0];
                this.X[ch][k][l][1] = this.Xlow[k][l + 2][1];
                ++k;
            }
            k = kxPrev;
            while (k < kxPrev + mPrev) {
                this.X[ch][k][l][0] = this.Y[ch][l + 2 + 32][k][0];
                this.X[ch][k][l][1] = this.Y[ch][l + 2 + 32][k][1];
                ++k;
            }
            k = kxPrev + mPrev;
            while (k < 64) {
                this.X[ch][k][l][0] = 0.0f;
                this.X[ch][k][l][1] = 0.0f;
                ++k;
            }
            ++l;
        }
        HFAdjuster.process(this.header, this.tables, this.cd[ch], this.Xhigh, this.Y[ch]);
        l = lTemp;
        while (l < 32) {
            k = 0;
            while (k < kx) {
                this.X[ch][k][l][0] = this.Xlow[k][l + 2][0];
                this.X[ch][k][l][1] = this.Xlow[k][l + 2][1];
                ++k;
            }
            k = kx;
            while (k < kx + m) {
                this.X[ch][k][l][0] = this.Y[ch][l + 2][k][0];
                this.X[ch][k][l][1] = this.Y[ch][l + 2][k][1];
                ++k;
            }
            k = kx + m;
            while (k < 64) {
                this.X[ch][k][l][0] = 0.0f;
                this.X[ch][k][l][1] = 0.0f;
                ++k;
            }
            ++l;
        }
        this.cd[ch].savePreviousData();
    }
}

