/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl;

import java.io.IOException;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.FullBox;

public class PaddingBitBox
extends FullBox {
    private int[] pad1;
    private int[] pad2;

    public PaddingBitBox() {
        super("Padding Bit Box");
    }

    public void decode(MP4InputStream in) throws IOException {
        super.decode(in);
        int sampleCount = (int)(in.readBytes(4) + 1L) / 2;
        this.pad1 = new int[sampleCount];
        this.pad2 = new int[sampleCount];
        int i = 0;
        while (i < sampleCount) {
            byte b = (byte)in.read();
            this.pad1[i] = b >> 4 & 7;
            this.pad2[i] = b & 7;
            ++i;
        }
    }

    public int[] getPad1() {
        return this.pad1;
    }

    public int[] getPad2() {
        return this.pad2;
    }
}

