/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import net.sourceforge.jaad.spi.javasound.MP4AudioInputStream;

public class AACAudioFileReader
extends AudioFileReader {
    public static final AudioFileFormat.Type AAC = new AudioFileFormat.Type("AAC", "aac");
    public static final AudioFileFormat.Type MP4 = new AudioFileFormat.Type("MP4", "mp4");
    private static final AudioFormat.Encoding AAC_ENCODING = new AudioFormat.Encoding("AAC");

    public AudioFileFormat getAudioFileFormat(InputStream in) throws UnsupportedAudioFileException, IOException {
        try {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(4);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(in, -1);
            return audioFileFormat;
        }
        finally {
            in.reset();
        }
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream in = url.openStream();
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(in);
            return audioFileFormat;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            in.mark(1000);
            AudioFileFormat aff = this.getAudioFileFormat(in, (int)file.length());
            in.reset();
            AudioFileFormat audioFileFormat = aff;
            return audioFileFormat;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private AudioFileFormat getAudioFileFormat(InputStream in, int mediaLength) throws UnsupportedAudioFileException, IOException {
        byte[] b = new byte[8];
        in.read(b);
        boolean canHandle = false;
        if (new String(b, 4, 4).equals("ftyp")) {
            canHandle = true;
        } else {
            BitStream bit = new BitStream(b);
            try {
                ADTSDemultiplexer adts = new ADTSDemultiplexer(in);
                canHandle = true;
            }
            catch (Exception e) {
                canHandle = false;
            }
        }
        if (canHandle) {
            AudioFormat format = new AudioFormat(AAC_ENCODING, -1.0f, -1, mediaLength, -1, -1.0f, true);
            return new AudioFileFormat(AAC, format, -1);
        }
        throw new UnsupportedAudioFileException();
    }

    public AudioInputStream getAudioInputStream(InputStream in) throws UnsupportedAudioFileException, IOException {
        try {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(1000);
            AudioFileFormat aff = this.getAudioFileFormat(in, -1);
            in.reset();
            return new MP4AudioInputStream(in, aff.getFormat(), aff.getFrameLength());
        }
        catch (UnsupportedAudioFileException e) {
            in.reset();
            throw e;
        }
        catch (IOException e) {
            in.reset();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream in = url.openStream();
        try {
            return this.getAudioInputStream(in);
        }
        catch (UnsupportedAudioFileException e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
        catch (IOException e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            return this.getAudioInputStream(in);
        }
        catch (UnsupportedAudioFileException e) {
            if (in != null) {
                ((InputStream)in).close();
            }
            throw e;
        }
        catch (IOException e) {
            if (in != null) {
                ((InputStream)in).close();
            }
            throw e;
        }
    }
}

