/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    private static final String DEBUG_PROPERTY = "Debug";
    private static final String DebugPackage;
    private static final String DebugClass;
    private static final boolean enabled;

    static {
        DebugClass = Debug.class.getName();
        int lastDot = DebugClass.lastIndexOf(46);
        DebugPackage = DebugClass.substring(0, lastDot);
        String debug = System.getProperty(DEBUG_PROPERTY);
        boolean bl = enabled = debug != null && !debug.equalsIgnoreCase("false");
        if (enabled) {
            Debug.class.getClassLoader().setDefaultAssertionStatus(true);
        }
    }

    public static synchronized void log(Level level, String message, Object ... args) {
        Object[] strArgs = new String[args.length];
        int i = 0;
        while (i < args.length) {
            strArgs[i] = String.valueOf(args[i]);
            ++i;
        }
        String className = "";
        String methodName = "";
        String packageName = "org.corebounce.common.log";
        try {
            packageName = DebugPackage;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            int index = 0;
            while (index < stack.length && (stack[index].getClassName().startsWith(DebugClass) || stack[index].getClassName().startsWith("java.lang.Thread"))) {
                ++index;
            }
            if (index < stack.length) {
                int lastDot = stack[index].getClassName().lastIndexOf(46);
                packageName = stack[index].getClassName().substring(0, lastDot);
            }
            className = stack[index].getClassName();
            methodName = stack[index].getMethodName();
        }
        catch (Throwable stack) {
            // empty catch block
        }
        Logger logger = Logger.getLogger(packageName);
        if (logger.isLoggable(level)) {
            if (args.length == 1 && args[0] instanceof Throwable) {
                logger.logp(level, className, methodName, message, (Throwable)args[0]);
            } else {
                logger.logp(level, className, methodName, message, strArgs);
            }
        }
    }

    public static void debug(String message, Object ... args) {
        Debug.log(Level.FINE, message, args);
    }

    public static void info(String message, Object ... args) {
        Debug.log(Level.INFO, message, args);
    }

    public static void warn(String message, Object ... args) {
        Debug.log(Level.WARNING, message, args);
    }

    public static void warn(Throwable t) {
        Debug.log(Level.WARNING, t.getMessage(), t);
    }

    public static void error(String message, Object ... args) {
        Debug.log(Level.SEVERE, message, args);
    }

    public static void error(String message, Throwable t) {
        Debug.log(Level.SEVERE, message, t);
    }

    public static void error(Throwable t) {
        Debug.log(Level.SEVERE, t.getMessage(), t);
    }

    public static void doNothing() {
    }

    public static boolean isEnabled() {
        return enabled;
    }
}

