/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.corebounce.common.audio.file.AudioFileTypes;

public class AudioFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private static AudioFileFilter readInstance;
    private static AudioFileFilter writeInstance;
    private final Collection<String> extensions;
    private final String mainExtension;
    private final String label;

    public static AudioFileFilter readInstance() {
        if (readInstance == null) {
            readInstance = new AudioFileFilter(false);
        }
        return readInstance;
    }

    public static AudioFileFilter writeInstance() {
        if (writeInstance == null) {
            writeInstance = new AudioFileFilter(true);
        }
        return writeInstance;
    }

    public static Collection<AudioFileFilter> individualInstances(boolean writing) {
        ArrayList<AudioFileFilter> result = new ArrayList<AudioFileFilter>();
        AudioFileTypes afs = AudioFileTypes.instance();
        Collection<String> types = writing ? afs.getSupportedWriteTypes() : afs.getSupportedReadTypes();
        for (String fileType : types) {
            Collection<String> extensions = afs.getExtensionsForType(fileType);
            if (extensions.isEmpty()) {
                extensions.add("." + fileType.toLowerCase());
            }
            String mainExtension = extensions.iterator().next();
            AudioFileFilter aff = new AudioFileFilter(AudioFileFilter.label(fileType, extensions), extensions, mainExtension);
            result.add(aff);
        }
        return result;
    }

    private AudioFileFilter(boolean writing) {
        AudioFileTypes afs = AudioFileTypes.instance();
        this.extensions = writing ? afs.getSupportedWriteExtensions() : afs.getSupportedReadExtensions();
        this.mainExtension = null;
        this.label = "All Supported Audio Files";
    }

    private AudioFileFilter(String label, Collection<String> extensions, String mainExtension) {
        this.extensions = extensions;
        this.mainExtension = mainExtension;
        this.label = label;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        for (String ext : this.extensions) {
            if (!name.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String name) {
        for (String ext : this.extensions) {
            if (!name.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.label;
    }

    public Collection<String> getExtensions() {
        return this.extensions;
    }

    public String getMainExtension() {
        return this.mainExtension;
    }

    public String getLabel() {
        return this.label;
    }

    private static String label(String fileType, Collection<String> extensions) {
        StringBuilder extList = new StringBuilder();
        for (String ext : extensions) {
            if (extList.length() > 0) {
                extList.append(",");
            }
            extList.append("*");
            extList.append(ext);
        }
        return String.valueOf(fileType) + " files (" + extList.toString() + ")";
    }

    public String toString() {
        return this.label;
    }
}

