/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.file;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.corebounce.common.audio.file.AudioFileTypes;
import org.corebounce.common.audio.file.AudioInputStreamSource;
import org.corebounce.common.audio.file.AudioSourceInputStream;
import org.corebounce.common.io.RandomFileInputStream;
import org.corebounce.common.utils.IProgressMonitor;

public class AudioFileIO {
    public static IMultiChanAudioSource readAudioFile(File file) throws IOException, UnsupportedAudioFileException {
        RandomFileInputStream input = new RandomFileInputStream(file);
        return AudioFileIO.readAudioFile(file.getName(), input);
    }

    public static IMultiChanAudioSource readAudioFile(String fileName, InputStream stream) throws IOException, UnsupportedAudioFileException {
        AudioFileTypes aft = AudioFileTypes.instance();
        AudioInputStream audioInput = aft.getAudioInputStream(fileName, stream);
        return new AudioInputStreamSource(audioInput);
    }

    public static void saveAudioFile(IMultiChanAudioSource audioSource, long length, OutputStream target, AudioFileFormat saveFormat, IProgressMonitor progress) throws IOException {
        try (AudioInputStream input = AudioSourceInputStream.createAudioInputStream(audioSource, saveFormat.getFormat(), progress, length);){
            AudioFileTypes.write(input, saveFormat.getType(), target);
        }
    }
}

