/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp;

import java.util.Arrays;

public class AverageBuffer {
    private int size;
    private float[] values;
    private int index;
    private float sum = 0.0f;

    public AverageBuffer(int size) {
        this.size = size;
        this.values = new float[size];
        this.index = 0;
    }

    public void push(double value) {
        this.push((float)value);
    }

    public void push(float value) {
        this.sum -= this.values[this.index];
        this.values[this.index] = value;
        this.sum += value;
        this.index = (this.index + 1) % this.size;
    }

    public float getAverage() {
        return this.sum / (float)this.size;
    }

    public int getSize() {
        return this.size;
    }

    public float getLatency() {
        return ((float)this.size - 1.0f) / 2.0f;
    }

    public void setSize(int size) {
        if (size == this.size) {
            return;
        }
        float[] old = this.values;
        float average = this.getAverage();
        this.size = size;
        this.values = new float[size];
        int min = size < old.length ? size : old.length;
        int offset = size - min;
        int i = 0;
        while (i < min) {
            this.values[i + offset] = old[(this.index + i) % old.length];
            ++i;
        }
        i = 0;
        while (i < offset) {
            this.values[i] = average;
            ++i;
        }
        this.sum = 0.0f;
        i = 0;
        while (i < size) {
            this.sum += this.values[i];
            ++i;
        }
        this.index = 0;
    }

    public void resetTo(float value) {
        Arrays.fill(this.values, value);
        this.sum = value * (float)this.values.length;
        this.index = 0;
    }

    public void raiseBy(float amount) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.values[n] = this.values[n] + amount;
            this.sum += amount;
        }
    }
}

