/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.fft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;

public class RFFT1 {
    private int length;
    private int log;
    protected final float sqrthalf = (float)Math.sqrt(0.5);
    protected float[] d16 = new float[8];
    protected float[] d32 = new float[16];
    protected float[] d64 = new float[32];
    protected float[] d128 = new float[64];
    protected float[] d256 = new float[128];
    protected float[] d512 = new float[256];
    protected float[][] roots;
    protected int[][] scrambleTable;
    protected int[] swapTable;
    protected int[][] scrambleTableReal;
    protected int[] swapTableReal;

    public RFFT1(int length) {
        if ((length & length - 1) != 0) {
            throw new IllegalArgumentException("lenght must be a power of 2");
        }
        this.length = length;
        this.log = this.log2(length);
        this.init(length);
    }

    protected static final void transform(float[] a, int a0re, int a1re, int a2re, int a3re, float wre, float wim) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t1 = a[a0re] - a[a2re];
        float t2 = a[a0im] - a[a2im];
        float t3 = a[a1re] - a[a3re];
        float t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        float t5 = t1 - t4;
        float t6 = t2 + t3;
        float t7 = t1 + t4;
        float t8 = t2 - t3;
        a[a2re] = t5 * wre - t6 * wim;
        a[a2im] = t6 * wre + t5 * wim;
        a[a3re] = t7 * wre + t8 * wim;
        a[a3im] = t8 * wre - t7 * wim;
    }

    protected final void transformHalf(float[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t1 = a[a0re] - a[a2re];
        float t2 = a[a0im] - a[a2im];
        float t3 = a[a1re] - a[a3re];
        float t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        float t5 = t1 - t4;
        float t6 = t2 + t3;
        float t7 = t1 + t4;
        float t8 = t2 - t3;
        a[a2re] = (t5 - t6) * this.sqrthalf;
        a[a2im] = (t6 + t5) * this.sqrthalf;
        a[a3re] = (t7 + t8) * this.sqrthalf;
        a[a3im] = (t8 - t7) * this.sqrthalf;
    }

    protected final void transformZero(float[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t1 = a[a0re] - a[a2re];
        float t2 = a[a0im] - a[a2im];
        float t3 = a[a1re] - a[a3re];
        float t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        a[a2re] = t1 - t4;
        a[a2im] = t2 + t3;
        a[a3re] = t1 + t4;
        a[a3im] = t2 - t3;
    }

    protected final void untransform(float[] a, int a0re, int a1re, int a2re, int a3re, float wre, float wim) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t5 = a[a2re] * wre + a[a2im] * wim;
        float t6 = a[a2im] * wre - a[a2re] * wim;
        float t7 = a[a3re] * wre - a[a3im] * wim;
        float t8 = a[a3im] * wre + a[a3re] * wim;
        float t1 = t5 + t7;
        float t2 = t6 + t8;
        float t3 = t6 - t8;
        float t4 = t7 - t5;
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void untransformHalf(float[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t5 = (a[a2re] + a[a2im]) * this.sqrthalf;
        float t6 = (a[a2im] - a[a2re]) * this.sqrthalf;
        float t7 = (a[a3re] - a[a3im]) * this.sqrthalf;
        float t8 = (a[a3im] + a[a3re]) * this.sqrthalf;
        float t1 = t5 + t7;
        float t2 = t6 + t8;
        float t3 = t6 - t8;
        float t4 = t7 - t5;
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void untransformZero(float[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t1 = a[a2re] + a[a3re];
        float t2 = a[a2im] + a[a3im];
        float t3 = a[a2im] - a[a3im];
        float t4 = a[a3re] - a[a2re];
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void transformReal(float[] r, int a, int b, float wre, float wim) {
        float t1 = r[a + 0] - r[a + 1];
        float t2 = r[b + 0] - r[b + 1];
        float t3 = r[a + 0] + r[a + 1];
        float t4 = r[b + 0] + r[b + 1];
        r[b + 0] = t1 * wre - t2 * wim;
        r[b + 1] = t2 * wre + t1 * wim;
        r[a + 0] = t3;
        r[a + 1] = t4;
    }

    protected final void transformRealHalf(float[] r, int a, int b) {
        float t1 = r[a + 0] - r[a + 1];
        float t2 = r[b + 0] - r[b + 1];
        float t3 = r[a + 0] + r[a + 1];
        float t4 = r[b + 0] + r[b + 1];
        r[b + 0] = (t1 - t2) * this.sqrthalf;
        r[b + 1] = (t2 + t1) * this.sqrthalf;
        r[a + 0] = t3;
        r[a + 1] = t4;
    }

    protected final void transformRealZero(float[] r, int a, int b) {
        float t1 = r[a + 0] - r[a + 1];
        float t2 = r[b + 0] - r[b + 1];
        float t3 = r[a + 0] + r[a + 1];
        float t4 = r[b + 0] + r[b + 1];
        r[b + 0] = t1;
        r[b + 1] = t2;
        r[a + 0] = t3;
        r[a + 1] = t4;
    }

    protected final void untransformReal(float[] r, int a, int b, float wre, float wim) {
        float t5 = r[b + 0] * wre + r[b + 1] * wim;
        float t6 = r[b + 1] * wre - r[b + 0] * wim;
        float t1 = r[a + 0] + t5;
        float t2 = r[a + 0] - t5;
        float t3 = r[a + 1] + t6;
        float t4 = r[a + 1] - t6;
        r[a + 0] = t1;
        r[a + 1] = t2;
        r[b + 0] = t3;
        r[b + 1] = t4;
    }

    protected final void untransformRealHalf(float[] r, int a, int b) {
        float t5 = (r[b + 0] + r[b + 1]) * this.sqrthalf;
        float t6 = (r[b + 1] - r[b + 0]) * this.sqrthalf;
        float t1 = r[a + 0] + t5;
        float t2 = r[a + 0] - t5;
        float t3 = r[a + 1] + t6;
        float t4 = r[a + 1] - t6;
        r[a + 0] = t1;
        r[a + 1] = t2;
        r[b + 0] = t3;
        r[b + 1] = t4;
    }

    protected final void untransformRealZero(float[] r, int a, int b) {
        float t1 = r[a + 0] + r[b + 0];
        float t2 = r[a + 0] - r[b + 0];
        float t3 = r[a + 1] + r[b + 1];
        float t4 = r[a + 1] - r[b + 1];
        r[a + 0] = t1;
        r[a + 1] = t2;
        r[b + 0] = t3;
        r[b + 1] = t4;
    }

    protected final void cpass(float[] a, int off, float[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.transformZero(a, a0, a1, a2, a3);
        int k = 2 * n - 1;
        int b = 2;
        do {
            RFFT1.transform(a, b + a0, b + a1, b + a2, b + a3, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void upass(float[] a, int off, float[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.untransformZero(a, a0, a1, a2, a3);
        int k = 2 * n - 1;
        int b = 2;
        do {
            this.untransform(a, b + a0, b + a1, b + a2, b + a3, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void rpass(float[] a, float[] w, int n) {
        int h = 4 * n;
        this.transformRealZero(a, 0, h);
        int b = 2;
        int k = 2 * n - 1;
        do {
            this.transformReal(a, b, b + h, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void vpass(float[] a, float[] w, int n) {
        int h = 4 * n;
        this.untransformRealZero(a, 0, h);
        int b = 2;
        int k = 2 * n - 1;
        do {
            this.untransformReal(a, b, b + h, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void cpassBig(float[] a, int off, float[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.transformZero(a, a0, a1, a2, a3);
        int k = n - 1;
        int wb = 2;
        do {
            RFFT1.transform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb += 2;
        } while (--k > 0);
        this.transformHalf(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2);
        wb -= 2;
        k = n - 1;
        do {
            RFFT1.transform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb -= 2;
        } while (--k > 0);
    }

    protected final void upassBig(float[] a, int off, float[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.untransformZero(a, a0, a1, a2, a3);
        int k = n - 1;
        int wb = 2;
        do {
            this.untransform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb += 2;
        } while (--k > 0);
        this.untransformHalf(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2);
        wb -= 2;
        k = n - 1;
        do {
            this.untransform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb -= 2;
        } while (--k > 0);
    }

    protected final void rpassBig(float[] a, float[] w, int n) {
        int h = 4 * n;
        this.transformRealZero(a, 0, h);
        int b = 2;
        int wb = 2;
        int k = n - 1;
        do {
            this.transformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb += 2;
        } while (--k > 0);
        this.transformRealHalf(a, b + 0, b + h);
        b += 2;
        wb -= 2;
        k = n - 1;
        do {
            this.transformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb -= 2;
        } while (--k > 0);
    }

    protected final void vpassBig(float[] a, float[] w, int n) {
        int h = 4 * n;
        this.untransformRealZero(a, 0, h);
        int b = 2;
        int wb = 2;
        int k = n - 1;
        do {
            this.untransformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb += 2;
        } while (--k > 0);
        this.untransformRealHalf(a, b + 0, b + h);
        b += 2;
        wb -= 2;
        k = n - 1;
        do {
            this.untransformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb -= 2;
        } while (--k > 0);
    }

    protected final void c2(float[] a, int off) {
        float t1 = a[off + 0] + a[off + 2];
        float t2 = a[off + 1] + a[off + 3];
        float t3 = a[off + 0] - a[off + 2];
        float t4 = a[off + 1] - a[off + 3];
        a[off + 0] = t1;
        a[off + 1] = t2;
        a[off + 2] = t3;
        a[off + 3] = t4;
    }

    protected final void r2(float[] a) {
        float t1 = a[0] + a[1];
        float t2 = a[0] - a[1];
        a[0] = t1;
        a[1] = t2;
    }

    protected final void c4(float[] a, int off) {
        int a0re = off + 0;
        int a1re = off + 2;
        int a2re = off + 4;
        int a3re = off + 6;
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t1 = a[a0re] - a[a2re];
        float t2 = a[a0im] - a[a2im];
        float t3 = a[a1re] - a[a3re];
        float t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        a[a2re] = t1 - t4;
        a[a2im] = t2 + t3;
        a[a3re] = t1 + t4;
        a[a3im] = t2 - t3;
        t1 = a[a0re] + a[a1re];
        t2 = a[a0im] + a[a1im];
        t3 = a[a0re] - a[a1re];
        t4 = a[a0im] - a[a1im];
        a[a0re] = t1;
        a[a0im] = t2;
        a[a1re] = t3;
        a[a1im] = t4;
    }

    protected final void u4(float[] a, int off) {
        int a0re = off + 0;
        int a1re = off + 2;
        int a2re = off + 4;
        int a3re = off + 6;
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        float t1 = a[a0re] + a[a1re];
        float t2 = a[a0im] + a[a1im];
        float t3 = a[a0re] - a[a1re];
        float t4 = a[a0im] - a[a1im];
        a[a0re] = t1;
        a[a0im] = t2;
        a[a1re] = t3;
        a[a1im] = t4;
        t1 = a[a2re] + a[a3re];
        t2 = a[a2im] + a[a3im];
        t3 = a[a2im] - a[a3im];
        t4 = a[a3re] - a[a2re];
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void r4(float[] a) {
        this.transformRealZero(a, 0, 2);
        this.r2(a);
    }

    protected final void v4(float[] a) {
        this.r2(a);
        this.untransformRealZero(a, 0, 2);
    }

    protected final void c8(float[] a, int off) {
        this.transformZero(a, off + 0, off + 4, off + 8, off + 12);
        this.transformHalf(a, off + 2, off + 6, off + 10, off + 14);
        this.c4(a, off);
        this.c2(a, off + 8);
        this.c2(a, off + 12);
    }

    protected final void u8(float[] a, int off) {
        this.u4(a, off);
        this.c2(a, off + 8);
        this.c2(a, off + 12);
        this.untransformZero(a, off + 0, off + 4, off + 8, off + 12);
        this.untransformHalf(a, off + 2, off + 6, off + 10, off + 14);
    }

    protected final void r8(float[] a) {
        this.transformRealZero(a, 0, 4);
        this.transformRealHalf(a, 2, 6);
        this.r4(a);
        this.c2(a, 4);
    }

    protected final void v8(float[] a) {
        this.v4(a);
        this.c2(a, 4);
        this.untransformRealZero(a, 0, 4);
        this.untransformRealHalf(a, 2, 6);
    }

    protected final void c16(float[] a, int off) {
        this.cpass(a, off, this.d16, 2);
        this.c8(a, off);
        this.c4(a, off + 16);
        this.c4(a, off + 24);
    }

    protected final void u16(float[] a, int off) {
        this.u8(a, off);
        this.u4(a, off + 16);
        this.u4(a, off + 24);
        this.upass(a, off, this.d16, 2);
    }

    protected final void r16(float[] a) {
        this.rpass(a, this.d16, 2);
        this.r8(a);
        this.c4(a, 8);
    }

    protected final void v16(float[] a) {
        this.v8(a);
        this.u4(a, 8);
        this.vpass(a, this.d16, 2);
    }

    protected final void c32(float[] a, int off) {
        this.cpass(a, off, this.d32, 4);
        this.c16(a, off);
        this.c8(a, off + 32);
        this.c8(a, off + 48);
    }

    protected final void u32(float[] a, int off) {
        this.u16(a, off);
        this.u8(a, off + 32);
        this.u8(a, off + 48);
        this.upass(a, off, this.d32, 4);
    }

    protected final void r32(float[] a) {
        this.rpass(a, this.d32, 4);
        this.r16(a);
        this.c8(a, 16);
    }

    protected final void v32(float[] a) {
        this.v16(a);
        this.u8(a, 16);
        this.vpass(a, this.d32, 4);
    }

    protected final void c64(float[] a, int off) {
        this.cpass(a, off, this.d64, 8);
        this.c32(a, off);
        this.c16(a, off + 64);
        this.c16(a, off + 96);
    }

    protected final void u64(float[] a, int off) {
        this.u32(a, off);
        this.u16(a, off + 64);
        this.u16(a, off + 96);
        this.upass(a, off, this.d64, 8);
    }

    protected final void r64(float[] a) {
        this.rpass(a, this.d64, 8);
        this.r32(a);
        this.c16(a, 32);
    }

    protected final void v64(float[] a) {
        this.v32(a);
        this.u16(a, 32);
        this.vpass(a, this.d64, 8);
    }

    protected final void c128(float[] a, int off) {
        this.cpass(a, off, this.d128, 16);
        this.c64(a, off);
        this.c32(a, off + 128);
        this.c32(a, off + 192);
    }

    protected final void u128(float[] a, int off) {
        this.u64(a, off);
        this.u32(a, off + 128);
        this.u32(a, off + 192);
        this.upass(a, off, this.d128, 16);
    }

    protected final void r128(float[] a) {
        this.rpass(a, this.d128, 16);
        this.r64(a);
        this.c32(a, 64);
    }

    protected final void v128(float[] a) {
        this.v64(a);
        this.u32(a, 64);
        this.vpass(a, this.d128, 16);
    }

    protected final void c256(float[] a, int off) {
        this.cpass(a, off, this.d256, 32);
        this.c128(a, off);
        this.c64(a, off + 256);
        this.c64(a, off + 384);
    }

    protected final void u256(float[] a, int off) {
        this.u128(a, off);
        this.u64(a, off + 256);
        this.u64(a, off + 384);
        this.upass(a, off, this.d256, 32);
    }

    protected final void r256(float[] a) {
        this.rpass(a, this.d256, 32);
        this.r128(a);
        this.c64(a, 128);
    }

    protected final void v256(float[] a) {
        this.v128(a);
        this.u64(a, 128);
        this.vpass(a, this.d256, 32);
    }

    protected final void c512(float[] a, int off) {
        this.cpass(a, off, this.d512, 64);
        this.c256(a, off);
        this.c128(a, off + 512);
        this.c128(a, off + 768);
    }

    protected final void u512(float[] a, int off) {
        this.u256(a, off);
        this.u128(a, off + 512);
        this.u128(a, off + 768);
        this.upass(a, off, this.d512, 64);
    }

    protected final void r512(float[] a) {
        this.rpass(a, this.d512, 64);
        this.r256(a);
        this.c128(a, 256);
    }

    protected final void v512(float[] a) {
        this.v256(a);
        this.u128(a, 256);
        this.vpass(a, this.d512, 64);
    }

    protected final void cn(float[] a, int off, int log) {
        switch (log) {
            case 1: {
                this.c2(a, off);
                break;
            }
            case 2: {
                this.c4(a, off);
                break;
            }
            case 3: {
                this.c8(a, off);
                break;
            }
            case 4: {
                this.c16(a, off);
                break;
            }
            case 5: {
                this.c32(a, off);
                break;
            }
            case 6: {
                this.c64(a, off);
                break;
            }
            case 7: {
                this.c128(a, off);
                break;
            }
            case 8: {
                this.c256(a, off);
                break;
            }
            case 9: {
                this.c512(a, off);
                break;
            }
            default: {
                int size = 1 << log;
                this.cpassBig(a, off, this.roots[log], size / 8);
                this.cn(a, off, log - 1);
                this.cn(a, off + size, log - 2);
                this.cn(a, off + size + size / 2, log - 2);
            }
        }
    }

    protected final void un(float[] a, int off, int log) {
        switch (log) {
            case 1: {
                this.c2(a, off);
                break;
            }
            case 2: {
                this.u4(a, off);
                break;
            }
            case 3: {
                this.u8(a, off);
                break;
            }
            case 4: {
                this.u16(a, off);
                break;
            }
            case 5: {
                this.u32(a, off);
                break;
            }
            case 6: {
                this.u64(a, off);
                break;
            }
            case 7: {
                this.u128(a, off);
                break;
            }
            case 8: {
                this.u256(a, off);
                break;
            }
            case 9: {
                this.u512(a, off);
                break;
            }
            default: {
                int size = 1 << log;
                this.un(a, off, log - 1);
                this.un(a, off + size, log - 2);
                this.un(a, off + size + size / 2, log - 2);
                this.upassBig(a, off, this.roots[log], size / 8);
            }
        }
    }

    protected final void rn(float[] a, int log) {
        switch (log) {
            case 1: {
                this.r2(a);
                break;
            }
            case 2: {
                this.r4(a);
                break;
            }
            case 3: {
                this.r8(a);
                break;
            }
            case 4: {
                this.r16(a);
                break;
            }
            case 5: {
                this.r32(a);
                break;
            }
            case 6: {
                this.r64(a);
                break;
            }
            case 7: {
                this.r128(a);
                break;
            }
            case 8: {
                this.r256(a);
                break;
            }
            case 9: {
                this.r512(a);
                break;
            }
            default: {
                int size = 1 << log;
                this.rpassBig(a, this.roots[log], size / 8);
                this.rn(a, log - 1);
                this.cn(a, size / 2, log - 2);
            }
        }
    }

    protected final void vn(float[] a, int log) {
        switch (log) {
            case 1: {
                this.r2(a);
                break;
            }
            case 2: {
                this.v4(a);
                break;
            }
            case 3: {
                this.v8(a);
                break;
            }
            case 4: {
                this.v16(a);
                break;
            }
            case 5: {
                this.v32(a);
                break;
            }
            case 6: {
                this.v64(a);
                break;
            }
            case 7: {
                this.v128(a);
                break;
            }
            case 8: {
                this.v256(a);
                break;
            }
            case 9: {
                this.v512(a);
                break;
            }
            default: {
                int size = 1 << log;
                this.vn(a, log - 1);
                this.un(a, size / 2, log - 2);
                this.vpassBig(a, this.roots[log], size / 8);
            }
        }
    }

    private int log2(int size) {
        int log = 0;
        if (size >= 65536) {
            log += 16;
            size >>>= 16;
        }
        if (size >= 256) {
            log += 8;
            size >>>= 8;
        }
        if (size >= 16) {
            log += 4;
            size >>>= 4;
        }
        if (size >= 4) {
            log += 2;
            size >>>= 2;
        }
        if (size >= 2) {
            ++log;
        }
        return log;
    }

    public void forwFFT(float[] a) {
        this.cn(a, 0, this.log);
    }

    public void backFFT(float[] a) {
        this.un(a, 0, this.log);
    }

    public void forwRealFFT(float[] a) {
        this.rn(a, this.log + 1);
    }

    public void backRealFFT(float[] a) {
        this.vn(a, this.log + 1);
    }

    public void scale(float[] a) {
        float u = 1.0f / (float)this.length;
        int i = 0;
        while (i < this.length * 2) {
            int n = i++;
            a[n] = a[n] * u;
        }
    }

    public void scaleReal(float[] a) {
        float u = 1.0f / (float)(this.length * 2);
        a[0] = a[0] * u;
        a[1] = a[1] * u;
        u += u;
        int i = 2;
        while (i < this.length * 2) {
            int n = i++;
            a[n] = a[n] * u;
        }
    }

    public void mul(float[] a, float[] b) {
        int are = 0;
        int aim = 1;
        int i = 0;
        while (i < this.length) {
            float re = a[are] * b[are] - a[aim] * b[aim];
            float im = a[are] * b[aim] + a[aim] * b[are];
            a[are] = re;
            a[aim] = im;
            are += 2;
            aim += 2;
            ++i;
        }
    }

    public void mulReal(float[] a, float[] b) {
        a[0] = a[0] * b[0];
        a[1] = a[1] * b[1];
        int are = 2;
        int aim = 3;
        int i = 1;
        while (i < this.length) {
            float re = a[are] * b[are] - a[aim] * b[aim];
            float im = a[are] * b[aim] + a[aim] * b[are];
            a[are] = re;
            a[aim] = im;
            are += 2;
            aim += 2;
            ++i;
        }
    }

    private int replace(int i, int n) {
        if (n <= 2) {
            return i;
        }
        int m = n / 2;
        if (i < m) {
            return this.replace(i, m) * 2;
        }
        if ((i -= m) < (m /= 2)) {
            return this.replace(i, m) * 4 + 1;
        }
        return this.replace(i -= m, m) * 4 - 1 & n - 1;
    }

    private int replaceReal(int i, int n) {
        if (n <= 2) {
            return i;
        }
        int m = n / 2;
        if (i < m) {
            return this.replaceReal(i, m) * 2;
        }
        return this.replace((i -= m) / 2, m / 2) * 2 + 1;
    }

    private void makeScrambleTables() {
        int[] loop;
        int j;
        int length;
        int size = this.length;
        ArrayList<int[]> cycles = new ArrayList<int[]>();
        BitSet visited = new BitSet(size);
        int[] cycle = new int[size];
        int[] swapList = new int[size * 2];
        int swapOffset = 0;
        int max = 0;
        int i = 0;
        while (i < size) {
            if (!visited.get(i)) {
                length = 0;
                j = this.replace(i, size);
                while (j != i) {
                    visited.set(j);
                    cycle[length++] = j * 2;
                    j = this.replace(j, size);
                }
                if (length == 1) {
                    swapList[swapOffset++] = i * 2;
                    swapList[swapOffset++] = cycle[0];
                } else if (length > 1) {
                    if (length > max) {
                        max = length;
                    }
                    loop = new int[length + 1];
                    loop[0] = i * 2;
                    System.arraycopy(cycle, 0, loop, 1, length);
                    cycles.add(loop);
                }
            }
            ++i;
        }
        this.scrambleTable = new int[cycles.size()][];
        i = 0;
        while (i < this.scrambleTable.length) {
            this.scrambleTable[i] = (int[])cycles.get(i);
            ++i;
        }
        this.swapTable = new int[swapOffset];
        System.arraycopy(swapList, 0, this.swapTable, 0, swapOffset);
        cycles.clear();
        visited = new BitSet(size);
        swapOffset = 0;
        max = 0;
        i = 0;
        while (i < size) {
            if (!visited.get(i)) {
                length = 0;
                j = this.replaceReal(i * 2, size * 2);
                while (j != i) {
                    visited.set(j);
                    cycle[length++] = j * 2;
                    j = this.replaceReal(j * 2, size * 2);
                }
                if (length == 1) {
                    swapList[swapOffset++] = i * 2;
                    swapList[swapOffset++] = cycle[0];
                } else if (length > 1) {
                    if (length > max) {
                        max = length;
                    }
                    loop = new int[length + 1];
                    loop[0] = i * 2;
                    System.arraycopy(cycle, 0, loop, 1, length);
                    cycles.add(loop);
                }
            }
            ++i;
        }
        this.scrambleTableReal = new int[cycles.size()][];
        i = 0;
        while (i < this.scrambleTableReal.length) {
            this.scrambleTableReal[i] = (int[])cycles.get(i);
            ++i;
        }
        this.swapTableReal = new int[swapOffset];
        System.arraycopy(swapList, 0, this.swapTableReal, 0, swapOffset);
        cycles = null;
        swapList = null;
        cycle = null;
    }

    private void doScramble(float[] a, int[] swaps, int[][] cycles) {
        float im;
        float re;
        int i = 0;
        while (i < swaps.length) {
            int p1 = swaps[i];
            int p2 = swaps[i + 1];
            re = a[p1 + 0];
            im = a[p1 + 1];
            a[p1 + 0] = a[p2 + 0];
            a[p1 + 1] = a[p2 + 1];
            a[p2 + 0] = re;
            a[p2 + 1] = im;
            i += 2;
        }
        i = 0;
        while (i < cycles.length) {
            int[] cycle = cycles[i];
            int p = cycle[cycle.length - 1];
            re = a[p + 0];
            im = a[p + 1];
            int j = cycle.length - 2;
            while (j >= 0) {
                int n = cycle[j];
                a[p + 0] = a[n + 0];
                a[p + 1] = a[n + 1];
                p = n;
                --j;
            }
            a[p + 0] = re;
            a[p + 1] = im;
            ++i;
        }
    }

    private void doUnscramble(float[] a, int[] swaps, int[][] cycles) {
        float im;
        float re;
        int i = 0;
        while (i < swaps.length) {
            int p1 = swaps[i];
            int p2 = swaps[i + 1];
            re = a[p1 + 0];
            im = a[p1 + 1];
            a[p1 + 0] = a[p2 + 0];
            a[p1 + 1] = a[p2 + 1];
            a[p2 + 0] = re;
            a[p2 + 1] = im;
            i += 2;
        }
        i = 0;
        while (i < cycles.length) {
            int[] cycle = cycles[i];
            int p = cycle[0];
            re = a[p + 0];
            im = a[p + 1];
            int j = 1;
            while (j < cycle.length) {
                int n = cycle[j];
                a[p + 0] = a[n + 0];
                a[p + 1] = a[n + 1];
                p = n;
                ++j;
            }
            a[p + 0] = re;
            a[p + 1] = im;
            ++i;
        }
    }

    public void scramble(float[] arr) {
        this.doScramble(arr, this.swapTable, this.scrambleTable);
    }

    public void unscramble(float[] a) {
        this.doUnscramble(a, this.swapTable, this.scrambleTable);
    }

    public void scrambleReal(float[] arr) {
        this.doScramble(arr, this.swapTableReal, this.scrambleTableReal);
    }

    public void unscrambleReal(float[] a) {
        this.doUnscramble(a, this.swapTableReal, this.scrambleTableReal);
    }

    private void fillRoot(float[] roots, int n, int div) {
        float cosInc = (float)Math.cos(Math.PI * 2 / (double)n);
        float sinInc = (float)Math.sin(Math.PI * 2 / (double)n);
        roots[0] = 1.0f;
        roots[1] = 0.0f;
        float lre = 1.0f;
        float lim = 0.0f;
        int i = 1;
        while (i < n / div) {
            float re = cosInc * lre - sinInc * lim;
            float im = sinInc * lre + cosInc * lim;
            lre = re;
            lim = im;
            roots[i * 2 + 0] = re;
            roots[i * 2 + 1] = im;
            ++i;
        }
    }

    private void fillRoot(float[] roots, float[] next) {
        int n = next.length / 4;
        int i = 0;
        while (i < n) {
            roots[i * 2 + 0] = next[i * 4 + 0];
            roots[i * 2 + 1] = next[i * 4 + 1];
            ++i;
        }
    }

    private void init(int length) {
        int log = 0;
        int ln = 1;
        while (ln < length) {
            ln *= 2;
            ++log;
        }
        this.roots = new float[(log < 10 ? 10 : log) * 2 + 4][];
        int i = this.roots.length - 1;
        while (i >= 3) {
            int size = 1 << i;
            this.roots[i] = new float[size / 4];
            this.fillRoot(this.roots[i], size, 8);
            --i;
        }
        this.fillRoot(this.d512, 512, 4);
        this.fillRoot(this.d256, this.d512);
        this.fillRoot(this.d128, this.d256);
        this.fillRoot(this.d64, this.d128);
        this.fillRoot(this.d32, this.d64);
        this.fillRoot(this.d16, this.d32);
        this.makeScrambleTables();
    }

    public static void main(String[] args) {
        int Log2 = 12;
        int Size = 4096;
        System.out.println("Computing forward and backward FFT (including scrambling/unscrambling) of 8192 real samples between -1.0 and 1.0");
        float[] arr = new float[8192];
        float[] chk = new float[8192];
        RFFT1 fft = new RFFT1(4096);
        Random random = new Random(0L);
        int i = 0;
        while (i < arr.length / 2) {
            arr[i * 2 + 0] = (float)(random.nextDouble() * 2.0 - 1.0);
            arr[i * 2 + 1] = (float)(random.nextDouble() * 2.0 - 1.0);
            chk[i * 2 + 0] = arr[i * 2 + 0];
            chk[i * 2 + 1] = arr[i * 2 + 1];
            ++i;
        }
        fft.forwFFT(arr);
        fft.scale(arr);
        fft.unscramble(arr);
        fft.scramble(arr);
        fft.backFFT(arr);
        float err = 0.0f;
        int i2 = 0;
        while (i2 < 8192) {
            err += Math.abs(arr[i2] - chk[i2]);
            ++i2;
        }
        System.out.println("Average absolute error: " + err / 4096.0f);
        long[] times = new long[40];
        long sum = 0L;
        System.out.println("Testing speed of 300 computations " + times.length + " times...");
        int j = -10;
        while (j < times.length) {
            int i3 = 0;
            while (i3 < arr.length / 2) {
                arr[i3 * 2 + 0] = (float)(random.nextDouble() * 2.0 - 1.0);
                arr[i3 * 2 + 1] = (float)(random.nextDouble() * 2.0 - 1.0);
                ++i3;
            }
            long time = System.nanoTime() / 1000L;
            int i4 = 0;
            while (i4 < 300) {
                fft.forwFFT(arr);
                fft.scale(arr);
                fft.unscramble(arr);
                fft.scramble(arr);
                fft.backFFT(arr);
                ++i4;
            }
            time = (System.nanoTime() / 1000L - time) / 300L;
            if (j >= 0) {
                times[j] = time;
                if (j != 0) {
                    sum += time;
                }
            }
            ++j;
        }
        Arrays.sort(times);
        System.out.println("Average time (ms): " + (float)sum / (float)(times.length - 1));
        System.out.println("Minimum time (ms): " + times[0]);
    }
}

