/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.fft;

import java.util.Arrays;
import java.util.Random;

public class RFFT3 {
    private int length;
    private int log;
    protected final double sqrthalf = Math.sqrt(0.5);
    protected double[] d16 = new double[8];
    protected double[] d32 = new double[16];
    protected double[] d64 = new double[32];
    protected double[] d128 = new double[64];
    protected double[] d256 = new double[128];
    protected double[] d512 = new double[256];
    protected double[][] roots;
    protected int[][] scrambleTable;
    protected int[] swapTable;
    protected int[][] scrambleTableReal;
    protected int[] swapTableReal;

    public RFFT3(int length) {
        if ((length & length - 1) != 0) {
            throw new IllegalArgumentException("lenght must be a power of 2");
        }
        this.length = length;
        this.log = this.log2(length);
        this.init(length);
    }

    protected static final void transform(double[] a, int a0re, int a1re, int a2re, int a3re, double wre, double wim) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t1 = a[a0re] - a[a2re];
        double t2 = a[a0im] - a[a2im];
        double t3 = a[a1re] - a[a3re];
        double t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        double t5 = t1 - t4;
        double t6 = t2 + t3;
        double t7 = t1 + t4;
        double t8 = t2 - t3;
        a[a2re] = t5 * wre - t6 * wim;
        a[a2im] = t6 * wre + t5 * wim;
        a[a3re] = t7 * wre + t8 * wim;
        a[a3im] = t8 * wre - t7 * wim;
    }

    protected final void transformHalf(double[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t1 = a[a0re] - a[a2re];
        double t2 = a[a0im] - a[a2im];
        double t3 = a[a1re] - a[a3re];
        double t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        double t5 = t1 - t4;
        double t6 = t2 + t3;
        double t7 = t1 + t4;
        double t8 = t2 - t3;
        a[a2re] = (t5 - t6) * this.sqrthalf;
        a[a2im] = (t6 + t5) * this.sqrthalf;
        a[a3re] = (t7 + t8) * this.sqrthalf;
        a[a3im] = (t8 - t7) * this.sqrthalf;
    }

    protected final void transformZero(double[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t1 = a[a0re] - a[a2re];
        double t2 = a[a0im] - a[a2im];
        double t3 = a[a1re] - a[a3re];
        double t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        a[a2re] = t1 - t4;
        a[a2im] = t2 + t3;
        a[a3re] = t1 + t4;
        a[a3im] = t2 - t3;
    }

    protected final void untransform(double[] a, int a0re, int a1re, int a2re, int a3re, double wre, double wim) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t5 = a[a2re] * wre + a[a2im] * wim;
        double t6 = a[a2im] * wre - a[a2re] * wim;
        double t7 = a[a3re] * wre - a[a3im] * wim;
        double t8 = a[a3im] * wre + a[a3re] * wim;
        double t1 = t5 + t7;
        double t2 = t6 + t8;
        double t3 = t6 - t8;
        double t4 = t7 - t5;
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void untransformHalf(double[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t5 = (a[a2re] + a[a2im]) * this.sqrthalf;
        double t6 = (a[a2im] - a[a2re]) * this.sqrthalf;
        double t7 = (a[a3re] - a[a3im]) * this.sqrthalf;
        double t8 = (a[a3im] + a[a3re]) * this.sqrthalf;
        double t1 = t5 + t7;
        double t2 = t6 + t8;
        double t3 = t6 - t8;
        double t4 = t7 - t5;
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void untransformZero(double[] a, int a0re, int a1re, int a2re, int a3re) {
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t1 = a[a2re] + a[a3re];
        double t2 = a[a2im] + a[a3im];
        double t3 = a[a2im] - a[a3im];
        double t4 = a[a3re] - a[a2re];
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void transformReal(double[] r, int a, int b, double wre, double wim) {
        double t1 = r[a + 0] - r[a + 1];
        double t2 = r[b + 0] - r[b + 1];
        double t3 = r[a + 0] + r[a + 1];
        double t4 = r[b + 0] + r[b + 1];
        r[b + 0] = t1 * wre - t2 * wim;
        r[b + 1] = t2 * wre + t1 * wim;
        r[a + 0] = t3;
        r[a + 1] = t4;
    }

    protected final void transformRealHalf(double[] r, int a, int b) {
        double t1 = r[a + 0] - r[a + 1];
        double t2 = r[b + 0] - r[b + 1];
        double t3 = r[a + 0] + r[a + 1];
        double t4 = r[b + 0] + r[b + 1];
        r[b + 0] = (t1 - t2) * this.sqrthalf;
        r[b + 1] = (t2 + t1) * this.sqrthalf;
        r[a + 0] = t3;
        r[a + 1] = t4;
    }

    protected final void transformRealZero(double[] r, int a, int b) {
        double t1 = r[a + 0] - r[a + 1];
        double t2 = r[b + 0] - r[b + 1];
        double t3 = r[a + 0] + r[a + 1];
        double t4 = r[b + 0] + r[b + 1];
        r[b + 0] = t1;
        r[b + 1] = t2;
        r[a + 0] = t3;
        r[a + 1] = t4;
    }

    protected final void untransformReal(double[] r, int a, int b, double wre, double wim) {
        double t5 = r[b + 0] * wre + r[b + 1] * wim;
        double t6 = r[b + 1] * wre - r[b + 0] * wim;
        double t1 = r[a + 0] + t5;
        double t2 = r[a + 0] - t5;
        double t3 = r[a + 1] + t6;
        double t4 = r[a + 1] - t6;
        r[a + 0] = t1;
        r[a + 1] = t2;
        r[b + 0] = t3;
        r[b + 1] = t4;
    }

    protected final void untransformRealHalf(double[] r, int a, int b) {
        double t5 = (r[b + 0] + r[b + 1]) * this.sqrthalf;
        double t6 = (r[b + 1] - r[b + 0]) * this.sqrthalf;
        double t1 = r[a + 0] + t5;
        double t2 = r[a + 0] - t5;
        double t3 = r[a + 1] + t6;
        double t4 = r[a + 1] - t6;
        r[a + 0] = t1;
        r[a + 1] = t2;
        r[b + 0] = t3;
        r[b + 1] = t4;
    }

    protected final void untransformRealZero(double[] r, int a, int b) {
        double t1 = r[a + 0] + r[b + 0];
        double t2 = r[a + 0] - r[b + 0];
        double t3 = r[a + 1] + r[b + 1];
        double t4 = r[a + 1] - r[b + 1];
        r[a + 0] = t1;
        r[a + 1] = t2;
        r[b + 0] = t3;
        r[b + 1] = t4;
    }

    protected final void cpass(double[] a, int off, double[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.transformZero(a, a0, a1, a2, a3);
        int k = 2 * n - 1;
        int b = 2;
        do {
            RFFT3.transform(a, b + a0, b + a1, b + a2, b + a3, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void upass(double[] a, int off, double[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.untransformZero(a, a0, a1, a2, a3);
        int k = 2 * n - 1;
        int b = 2;
        do {
            this.untransform(a, b + a0, b + a1, b + a2, b + a3, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void rpass(double[] a, double[] w, int n) {
        int h = 4 * n;
        this.transformRealZero(a, 0, h);
        int b = 2;
        int k = 2 * n - 1;
        do {
            this.transformReal(a, b, b + h, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void vpass(double[] a, double[] w, int n) {
        int h = 4 * n;
        this.untransformRealZero(a, 0, h);
        int b = 2;
        int k = 2 * n - 1;
        do {
            this.untransformReal(a, b, b + h, w[b + 0], w[b + 1]);
            b += 2;
        } while (--k > 0);
    }

    protected final void cpassBig(double[] a, int off, double[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.transformZero(a, a0, a1, a2, a3);
        int k = n - 1;
        int wb = 2;
        do {
            RFFT3.transform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb += 2;
        } while (--k > 0);
        this.transformHalf(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2);
        wb -= 2;
        k = n - 1;
        do {
            RFFT3.transform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb -= 2;
        } while (--k > 0);
    }

    protected final void upassBig(double[] a, int off, double[] w, int n) {
        int a0 = off;
        int a1 = 4 * n + off;
        int a2 = 8 * n + off;
        int a3 = 12 * n + off;
        this.untransformZero(a, a0, a1, a2, a3);
        int k = n - 1;
        int wb = 2;
        do {
            this.untransform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb += 2;
        } while (--k > 0);
        this.untransformHalf(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2);
        wb -= 2;
        k = n - 1;
        do {
            this.untransform(a, a0 += 2, a1 += 2, a2 += 2, a3 += 2, w[wb + 0], w[wb + 1]);
            wb -= 2;
        } while (--k > 0);
    }

    protected final void rpassBig(double[] a, double[] w, int n) {
        int h = 4 * n;
        this.transformRealZero(a, 0, h);
        int b = 2;
        int wb = 2;
        int k = n - 1;
        do {
            this.transformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb += 2;
        } while (--k > 0);
        this.transformRealHalf(a, b + 0, b + h);
        b += 2;
        wb -= 2;
        k = n - 1;
        do {
            this.transformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb -= 2;
        } while (--k > 0);
    }

    protected final void vpassBig(double[] a, double[] w, int n) {
        int h = 4 * n;
        this.untransformRealZero(a, 0, h);
        int b = 2;
        int wb = 2;
        int k = n - 1;
        do {
            this.untransformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb += 2;
        } while (--k > 0);
        this.untransformRealHalf(a, b + 0, b + h);
        b += 2;
        wb -= 2;
        k = n - 1;
        do {
            this.untransformReal(a, b, b + h, w[wb + 0], w[wb + 1]);
            b += 2;
            wb -= 2;
        } while (--k > 0);
    }

    protected final void c2(double[] a, int off) {
        double t1 = a[off + 0] + a[off + 2];
        double t2 = a[off + 1] + a[off + 3];
        double t3 = a[off + 0] - a[off + 2];
        double t4 = a[off + 1] - a[off + 3];
        a[off + 0] = t1;
        a[off + 1] = t2;
        a[off + 2] = t3;
        a[off + 3] = t4;
    }

    protected final void r2(double[] a) {
        double t1 = a[0] + a[1];
        double t2 = a[0] - a[1];
        a[0] = t1;
        a[1] = t2;
    }

    protected final void c4(double[] a, int off) {
        int a0re = off + 0;
        int a1re = off + 2;
        int a2re = off + 4;
        int a3re = off + 6;
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t1 = a[a0re] - a[a2re];
        double t2 = a[a0im] - a[a2im];
        double t3 = a[a1re] - a[a3re];
        double t4 = a[a1im] - a[a3im];
        int n = a0re;
        a[n] = a[n] + a[a2re];
        int n2 = a0im;
        a[n2] = a[n2] + a[a2im];
        int n3 = a1re;
        a[n3] = a[n3] + a[a3re];
        int n4 = a1im;
        a[n4] = a[n4] + a[a3im];
        a[a2re] = t1 - t4;
        a[a2im] = t2 + t3;
        a[a3re] = t1 + t4;
        a[a3im] = t2 - t3;
        t1 = a[a0re] + a[a1re];
        t2 = a[a0im] + a[a1im];
        t3 = a[a0re] - a[a1re];
        t4 = a[a0im] - a[a1im];
        a[a0re] = t1;
        a[a0im] = t2;
        a[a1re] = t3;
        a[a1im] = t4;
    }

    protected final void u4(double[] a, int off) {
        int a0re = off + 0;
        int a1re = off + 2;
        int a2re = off + 4;
        int a3re = off + 6;
        int a0im = a0re + 1;
        int a1im = a1re + 1;
        int a2im = a2re + 1;
        int a3im = a3re + 1;
        double t1 = a[a0re] + a[a1re];
        double t2 = a[a0im] + a[a1im];
        double t3 = a[a0re] - a[a1re];
        double t4 = a[a0im] - a[a1im];
        a[a0re] = t1;
        a[a0im] = t2;
        a[a1re] = t3;
        a[a1im] = t4;
        t1 = a[a2re] + a[a3re];
        t2 = a[a2im] + a[a3im];
        t3 = a[a2im] - a[a3im];
        t4 = a[a3re] - a[a2re];
        a[a2re] = a[a0re] - t1;
        a[a2im] = a[a0im] - t2;
        a[a3re] = a[a1re] - t3;
        a[a3im] = a[a1im] - t4;
        int n = a0re;
        a[n] = a[n] + t1;
        int n2 = a0im;
        a[n2] = a[n2] + t2;
        int n3 = a1re;
        a[n3] = a[n3] + t3;
        int n4 = a1im;
        a[n4] = a[n4] + t4;
    }

    protected final void r4(double[] a) {
        this.transformRealZero(a, 0, 2);
        this.r2(a);
    }

    protected final void v4(double[] a) {
        this.r2(a);
        this.untransformRealZero(a, 0, 2);
    }

    protected final void c8(double[] a, int off) {
        this.transformZero(a, off + 0, off + 4, off + 8, off + 12);
        this.transformHalf(a, off + 2, off + 6, off + 10, off + 14);
        this.c4(a, off);
        this.c2(a, off + 4);
        this.c2(a, off + 6);
    }

    protected final void u8(double[] a, int off) {
        this.u4(a, off);
        this.c2(a, off + 4);
        this.c2(a, off + 6);
        this.untransformZero(a, off + 0, off + 4, off + 8, off + 12);
        this.untransformHalf(a, off + 2, off + 6, off + 10, off + 14);
    }

    protected final void r8(double[] a) {
        this.transformRealZero(a, 0, 4);
        this.transformRealHalf(a, 2, 6);
        this.r4(a);
        this.c2(a, 2);
    }

    protected final void v8(double[] a) {
        this.v4(a);
        this.c2(a, 2);
        this.untransformRealZero(a, 0, 4);
        this.untransformRealHalf(a, 2, 6);
    }

    protected final void c16(double[] a, int off) {
        this.cpass(a, off, this.d16, 2);
        this.c8(a, off);
        this.c4(a, off + 16);
        this.c4(a, off + 24);
    }

    protected final void u16(double[] a, int off) {
        this.u8(a, off);
        this.u4(a, off + 16);
        this.u4(a, off + 24);
        this.upass(a, off, this.d16, 2);
    }

    protected final void r16(double[] a) {
        this.rpass(a, this.d16, 2);
        this.r8(a);
        this.c4(a, 8);
    }

    protected final void v16(double[] a) {
        this.v8(a);
        this.u4(a, 8);
        this.vpass(a, this.d16, 2);
    }

    protected final void c32(double[] a, int off) {
        this.cpass(a, off, this.d32, 4);
        this.c16(a, off);
        this.c8(a, off + 32);
        this.c8(a, off + 48);
    }

    protected final void u32(double[] a, int off) {
        this.u16(a, off);
        this.u8(a, off + 32);
        this.u8(a, off + 48);
        this.upass(a, off, this.d32, 4);
    }

    protected final void r32(double[] a) {
        this.rpass(a, this.d32, 4);
        this.r16(a);
        this.c8(a, 16);
    }

    protected final void v32(double[] a) {
        this.v16(a);
        this.u8(a, 16);
        this.vpass(a, this.d32, 4);
    }

    protected final void c64(double[] a, int off) {
        this.cpass(a, off, this.d64, 8);
        this.c32(a, off);
        this.c16(a, off + 64);
        this.c16(a, off + 96);
    }

    protected final void u64(double[] a, int off) {
        this.u32(a, off);
        this.u16(a, off + 64);
        this.u16(a, off + 96);
        this.upass(a, off, this.d64, 8);
    }

    protected final void r64(double[] a) {
        this.rpass(a, this.d64, 8);
        this.r32(a);
        this.c16(a, 32);
    }

    protected final void v64(double[] a) {
        this.v32(a);
        this.u16(a, 32);
        this.vpass(a, this.d64, 8);
    }

    protected final void c128(double[] a, int off) {
        this.cpass(a, off, this.d128, 16);
        this.c64(a, off);
        this.c32(a, off + 128);
        this.c32(a, off + 192);
    }

    protected final void u128(double[] a, int off) {
        this.u64(a, off);
        this.u32(a, off + 128);
        this.u32(a, off + 192);
        this.upass(a, off, this.d128, 16);
    }

    protected final void r128(double[] a) {
        this.rpass(a, this.d128, 16);
        this.r64(a);
        this.c32(a, 64);
    }

    protected final void v128(double[] a) {
        this.v64(a);
        this.u32(a, 64);
        this.vpass(a, this.d128, 16);
    }

    protected final void c256(double[] a, int off) {
        this.cpass(a, off, this.d256, 32);
        this.c128(a, off);
        this.c64(a, off + 256);
        this.c64(a, off + 384);
    }

    protected final void u256(double[] a, int off) {
        this.u128(a, off);
        this.u64(a, off + 256);
        this.u64(a, off + 384);
        this.upass(a, off, this.d256, 32);
    }

    protected final void r256(double[] a) {
        this.rpass(a, this.d256, 32);
        this.r128(a);
        this.c64(a, 128);
    }

    protected final void v256(double[] a) {
        this.v128(a);
        this.u64(a, 128);
        this.vpass(a, this.d256, 32);
    }

    protected final void c512(double[] a, int off) {
        this.cpass(a, off, this.d512, 64);
        this.c256(a, off);
        this.c128(a, off + 512);
        this.c128(a, off + 768);
    }

    protected final void u512(double[] a, int off) {
        this.u256(a, off);
        this.u128(a, off + 512);
        this.u128(a, off + 768);
        this.upass(a, off, this.d512, 64);
    }

    protected final void r512(double[] a) {
        this.rpass(a, this.d512, 64);
        this.r256(a);
        this.c128(a, 256);
    }

    protected final void v512(double[] a) {
        this.v256(a);
        this.u128(a, 256);
        this.vpass(a, this.d512, 64);
    }

    protected final void cn(double[] a, int off, int log) {
        switch (log) {
            case 1: {
                this.c2(a, off);
                break;
            }
            case 2: {
                this.c4(a, off);
                break;
            }
            case 3: {
                this.c8(a, off);
                break;
            }
            case 4: {
                this.c16(a, off);
                break;
            }
            case 5: {
                this.c32(a, off);
                break;
            }
            case 6: {
                this.c64(a, off);
                break;
            }
            case 7: {
                this.c128(a, off);
                break;
            }
            case 8: {
                this.c256(a, off);
                break;
            }
            case 9: {
                this.c512(a, off);
                break;
            }
            default: {
                int size = 1 << log;
                this.cpassBig(a, off, this.roots[log], size / 8);
                this.cn(a, off, log - 1);
                this.cn(a, off + size, log - 2);
                this.cn(a, off + size + size / 2, log - 2);
            }
        }
    }

    protected final void un(double[] a, int off, int log) {
        switch (log) {
            case 1: {
                this.c2(a, off);
                break;
            }
            case 2: {
                this.u4(a, off);
                break;
            }
            case 3: {
                this.u8(a, off);
                break;
            }
            case 4: {
                this.u16(a, off);
                break;
            }
            case 5: {
                this.u32(a, off);
                break;
            }
            case 6: {
                this.u64(a, off);
                break;
            }
            case 7: {
                this.u128(a, off);
                break;
            }
            case 8: {
                this.u256(a, off);
                break;
            }
            case 9: {
                this.u512(a, off);
                break;
            }
            default: {
                int size = 1 << log;
                this.un(a, off, log - 1);
                this.un(a, off + size, log - 2);
                this.un(a, off + size + size / 2, log - 2);
                this.upassBig(a, off, this.roots[log], size / 8);
            }
        }
    }

    protected final void rn(double[] a, int log) {
        switch (log) {
            case 1: {
                this.r2(a);
                break;
            }
            case 2: {
                this.r4(a);
                break;
            }
            case 3: {
                this.r8(a);
                break;
            }
            case 4: {
                this.r16(a);
                break;
            }
            case 5: {
                this.r32(a);
                break;
            }
            case 6: {
                this.r64(a);
                break;
            }
            case 7: {
                this.r128(a);
                break;
            }
            case 8: {
                this.r256(a);
                break;
            }
            case 9: {
                this.r512(a);
                break;
            }
            default: {
                int size = 1 << log;
                this.rpassBig(a, this.roots[log], size / 8);
                this.rn(a, log - 1);
                this.cn(a, size / 2, log - 2);
            }
        }
    }

    protected final void vn(double[] a, int log) {
        switch (log) {
            case 1: {
                this.r2(a);
                break;
            }
            case 2: {
                this.v4(a);
                break;
            }
            case 3: {
                this.v8(a);
                break;
            }
            case 4: {
                this.v16(a);
                break;
            }
            case 5: {
                this.v32(a);
                break;
            }
            case 6: {
                this.v64(a);
                break;
            }
            case 7: {
                this.v128(a);
                break;
            }
            case 8: {
                this.v256(a);
                break;
            }
            case 9: {
                this.v512(a);
                break;
            }
            default: {
                int size = 1 << log;
                this.vn(a, log - 1);
                this.un(a, size / 2, log - 2);
                this.vpassBig(a, this.roots[log], size / 8);
            }
        }
    }

    private int log2(int size) {
        int log = 0;
        if (size >= 65536) {
            log += 16;
            size >>>= 16;
        }
        if (size >= 256) {
            log += 8;
            size >>>= 8;
        }
        if (size >= 16) {
            log += 4;
            size >>>= 4;
        }
        if (size >= 4) {
            log += 2;
            size >>>= 2;
        }
        if (size >= 2) {
            ++log;
        }
        return log;
    }

    public void forwFFT(double[] a) {
        this.cn(a, 0, this.log);
    }

    public void backFFT(double[] a) {
        this.un(a, 0, this.log);
    }

    public void forwRealFFT(double[] a) {
        this.rn(a, this.log + 1);
    }

    public void backRealFFT(double[] a) {
        this.vn(a, this.log + 1);
    }

    public void scale(double[] a) {
        double u = 1.0 / (double)this.length;
        int i = 0;
        while (i < this.length * 2) {
            int n = i++;
            a[n] = a[n] * u;
        }
    }

    public void scaleReal(double[] a) {
        double u = 1.0 / (double)(this.length * 2);
        a[0] = a[0] * u;
        a[1] = a[1] * u;
        u += u;
        int i = 2;
        while (i < this.length * 2) {
            int n = i++;
            a[n] = a[n] * u;
        }
    }

    public void mul(double[] a, double[] b) {
        int are = 0;
        int aim = 1;
        int i = 0;
        while (i < this.length) {
            double re = a[are] * b[are] - a[aim] * b[aim];
            double im = a[are] * b[aim] + a[aim] * b[are];
            a[are] = re;
            a[aim] = im;
            are += 2;
            aim += 2;
            ++i;
        }
    }

    public void mulReal(double[] a, double[] b) {
        a[0] = a[0] * b[0];
        a[1] = a[1] * b[1];
        int are = 2;
        int aim = 3;
        int i = 1;
        while (i < this.length) {
            double re = a[are] * b[are] - a[aim] * b[aim];
            double im = a[are] * b[aim] + a[aim] * b[are];
            a[are] = re;
            a[aim] = im;
            are += 2;
            aim += 2;
            ++i;
        }
    }

    private void doScramble(double[] a, int[] swaps, int[][] cycles) {
        double im;
        double re;
        int i = 0;
        while (i < swaps.length) {
            int p1 = swaps[i];
            int p2 = swaps[i + 1];
            re = a[p1 + 0];
            im = a[p1 + 1];
            a[p1 + 0] = a[p2 + 0];
            a[p1 + 1] = a[p2 + 1];
            a[p2 + 0] = re;
            a[p2 + 1] = im;
            i += 2;
        }
        i = 0;
        while (i < cycles.length) {
            int[] cycle = cycles[i];
            int p = cycle[cycle.length - 1];
            re = a[p + 0];
            im = a[p + 1];
            int j = cycle.length - 2;
            while (j >= 0) {
                int n = cycle[j];
                a[p + 0] = a[n + 0];
                a[p + 1] = a[n + 1];
                p = n;
                --j;
            }
            a[p + 0] = re;
            a[p + 1] = im;
            ++i;
        }
    }

    private void doUnscramble(double[] a, int[] swaps, int[][] cycles) {
        double im;
        double re;
        int i = 0;
        while (i < swaps.length) {
            int p1 = swaps[i];
            int p2 = swaps[i + 1];
            re = a[p1 + 0];
            im = a[p1 + 1];
            a[p1 + 0] = a[p2 + 0];
            a[p1 + 1] = a[p2 + 1];
            a[p2 + 0] = re;
            a[p2 + 1] = im;
            i += 2;
        }
        i = 0;
        while (i < cycles.length) {
            int[] cycle = cycles[i];
            int p = cycle[0];
            re = a[p + 0];
            im = a[p + 1];
            int j = 1;
            while (j < cycle.length) {
                int n = cycle[j];
                a[p + 0] = a[n + 0];
                a[p + 1] = a[n + 1];
                p = n;
                ++j;
            }
            a[p + 0] = re;
            a[p + 1] = im;
            ++i;
        }
    }

    public void scramble(double[] arr) {
        this.doScramble(arr, this.swapTable, this.scrambleTable);
    }

    public void unscramble(double[] a) {
        this.doUnscramble(a, this.swapTable, this.scrambleTable);
    }

    public void scrambleReal(double[] arr) {
        this.doScramble(arr, this.swapTableReal, this.scrambleTableReal);
    }

    public void unscrambleReal(double[] a) {
        this.doUnscramble(a, this.swapTableReal, this.scrambleTableReal);
    }

    private void fillRoot(double[] roots, int n, int div) {
        double cosInc = Math.cos(Math.PI * 2 / (double)n);
        double sinInc = Math.sin(Math.PI * 2 / (double)n);
        roots[0] = 1.0;
        roots[1] = 0.0;
        double lre = 1.0;
        double lim = 0.0;
        int i = 1;
        while (i < n / div) {
            double re = cosInc * lre - sinInc * lim;
            double im = sinInc * lre + cosInc * lim;
            lre = re;
            lim = im;
            roots[i * 2 + 0] = re;
            roots[i * 2 + 1] = im;
            ++i;
        }
    }

    private void fillRoot(double[] roots, double[] next) {
        int n = next.length / 4;
        int i = 0;
        while (i < n) {
            roots[i * 2 + 0] = next[i * 4 + 0];
            roots[i * 2 + 1] = next[i * 4 + 1];
            ++i;
        }
    }

    private void init(int length) {
        int log = 0;
        int ln = 1;
        while (ln < length) {
            ln *= 2;
            ++log;
        }
        this.roots = new double[(log < 10 ? 10 : log) * 2 + 4][];
        int i = this.roots.length - 1;
        while (i >= 3) {
            int size = 1 << i;
            this.roots[i] = new double[size / 4];
            this.fillRoot(this.roots[i], size, 8);
            --i;
        }
        this.fillRoot(this.d512, 512, 4);
        this.fillRoot(this.d256, this.d512);
        this.fillRoot(this.d128, this.d256);
        this.fillRoot(this.d64, this.d128);
        this.fillRoot(this.d32, this.d64);
        this.fillRoot(this.d16, this.d32);
    }

    public static void main(String[] args) {
        int Log2 = 10;
        int Size = 1024;
        System.out.println("Computing forward and backward FFT (including scrambling/unscrambling) of 2048 real samples between -1.0 and 1.0");
        double[] arr = new double[2048];
        double[] chk = new double[2048];
        RFFT3 fft = new RFFT3(1024);
        Random random = new Random(0L);
        int i = 0;
        while (i < arr.length / 2) {
            arr[i * 2 + 0] = random.nextDouble() * 2.0 - 1.0;
            arr[i * 2 + 1] = random.nextDouble() * 2.0 - 1.0;
            chk[i * 2 + 0] = arr[i * 2 + 0];
            chk[i * 2 + 1] = arr[i * 2 + 1];
            ++i;
        }
        fft.forwRealFFT(arr);
        fft.scaleReal(arr);
        fft.backRealFFT(arr);
        double err = 0.0;
        int i2 = 0;
        while (i2 < 2048) {
            err += Math.abs(arr[i2] - chk[i2]);
            ++i2;
        }
        System.out.println("Average absolute error: " + err / 1024.0);
        long[] times = new long[50];
        long sum = 0L;
        System.out.println("Testing speed of 1000 computations " + times.length + " times...");
        int j = 0;
        while (j < times.length) {
            long time = System.currentTimeMillis();
            int i3 = 0;
            while (i3 < 1000) {
                fft.forwRealFFT(arr);
                fft.scaleReal(arr);
                fft.backRealFFT(arr);
                ++i3;
            }
            time = System.currentTimeMillis() - time;
            if (j >= 0) {
                times[j] = time;
                if (j != 0) {
                    sum += time;
                }
            }
            ++j;
        }
        Arrays.sort(times);
        System.out.println("Average time (ms): " + (double)sum / (double)(times.length - 1));
        System.out.println("Minimum time (ms): " + times[0]);
    }
}

