/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.fft;

import java.util.Map;
import java.util.WeakHashMap;
import org.corebounce.common.math.Cmplx;

public class UnityRoots {
    private static UnityRoots generator;
    private Map<Integer, Cmplx[]> nToRoots = new WeakHashMap<Integer, Cmplx[]>();

    private UnityRoots() {
    }

    public static synchronized UnityRoots getInstance() {
        if (generator == null) {
            generator = new UnityRoots();
        }
        return generator;
    }

    public synchronized Cmplx[] getRoots(int div, int count) {
        Cmplx[] roots = this.nToRoots.get(div);
        if (roots == null) {
            roots = Cmplx.newArray(count);
            double cosInc = Math.cos(Math.PI * 2 / (double)div);
            double sinInc = Math.sin(Math.PI * 2 / (double)div);
            roots[0].set(1.0f, 0.0f);
            double lre = 1.0;
            double lim = 0.0;
            int i = 1;
            while (i < count) {
                double re = cosInc * lre - sinInc * lim;
                double im = sinInc * lre + cosInc * lim;
                lre = re;
                lim = im;
                roots[i].set((float)re, (float)im);
                ++i;
            }
            this.nToRoots.put(div, roots);
        } else if (roots.length < count) {
            Cmplx[] nroots = Cmplx.newArray(count);
            System.arraycopy(roots, 0, nroots, 0, roots.length);
            double cosInc = Math.cos(Math.PI * 2 / (double)div);
            double sinInc = Math.sin(Math.PI * 2 / (double)div);
            double lre = Math.cos(Math.PI * 2 * (double)(roots.length - 1) / (double)div);
            double lim = Math.sin(Math.PI * 2 * (double)(roots.length - 1) / (double)div);
            int i = roots.length;
            while (i < count) {
                double re = cosInc * lre - sinInc * lim;
                double im = sinInc * lre + cosInc * lim;
                lre = re;
                lim = im;
                nroots[i].set((float)re, (float)im);
                ++i;
            }
            this.nToRoots.put(div, nroots);
            roots = nroots;
        }
        return roots;
    }
}

