/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.fft;

import java.util.Arrays;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

public class Windows {
    public static final float[] HannCoefs = new float[]{0.5f, -0.25f};
    public static final float[] HammingCoefs = new float[]{0.53836f, -0.23082f};
    public static final float[] BlackmannCoefs = new float[]{0.42f, -0.25f, 0.04f};
    public static final float[] NutallCoefs = new float[]{0.3633582f, -0.24458875f, 0.06829975f, -0.00532055f};
    public static final float[] FlatTopCoefs = new float[]{0.25f, -0.24125f, 0.16125f, -0.04225f, 0.004f};

    public static void fillWindow(float[] window, int size, float[] coefs) {
        int i = 0;
        while (i < size) {
            double x = Math.PI * 2 * (double)(i + 1) / (double)(size + 1);
            double val = coefs[0];
            int c = 1;
            while (c < coefs.length) {
                val += (double)(coefs[c] * 2.0f) * Math.cos(x * (double)c);
                ++c;
            }
            window[i] = (float)val;
            ++i;
        }
    }

    public static void fillWindow(float[] window, float[] coefs) {
        Windows.fillWindow(window, window.length, coefs);
    }

    public static void fillShrunkWindow(float[] window, float[] coefs, float shrink) {
        Windows.fillShrunkWindow(window, coefs, shrink, true);
    }

    public static void fillShrunkWindow(float[] window, float[] coefs, float shrink, boolean energyCorrection) {
        int shrunkSize = (int)((float)window.length / shrink + 0.5f);
        Windows.fillWindow(window, shrunkSize, coefs);
        int start = (window.length - shrunkSize) / 2;
        int stop = start + shrunkSize;
        System.arraycopy(window, 0, window, start, shrunkSize);
        if (shrink != 1.0f && energyCorrection) {
            float correction = (float)Math.sqrt(shrink);
            int i = start;
            while (i < stop) {
                int n = i++;
                window[n] = window[n] * correction;
            }
        }
        Arrays.fill(window, 0, start, 0.0f);
        Arrays.fill(window, stop, window.length, 0.0f);
    }

    public static void fillTriangularWindow(float[] window, int size) {
        int half = size / 2;
        int i = 0;
        while (i < half) {
            float value;
            window[i] = value = (float)i / (float)half;
            window[i + half] = 1.0f - value;
            ++i;
        }
    }

    private static double iZero(double x) {
        double temp;
        double epsilon = 1.0E-21;
        double sum = 1.0;
        double u = 1.0;
        long n = 1L;
        double halfx = x / 2.0;
        do {
            temp = halfx / (double)n;
            ++n;
        } while ((u *= (temp *= temp)) >= 1.0E-21 * (sum += u));
        return sum;
    }

    public static void fillKaiserWindow(float[] window, int size, float db) {
        double p = (double)size / 2.0;
        double beta = 0.0;
        beta = db >= 50.0f ? 0.1102 * ((double)db - 8.7) : (db > 21.0f ? 0.5842 * Math.pow((double)db - 21.0, 0.4) + 0.07886 * ((double)db - 21.0) : 0.0);
        double ibeta = 1.0 / Windows.iZero(beta);
        int i = 0;
        while (i < size) {
            double x = ((double)i - p) / p;
            double val = Windows.iZero(beta * Math.sqrt(1.0 - x * x)) * ibeta;
            window[i] = (float)val;
            ++i;
        }
    }

    public static void fillGaussianWindow(float[] window, int size) {
        Windows.fillGaussianWindow(window, size, 0.4f);
    }

    public static void fillGaussianWindow(float[] window, int size, float sigma) {
        if (sigma <= 0.0f || sigma > 0.5f) {
            throw new IllegalArgumentException("'sigma' must be between 0 and 0.5");
        }
        float half = (float)(size - 1) / 2.0f;
        int i = 0;
        while (i < size) {
            double x = ((double)i - (double)half) / (double)(sigma * half);
            window[i] = (float)Math.exp(-0.5 * x * x);
            ++i;
        }
    }

    private static double acosh(double arg) {
        return Math.log(arg + Math.sqrt(arg * arg - 1.0));
    }

    public static void fillChebyshevWindow(float[] window, float db, BooFFT fft) {
        int length = fft.size();
        Cmplx[] cebf = new Cmplx[length];
        float gamma = db / 20.0f;
        float denom = (float)Math.pow(10.0, gamma);
        float alpha = (float)Math.cosh(Windows.acosh(denom) / (double)length);
        denom = 1.0f / denom;
        int i = 0;
        while (i < length) {
            Cmplx val = new Cmplx(alpha, 0.0f);
            val.mul((float)Math.cos(Math.PI * (double)i / (double)length));
            val.acos();
            val.mul(length);
            val.cos();
            val.mul(denom);
            cebf[i] = val;
            ++i;
        }
        Cmplx[] cebt = Cmplx.newArray(length);
        fft.backC2C(cebf, cebt);
        float max = 0.0f;
        int i2 = 0;
        while (i2 < length) {
            if (cebt[i2].re > max) {
                max = cebt[i2].re;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            window[i2] = cebt[(i2 + length / 2) % length].re / max;
            ++i2;
        }
    }

    public static void shrink(float[] window, float shrink) {
        Windows.shrink(window, shrink, true);
    }

    public static void shrink(float[] window, float shrink, boolean energyCorrection) {
        int shrunkSize = (int)((float)window.length / shrink + 0.5f);
        int i = 0;
        while (i < shrunkSize) {
            window[i] = window[Math.min((int)((float)i * shrink + 0.5f), window.length - 1)];
            ++i;
        }
        int start = (window.length - shrunkSize) / 2;
        int stop = start + shrunkSize;
        System.arraycopy(window, 0, window, start, shrunkSize);
        if (shrink != 1.0f && energyCorrection) {
            float correction = (float)Math.sqrt(shrink);
            int i2 = start;
            while (i2 < stop) {
                int n = i2++;
                window[n] = window[n] * correction;
            }
        }
        Arrays.fill(window, 0, start, 0.0f);
        Arrays.fill(window, stop, window.length, 0.0f);
    }

    public static boolean fillInverseWindow(float[] preWindow, float[] postWindow, float[] inverse, int blockSize, int hopSize) {
        boolean success = true;
        int nbSteps = blockSize / hopSize;
        int i = 0;
        while (i < hopSize) {
            float sum = 0.0f;
            int j = i;
            int s = 0;
            while (s < nbSteps) {
                sum += preWindow[j] * postWindow[j];
                j += hopSize;
                ++s;
            }
            if (sum > 0.05f) {
                inverse[i] = 1.0f / sum;
            } else {
                inverse[i] = 0.0f;
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static float getStdEnergy(int length) {
        float result = 0.25f * (float)length;
        return (float)Math.sqrt(result);
    }

    public static float getPostEnergy(float[] preWindow, float[] postWindow) {
        assert (preWindow.length == postWindow.length);
        float result = 0.0f;
        int i = 0;
        while (i < preWindow.length) {
            float prod = preWindow[i] * postWindow[i];
            result += prod * prod;
            ++i;
        }
        return (float)Math.sqrt(result);
    }

    public static boolean fillInverseWindow(float[][] preWindows, int preIndex, float[] energies, float[] postWindow, float[] inverse, int windowSize, int overlapShift) {
        int nbSteps = windowSize / overlapShift;
        float std = Windows.getStdEnergy(postWindow.length);
        boolean success = true;
        int i = 0;
        while (i < overlapShift) {
            float sum = 0.0f;
            int j = i;
            int winNum = preIndex;
            int s = 0;
            while (s < nbSteps) {
                sum += preWindows[winNum][j] * (std / energies[winNum]) * postWindow[j];
                j += overlapShift;
                if (--winNum < 0) {
                    winNum += preWindows.length;
                }
                ++s;
            }
            if (sum > 0.05f) {
                inverse[i] = 1.0f / sum;
            } else {
                inverse[i] = 0.0f;
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static float getHannCorrection(int overlapping, int count) {
        if (overlapping <= count) {
            throw new IllegalArgumentException("Constant value only if overlapping > count");
        }
        return 4.0f / (float)overlapping * (float)count / (float)(count + 1);
    }

    public static void convolve2(Cmplx[] f, float c0, float c1) {
        int size = f.length - 1;
        float pre = f[0].re;
        float pim = f[0].im;
        f[0].re = f[0].re * c0 + f[1].re * c1 * 2.0f;
        int i = 1;
        while (i < size) {
            float re = f[i].re * c0 + (pre + f[i + 1].re) * c1;
            float im = f[i].im * c0 + (pim + f[i + 1].im) * c1;
            pre = f[i].re;
            pim = f[i].im;
            f[i].re = re;
            f[i].im = im;
            ++i;
        }
        f[size].re = f[size].re * c0 + pre * c1 * 2.0f;
    }

    public static void convolveHann(Cmplx[] f) {
        int size = f.length - 1;
        float pre = f[0].re;
        float pim = f[0].im;
        f[0].re = f[0].re * 0.5f - f[1].re * 0.5f;
        int i = 1;
        while (i < size) {
            float re = f[i].re * 0.5f - (pre + f[i + 1].re) * 0.25f;
            float im = f[i].im * 0.5f - (pim + f[i + 1].im) * 0.25f;
            pre = f[i].re;
            pim = f[i].im;
            f[i].re = re;
            f[i].im = im;
            ++i;
        }
        f[size].re = f[size].re * 0.5f - pre * 0.5f;
    }

    public static void convolve3(Cmplx[] f, float c0, float c1, float c2) {
        float pre2 = f[0].re;
        float pim2 = f[0].im;
        float pre1 = f[1].re;
        float pim1 = f[1].im;
        f[0].re = f[0].re * c0 + f[1].re * c1 * 2.0f + f[2].re * c2 * 2.0f;
        f[1].re = f[1].re * c0 + (pre2 + f[2].re) * c1 + (f[1].re + f[3].re) * c2;
        f[1].im = f[1].im * c0 + (pim2 + f[2].im) * c1 + (-f[1].im + f[3].im) * c2;
        int i = 2;
        while (i < f.length - 2) {
            float re = f[i].re * c0 + (pre1 + f[i + 1].re) * c1 + (pre2 + f[i + 2].re) * c2;
            float im = f[i].im * c0 + (pim1 + f[i + 1].im) * c1 + (pim2 + f[i + 2].im) * c2;
            pre2 = pre1;
            pim2 = pim1;
            pre1 = f[i].re;
            pim1 = f[i].im;
            f[i].re = re;
            f[i].im = im;
            ++i;
        }
        int nq1 = f.length - 2;
        int nq0 = f.length - 1;
        float nq1re = f[nq1].re;
        f[nq1].re = f[nq1].re * c0 + (pre1 + f[nq0].re) * c1 + (pre2 + f[nq1].re) * c2;
        f[nq1].im = f[nq1].im * c0 + (pim1 + f[nq0].im) * c1 + (pim2 - f[nq1].im) * c2;
        f[nq0].re = f[nq0].re * c0 + nq1re * c1 * 2.0f + pre1 * c2 * 2.0f;
    }

    public static void convolveX(Cmplx[] f, float[] c) {
        int j;
        float re;
        if (c.length == 2) {
            Windows.convolve2(f, c[0], c[1]);
            return;
        }
        if (c.length == 3) {
            Windows.convolve3(f, c[0], c[1], c[2]);
            return;
        }
        Cmplx[] b = Cmplx.newArray(c.length);
        int i = 0;
        while (i < c.length) {
            b[i].copyFrom(f[i]);
            ++i;
        }
        i = 0;
        while (i < c.length) {
            float re2 = f[i].re * c[0];
            float im = f[i].im * c[0];
            int j2 = 1;
            while (j2 < c.length) {
                int k = j2 > i ? j2 - i : i - j2;
                float s = j2 > i ? -1.0f : 1.0f;
                re2 += (b[k].re + f[i + j2].re) * c[j2];
                im += (b[k].im * s + f[i + j2].im) * c[j2];
                ++j2;
            }
            f[i].set(re2, im);
            ++i;
        }
        int bi = c.length - 1;
        int i2 = c.length;
        while (i2 < f.length - c.length) {
            bi = (bi + 1) % c.length;
            re = f[i2].re * c[0];
            float im = f[i2].im * c[0];
            j = 1;
            while (j < c.length) {
                int k = (bi + c.length - j) % c.length;
                re += (b[k].re + f[i2 + j].re) * c[j];
                im += (b[k].im + f[i2 + j].im) * c[j];
                ++j;
            }
            b[bi].copyFrom(f[i2]);
            f[i2].set(re, im);
            ++i2;
        }
        i2 = f.length - c.length;
        while (i2 < f.length) {
            bi = (bi + 1) % c.length;
            re = f[i2].re * c[0];
            float im = f[i2].im * c[0];
            j = 1;
            while (j < c.length) {
                int k = (bi + c.length - j) % c.length;
                int r = i2 + j;
                float s = 1.0f;
                if (r >= f.length) {
                    r = (f.length - 1) * 2 - r;
                    s = -1.0f;
                }
                re += (b[k].re + f[r].re) * c[j];
                im += (b[k].im + f[r].im * s) * c[j];
                ++j;
            }
            b[bi].copyFrom(f[i2]);
            f[i2].set(re, im);
            ++i2;
        }
        b = null;
    }

    public static void main(String[] args) {
        int Size = 32;
        float[] window = new float[32];
        BooFFT fft = new BooFFT(32);
        int db = 20;
        while (db <= 200) {
            System.out.println();
            System.out.println("*** sidelobe level (db): -" + db);
            Windows.fillChebyshevWindow(window, db, fft);
            int i = 0;
            while (i < 32) {
                int c = (int)(window[i] * 64.0f + 0.5f);
                int j = 0;
                while (j < c) {
                    System.out.print("H");
                    ++j;
                }
                System.out.println();
                ++i;
            }
            db += 10;
        }
    }
}

