/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.Filter;

class CascadeFilter
extends Filter {
    double[] a1;
    double[] a2;
    double[] b0;
    double[] b1;
    double[] b2;
    int size;
    Complex cm2;
    Complex cm1;
    Complex top;
    Complex bottom;

    CascadeFilter(DFilterFrame dFilterFrame, int s) {
        super(dFilterFrame);
        this.size = s;
        this.a1 = new double[s];
        this.a2 = new double[s];
        this.b0 = new double[s];
        this.b1 = new double[s];
        this.b2 = new double[s];
        int i = 0;
        while (i != s) {
            this.b0[i] = 1.0;
            ++i;
        }
    }

    @Override
    double[] createState() {
        return new double[this.size * 3];
    }

    void setAStage(double x1, double x2) {
        int i = 0;
        while (i != this.size) {
            if (this.a1[i] == 0.0 && this.a2[i] == 0.0) {
                this.a1[i] = x1;
                this.a2[i] = x2;
                return;
            }
            if (this.a2[i] == 0.0 && x2 == 0.0) {
                this.a2[i] = -this.a1[i] * x1;
                int n = i;
                this.a1[n] = this.a1[n] + x1;
                return;
            }
            ++i;
        }
        System.out.println("setAStage failed");
    }

    void setBStage(double x0, double x1, double x2) {
        int i = 0;
        while (i != this.size) {
            if (this.b1[i] == 0.0 && this.b2[i] == 0.0) {
                this.b0[i] = x0;
                this.b1[i] = x1;
                this.b2[i] = x2;
                return;
            }
            if (this.b2[i] == 0.0 && x2 == 0.0) {
                this.b2[i] = this.b1[i] * x1;
                this.b1[i] = this.b1[i] * x0 + this.b0[i] * x1;
                int n = i;
                this.b0[n] = this.b0[n] * x0;
                return;
            }
            ++i;
        }
        System.out.println("setBStage failed");
    }

    @Override
    void run(double[] inBuf, double[] outBuf, int bp, int mask, int count, double[] state) {
        double in = 0.0;
        int i2 = 0;
        while (i2 != count) {
            int fi2 = bp + i2;
            int i20 = fi2 & mask;
            in = inBuf[i20];
            int j = 0;
            while (j != this.size) {
                int j3 = j * 3;
                double d = state[j3 + 1];
                state[j3 + 2] = d;
                double d2 = d;
                double d3 = state[j3];
                state[j3 + 1] = d3;
                double d1 = d3;
                double d0 = state[j3] = in + this.a1[j] * d1 + this.a2[j] * d2;
                in = this.b0[j] * d0 + this.b1[j] * d1 + this.b2[j] * d2;
                ++j;
            }
            outBuf[i20] = in;
            ++i2;
        }
    }

    @Override
    void evalTransfer(Complex c) {
        if (this.cm1 == null) {
            this.cm1 = new Complex();
            this.cm2 = new Complex();
            this.top = new Complex();
            this.bottom = new Complex();
        }
        this.cm1.set(c);
        this.cm1.recip();
        this.cm2.set(this.cm1);
        this.cm2.square();
        c.set(1.0);
        int i = 0;
        while (i != this.size) {
            this.top.set(this.b0[i]);
            this.top.addMult(this.b1[i], this.cm1);
            this.top.addMult(this.b2[i], this.cm2);
            this.bottom.set(1.0);
            this.bottom.addMult(-this.a1[i], this.cm1);
            this.bottom.addMult(-this.a2[i], this.cm2);
            c.mult(this.top);
            c.div(this.bottom);
            ++i;
        }
    }

    @Override
    int getImpulseOffset() {
        return 0;
    }

    @Override
    int getStepOffset() {
        return 0;
    }

    @Override
    int getLength() {
        return 1;
    }
}

