/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.PoleFilterType;

abstract class ChebyFilterType
extends PoleFilterType {
    private final DFilterFrame dFilterFrame;
    double epsilon;
    int sign;

    ChebyFilterType(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
        this.dFilterFrame = dFilterFrame;
    }

    void selectCheby(int s) {
        this.dFilterFrame.auxLabels[s].setText("Passband Ripple");
        this.dFilterFrame.auxBars[s].setValue(60);
    }

    void setupCheby(int a) {
        int val = this.dFilterFrame.auxBars[a].getValue();
        double ripdb = 0.0;
        ripdb = val < 300 ? (double)(5 * val) / 300.0 : 5.0 + (double)(45 * (val - 300)) / 700.0;
        double ripval = Math.exp(-ripdb * 0.1 * 2.302585092994046);
        this.epsilon = Math.sqrt(1.0 / ripval - 1.0);
    }

    @Override
    void getSPole(int i, Complex c1, double wc) {
        double alpha = 1.0 / this.epsilon + Math.sqrt(1.0 + 1.0 / (this.epsilon * this.epsilon));
        double a = 0.5 * (Math.pow(alpha, 1.0 / (double)this.n) - Math.pow(alpha, -1.0 / (double)this.n));
        double b = 0.5 * (Math.pow(alpha, 1.0 / (double)this.n) + Math.pow(alpha, -1.0 / (double)this.n));
        double theta = 1.5707963267948966 + (double)(2 * i + 1) * Math.PI / (double)(2 * this.n);
        if (this.sign == -1) {
            wc = Math.PI - wc;
        }
        c1.setMagPhase(Math.tan(wc * 0.5), theta);
        c1.re *= a;
        c1.im *= b;
        c1.setMagPhase();
    }

    void getInfoCheby(String[] x) {
        x[2] = "Ripple: " + this.dFilterFrame.showFormat.format(-10.0 * Math.log(1.0 / (1.0 + this.epsilon * this.epsilon)) / 2.302585092994046) + " dB";
    }
}

