/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.ChebyFilterType;
import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;

class ChebyLowPass
extends ChebyFilterType {
    ChebyLowPass(DFilterFrame frame) {
        super(frame);
        this.sign = 1;
    }

    @Override
    int select() {
        int s = this.selectLowPass();
        this.selectCheby(s++);
        return s;
    }

    @Override
    void setup() {
        this.setupLowPass();
        this.setupCheby(2);
    }

    @Override
    void getPole(int i, Complex c1) {
        super.getPole(i, c1);
        c1.mult(this.sign);
    }

    @Override
    void getZero(int i, Complex c1) {
        c1.set(-this.sign);
    }

    @Override
    int getPoleCount() {
        return this.n;
    }

    @Override
    int getZeroCount() {
        return this.n;
    }

    @Override
    void getInfo(String[] x) {
        x[0] = "Chebyshev (IIR), " + this.getPoleCount() + "-pole";
        this.getInfoLowPass(x);
        this.getInfoCheby(x);
    }
}

